'****************************************************************
'*  Name    : ReEnterPBP-18xvLP.bas                             *
'*  Author  : based on work by Darrel Taylor / Timothy Box      *
'*  Date    : JUL 14, 2022                                      *
'*  Version : 2.2                                               *
'*  Notes   : Allows re-entry to PBP from a Low Priority        *
'*          :                               ASM interrupt       *
'*          : Must have DT_INTS_18XV.bas and ReEnterPBP-18XV.bas*
'*          : loaded first                                      *
'****************************************************************
'*  Versions:                                                   *
'*   2.2  JUL 14, 2022                                          *
'*        change DEFINEs so DT_INTS_18XV can detect this file   *
'*   2.1  JUN 30, 2022                                          *
'*        split into PBPW/PBPL code to reduce ram if not req'd  *
'*        for PBPW, drops ram from 30 words to 20 words         *
'*   2.0  JUN 20, 2022                                          *
'*        revamp for DT_INTS_18XV.bas                           *
'*        reduce variables from 34 words to 30 words...         *
'*        (PROD and TBLPTR now saved by DT_INTS_18XV)           *
'*        change VarsSaved_L to PBPVarsSaved_L (DT_INTS_18XV)   *
'****************************************************************
DISABLE DEBUG

#ifndef DT_INTS_18XV
  #error "this module requires a compatable DT_INTS_18XV version"
#endif
' define added for DT_INTS_18XV
DEFINE REENTERPBP_18XVLP 1

' see ReEnterPBP-18xv.bas for a discussion of system variables and asm
' macros used here (MOVE?TEMP?REG)

' PBPVarsSaved_L part of DT_INTS_18XV INT_Flags located in the access bank 
PBPVarsSaved_L = 0
goto OverReEnterL

' Save locations for PBP system vars during Low Priority Interrupts
#if (__LONG__)                      ' PBPL
LP_Vars  var  long [16]             ' group vars together (16*4=64 bytes)
    R0_SaveL      var LP_Vars[0]        ' system register R0, long
    R1_SaveL      var LP_Vars[1]        ' system register R1, long
    R2_SaveL      var LP_Vars[2]        ' system register R2, long
    R3_SaveL      var LP_Vars[3]        ' system register R3, long
    R4_R5_L       var LP_Vars[4]
      R4_SaveL      var R4_R5_L.word0   ' system register R4, word
      R5_SaveL      var R4_R5_L.word1   ' system register R5, word
    R6_R7_L       var LP_Vars[5]
      R6_SaveL      var R6_R7_L.word0   ' system register R6, word
      R7_SaveL      var R6_R7_L.word1   ' system register R7, word
    R8_L          var LP_Vars[6]
      R8_SaveL      var R8_L.word0      ' system register R8, word
    RM_RR_L       var LP_Vars[7]        ' RM and RR registers, byte
      RM1_SaveL     var RM_RR_L.byte0
      RM2_SaveL     var RM_RR_L.byte1
      RR1_SaveL     var RM_RR_L.byte2
      RR2_SaveL     var RM_RR_L.byte3
    RS_GOP_FLAGS_L var LP_Vars[8]       ' RS, GOP, and FLAGS registers, byte
      RS1_SaveL     var RS_GOP_FLAGS_L.byte0
      RS2_SaveL     var RS_GOP_FLAGS_L.byte1
      GOP_SaveL     var RS_GOP_FLAGS_L.byte2
      FLAGS_SaveL   var RS_GOP_FLAGS_L.byte3
    T1_SaveL      var LP_Vars[9]        ' PBP temp vars T1-T7, long (PBPL)
    T2_SaveL      var LP_Vars[10]
    T3_SaveL      var LP_Vars[11]
    T4_SaveL      var LP_Vars[12]
    T5_SaveL      var LP_Vars[13]
    T6_SaveL      var LP_Vars[14]
    T7_SaveL      var LP_Vars[15]
#else                               ' PBPW
LP_Vars  var  word [20]             ' group vars together (20*2=40 bytes)
    R0_SaveL      var LP_Vars[0]        ' system register R0, word
    R1_SaveL      var LP_Vars[1]        ' system register R1, word
    R2_SaveL      var LP_Vars[2]        ' system register R2, word
    R3_SaveL      var LP_Vars[3]        ' system register R3, word
    R4_SaveL      var LP_Vars[4]        ' system register R4, word
    R5_SaveL      var LP_Vars[5]        ' system register R5, word
    R6_SaveL      var LP_Vars[6]        ' system register R6, word
    R7_SaveL      var LP_Vars[7]        ' system register R7, word
    R8_SaveL      var LP_Vars[8]        ' system register R8, word
    RM_L          var LP_Vars[9]
      RM1_SaveL     var RM_L.byte0      ' Pin 1 Mask, byte
      RM2_SaveL     var RM_L.byte1      ' Pin 2 Mask, byte
    RR_L          var LP_Vars[10]
      RR1_SaveL     var RR_L.byte0      ' Pin 1 Register, byte
      RR2_SaveL     var RR_L.byte1      ' Pin 2 Register, byte
    RS_L            var LP_Vars[11]
      RS1_SaveL     var RS_L.byte0      ' Pin 1 Bank, byte
      RS2_SaveL     var RS_L.byte1      ' Pin 2 Bank, byte
    GOP_FLAGS_L   var LP_Vars[12]
      GOP_SaveL     var GOP_FLAGS_L.byte0   ' Gen Op Parameter GOP, byte
      FLAGS_SaveL   var GOP_FLAGS_L.byte1   ' Static flags FLAGS, byte
    T1_SaveL      var LP_Vars[13]       ' PBP temp vars T1-T7, word (PBPW)
    T2_SaveL      var LP_Vars[14]
    T3_SaveL      var LP_Vars[15]
    T4_SaveL      var LP_Vars[16]
    T5_SaveL      var LP_Vars[17]
    T6_SaveL      var LP_Vars[18]
    T7_SaveL      var LP_Vars[19]
#endif

SavePBP_L:               ' Save all PBP system vars Low Priority
  if (PBPVarsSaved_L = 0) then
    R0_SaveL = R0
    R1_SaveL = R1
    R2_SaveL = R2
    R3_SaveL = R3
    R4_SaveL = R4
    R5_SaveL = R5
    R6_SaveL = R6
    R7_SaveL = R7
    R8_SaveL = R8
    GOP_SaveL = GOP
    Flags_SaveL = FLAGS
    RR1_SaveL = RR1
    RS1_SaveL = RS1
    RM1_SaveL = RM1
    RR2_SaveL = RR2
    RS2_SaveL = RS2
    RM2_SaveL = RM2
    ASM
      ifdef T1
        MOVE?TEMP?REG  T1, _T1_SaveL
      endif
      ifdef T2
        MOVE?TEMP?REG  T2, _T2_SaveL
      endif
      ifdef T3
        MOVE?TEMP?REG  T3, _T3_SaveL
      endif
      ifdef T4
        MOVE?TEMP?REG  T4, _T4_SaveL
      endif
      ifdef T5
        MOVE?TEMP?REG  T5, _T5_SaveL
      endif
      ifdef T6
        MOVE?TEMP?REG  T6, _T6_SaveL
      endif
      ifdef T7
        MOVE?TEMP?REG  T7, _T7_SaveL
      endif
      ifdef T8
        ifndef NO_T7_WARNING
          messg "PBP temp variables exceed T7 and will NOT be saved!!"
        endif
      endif
    ENDASM   
    PBPVarsSaved_L = 1
  endif
@ INT_RETURN

RestorePBP_L:
  if (PBPVarsSaved_L = 1) then
    R0 = R0_SaveL
    R1 = R1_SaveL
    R2 = R2_SaveL
    R3 = R3_SaveL
    R4 = R4_SaveL
    R5 = R5_SaveL
    R6 = R6_SaveL
    R7 = R7_SaveL
    R8 = R8_SaveL
    GOP = GOP_SaveL
    FLAGS = Flags_SaveL
    RR1 = RR1_SaveL
    RS1 = RS1_SaveL
    RM1 = RM1_SaveL
    RR2 = RR2_SaveL
    RS2 = RS2_SaveL
    RM2 = RM2_SaveL
    ASM
      ifdef T1
        MOVE?TEMP?REG  _T1_SaveL, T1
      endif
      ifdef T2
        MOVE?TEMP?REG  _T2_SaveL, T2
      endif
      ifdef T3
        MOVE?TEMP?REG  _T3_SaveL, T3
      endif
      ifdef T4
        MOVE?TEMP?REG  _T4_SaveL, T4
      endif
      ifdef T5
        MOVE?TEMP?REG  _T5_SaveL, T5
      endif
      ifdef T6
        MOVE?TEMP?REG  _T6_SaveL, T6
      endif
      ifdef T7
        MOVE?TEMP?REG  _T7_SaveL, T7
      endif
    ENDASM
    PBPVarsSaved_L = 0
  endif
@ INT_RETURN

OverReEnterL:
ENABLE DEBUG
