'****************************************************************
'*  Name    : ReEnterPBP-18xv.bas                               *
'*  Author  : based on work by Darrel Taylor / Timothy Box      *
'*  Date    : JUL 14, 2022                                      *
'*  Version : 2.2                                               *
'*  Notes   : Allows re-entry to PBP from a High Priority       *
'*          :                               ASM interrupt       *
'*          : Must have DT_INTS_18XV.bas loaded first           *
'****************************************************************
'*  Versions:                                                   *
'*   2.2  JUL 14, 2022                                          *
'*        change DEFINEs so DT_INTS_18XV can detect this file   *
'*   2.1  JUN 30, 2022                                          *
'*        split into PBPW/PBPL code to reduce ram if not req'd  *
'*        for PBPW, drops ram from 30 words to 20 words         *
'*   2.0  JUN 20, 2022                                          *
'*        revamp for DT_INTS_18XV.bas                           *
'*        reduce variables from 34 words to 30 words...         *
'*        (PROD and TBLPTR now saved by DT_INTS_18XV)           *
'*        change VarsSaved_H to PBPVarsSaved_H (DT_INTS_18XV)   *
'****************************************************************
DISABLE DEBUG

#ifndef DT_INTS_18XV
  #error "this module requires a compatable DT_INTS_18XV version"
#endif
' define added for DT_INTS_18XV
DEFINE REENTERPBP_18XV 1

' PBPVarsSaved_H is part of DT_INTS_18XV INT_Flags located in the access bank 
PBPVarsSaved_H = 0
goto OverReEnterH

' PBP system registers
' --------------------
' PBP defines nine system registers R0-R8 + eight addtl bytes (RM, RR, RS, etc) 
' the size of R0-R3 depends on if PBP or PBPL is used (words vs longs)
' (see PBPPIC18.RAM/PBPPI18L.RAM for PBP PIC18 library RAM definitions)
' in addition, PBP will create temp variables T1-Tn when it evaluates a complex
' expression such as:
'     IF (b>=$32 AND b<=$47) THEN   ' T1-T2 used
' each term in the expression will allocate an additional T temp variable, and
' these will also vary in size depending upon PBP/PBPL usage
' this module allocates storage for T1-T7 and will issue a warning if more than
' that are detected as being used (they will NOT be saved)

' make PBPL '__LONG__' visible to asm
#if (__LONG__)  'PBPL
asm
  __LONG__ set 1
endasm
#else           'PBPW
asm
  __LONG__ set 0
endasm
#endif

' macro to copy a temp register based on PBPW/PBPL
asm
MOVE?TEMP?REG macro src, dest
  if (__LONG__ == 1)
    MOVE?NN src, dest   ; copy long-long
  else
    MOVE?WW src, dest   ; copy word-word
  endif
 endm
endasm

' Save locations for PBP system vars during High Priority Interrupts
#if (__LONG__)                      ' PBPL
HP_Vars  var  long [16]             ' group vars together (16*4=64 bytes)
    R0_SaveH      var HP_Vars[0]        ' system register R0, long
    R1_SaveH      var HP_Vars[1]        ' system register R1, long
    R2_SaveH      var HP_Vars[2]        ' system register R2, long
    R3_SaveH      var HP_Vars[3]        ' system register R3, long
    R4_R5_H       var HP_Vars[4]
      R4_SaveH      var R4_R5_H.word0   ' system register R4, word
      R5_SaveH      var R4_R5_H.word1   ' system register R5, word
    R6_R7_H       var HP_Vars[5]
      R6_SaveH      var R6_R7_H.word0   ' system register R6, word
      R7_SaveH      var R6_R7_H.word1   ' system register R7, word
    R8_H          var HP_Vars[6]
      R8_SaveH      var R8_H.word0      ' system register R8, word
    RM_RR_H       var HP_Vars[7]        ' RM and RR registers, byte
      RM1_SaveH     var RM_RR_H.byte0
      RM2_SaveH     var RM_RR_H.byte1
      RR1_SaveH     var RM_RR_H.byte2
      RR2_SaveH     var RM_RR_H.byte3
    RS_GOP_FLAGS_H var HP_Vars[8]       ' RS, GOP, and FLAGS registers, byte
      RS1_SaveH     var RS_GOP_FLAGS_H.byte0
      RS2_SaveH     var RS_GOP_FLAGS_H.byte1
      GOP_SaveH     var RS_GOP_FLAGS_H.byte2
      FLAGS_SaveH   var RS_GOP_FLAGS_H.byte3
    T1_SaveH      var HP_Vars[9]        ' PBP temp vars T1-T7, long (PBPL)
    T2_SaveH      var HP_Vars[10]
    T3_SaveH      var HP_Vars[11]
    T4_SaveH      var HP_Vars[12]
    T5_SaveH      var HP_Vars[13]
    T6_SaveH      var HP_Vars[14]
    T7_SaveH      var HP_Vars[15]
#else                               ' PBPW
HP_Vars  var  word [20]             ' group vars together (20*2=40 bytes)
    R0_SaveH      var HP_Vars[0]        ' system register R0, word
    R1_SaveH      var HP_Vars[1]        ' system register R1, word
    R2_SaveH      var HP_Vars[2]        ' system register R2, word
    R3_SaveH      var HP_Vars[3]        ' system register R3, word
    R4_SaveH      var HP_Vars[4]        ' system register R4, word
    R5_SaveH      var HP_Vars[5]        ' system register R5, word
    R6_SaveH      var HP_Vars[6]        ' system register R6, word
    R7_SaveH      var HP_Vars[7]        ' system register R7, word
    R8_SaveH      var HP_Vars[8]        ' system register R8, word
    RM_H          var HP_Vars[9]
      RM1_SaveH     var RM_H.byte0      ' Pin 1 Mask, byte
      RM2_SaveH     var RM_H.byte1      ' Pin 2 Mask, byte
    RR_H          var HP_Vars[10]
      RR1_SaveH     var RR_H.byte0      ' Pin 1 Register, byte
      RR2_SaveH     var RR_H.byte1      ' Pin 2 Register, byte
    RS_H            var HP_Vars[11]
      RS1_SaveH     var RS_H.byte0      ' Pin 1 Bank, byte
      RS2_SaveH     var RS_H.byte1      ' Pin 2 Bank, byte
    GOP_FLAGS_H   var HP_Vars[12]
      GOP_SaveH     var GOP_FLAGS_H.byte0   ' Gen Op Parameter GOP, byte
      FLAGS_SaveH   var GOP_FLAGS_H.byte1   ' Static flags FLAGS, byte
    T1_SaveH      var HP_Vars[13]       ' PBP temp vars T1-T7, word (PBPW)
    T2_SaveH      var HP_Vars[14]
    T3_SaveH      var HP_Vars[15]
    T4_SaveH      var HP_Vars[16]
    T5_SaveH      var HP_Vars[17]
    T6_SaveH      var HP_Vars[18]
    T7_SaveH      var HP_Vars[19]
#endif


SavePBP_H:               ' Save all PBP system vars High Priority
  if (PBPVarsSaved_H = 0) then
    R0_SaveH = R0
    R1_SaveH = R1
    R2_SaveH = R2
    R3_SaveH = R3
    R4_SaveH = R4
    R5_SaveH = R5
    R6_SaveH = R6
    R7_SaveH = R7
    R8_SaveH = R8
    GOP_SaveH = GOP
    Flags_SaveH = FLAGS
    RR1_SaveH = RR1
    RS1_SaveH = RS1
    RM1_SaveH = RM1
    RR2_SaveH = RR2
    RS2_SaveH = RS2
    RM2_SaveH = RM2
    ASM
      ifdef T1
        MOVE?TEMP?REG  T1, _T1_SaveH
      endif
      ifdef T2
        MOVE?TEMP?REG  T2, _T2_SaveH
      endif
      ifdef T3
        MOVE?TEMP?REG  T3, _T3_SaveH
      endif
      ifdef T4
        MOVE?TEMP?REG  T4, _T4_SaveH
      endif
      ifdef T5
        MOVE?TEMP?REG  T5, _T5_SaveH
      endif
      ifdef T6
        MOVE?TEMP?REG  T6, _T6_SaveH
      endif
      ifdef T7
        MOVE?TEMP?REG  T7, _T7_SaveH
      endif
      ifdef T8
        ifndef NO_T7_WARNING
          messg "PBP temp variables exceed T7 and will NOT be saved!!"
        endif
      endif
    ENDASM   
    PBPVarsSaved_H = 1
  endif
@ INT_RETURN

RestorePBP_H:
  if (PBPVarsSaved_H = 1) then
    R0 = R0_SaveH
    R1 = R1_SaveH
    R2 = R2_SaveH
    R3 = R3_SaveH
    R4 = R4_SaveH
    R5 = R5_SaveH
    R6 = R6_SaveH
    R7 = R7_SaveH
    R8 = R8_SaveH
    GOP = GOP_SaveH
    FLAGS = Flags_SaveH
    RR1 = RR1_SaveH
    RS1 = RS1_SaveH
    RM1 = RM1_SaveH
    RR2 = RR2_SaveH
    RS2 = RS2_SaveH
    RM2 = RM2_SaveH
    ASM
      ifdef T1
        MOVE?TEMP?REG  _T1_SaveH, T1
      endif
      ifdef T2
        MOVE?TEMP?REG  _T2_SaveH, T2
      endif
      ifdef T3
        MOVE?TEMP?REG  _T3_SaveH, T3
      endif
      ifdef T4
        MOVE?TEMP?REG  _T4_SaveH, T4
      endif
      ifdef T5
        MOVE?TEMP?REG  _T5_SaveH, T5
      endif
      ifdef T6
        MOVE?TEMP?REG  _T6_SaveH, T6
      endif
      ifdef T7
        MOVE?TEMP?REG  _T7_SaveH, T7
      endif
    ENDASM
    PBPVarsSaved_H = 0
  endif
@ INT_RETURN

OverReEnterH:
ENABLE DEBUG
