' PICBASIC PRO 2.50L test program to talk to MMC/SD cards with PIC18F4550
'  10/02/08

	Define	OSC	20	' 20 MHz oscillator

' Alias PIC pins and registers for SD/MMC card
SD_WE		Var	PORTA.4	' SD card write protect
SD_WE_TRIS	Var	TRISA.4	' SD card write protect direction
SDI		Var	PORTB.0	' SPI data in
SDI_TRIS	Var	TRISB.0	' SPI data in direction
SCL		Var	PORTB.1	' SPI clock
SCL_TRIS	Var	TRISB.1	' SPI clock direction
SD_CS		Var	PORTB.3	' SD card chip select
SD_CS_TRIS	Var	TRISB.3	' SD card chip select direction
SD_CD		Var	PORTB.4	' SD card detect
SD_CD_TRIS	Var	TRISB.4	' SD card detect direction
SDO		Var	PORTC.7	' SPI data out
SDO_TRIS	Var	TRISC.7	' SPI data out direction


' Include the SD/MMC subroutines
	Include "SDFS.BAS"
	SDC_UseHardSPI = TRUE	' Use hardware SSP port for SPI.

	ADCON1 = 15		' All I/O pins digital
	Pause 100

	' FSInit initializes the card and reads all the preliminary information from it
	Gosub FSInit
	Serout2 PORTC.6, 84, ["Init: ", Dec FAT_error, " ", Dec SDC_status, " ", Dec SDC_response, $d, $a]
	If (FAT_error != 0) Then Stop

	' Display card directory
	Gosub FINDfirst		' Find first file on card
	While (FAT_error = 0)
		Serout2 PORTC.6, 84, [Str FAT_FileName\11, $d, $a]
		Gosub FINDnext	' Find next file on card
	Wend

' This section defines a specific short (8.3) filename
'  Note that spaces are use in empty elements and must be upper case for Windows
	FAT_FileName[0] = "T"
	FAT_FileName[1] = "E"
	FAT_FileName[2] = "S"
	FAT_FileName[3] = "T"
	FAT_FileName[4] = "1"
	FAT_FileName[5] = " "
	FAT_FileName[6] = " "
	FAT_FileName[7] = " "
	FAT_FileName[8] = "T"
	FAT_FileName[9] = "X"
	FAT_FileName[10] = "T"

' Set file time to 8:30:10 and date to 1/1/2008
	FAT_seconds = 5
	FAT_minutes = 30
	FAT_hours = 8
	FAT_day = 1
	FAT_month = 1
	FAT_year = 28

' Open a file for write
	FAT_mode = "w"		' Write mode
	Gosub FSfopen		' Open file pointed to by Byte array FAT_FileName
	Serout2 PORTC.6, 84, ["Open for write: ", Dec FAT_error, $d, $a]
	If (FAT_error != 0) Then Stop

' Write to file
	FAT_src[0] = "A"
	FAT_src[1] = "B"
	FAT_src[2] = "C"
	FAT_count = 3
	Gosub FSfwrite
	Serout2 PORTC.6, 84, [ "Write ", Dec FAT_error, $d, $a]
	If (FAT_error != 0) Then Stop

' Close file
	Gosub FSfclose
	Serout2 PORTC.6, 84, [ "Close ", Dec FAT_error, $d, $a]
	If (FAT_error != 0) Then Stop

' Open a file for read
	FAT_mode = "r"		' Read mode
	Gosub FSfopen		' Open file pointed to by Byte array FAT_FileName
	Serout2 PORTC.6, 84, ["Open: ", Dec FAT_error, $d, $a]
	If (FAT_error != 0) Then Stop

' Read and display the whole file
	FAT_count = 1	' Read 1 byte to buffer at a time
	Gosub FSfread
	While (FAT_error = 0)
		Serout2 PORTC.6, 84, [FAT_dest[0]]
		FAT_count = 1	' Read 1 byte to buffer at a time
		Gosub FSfread
	Wend
	Serout2 PORTC.6, 84, [ "Read: ", Dec FAT_error, $d, $a]

' Delete a file
'	Gosub FSremove		' Delete file pointed to by Byte array FAT_FileName
'	Serout2 PORTC.6, 84, ["Remove: ", Dec FAT_error, $d, $a]
'	If (FAT_error != 0) Then Stop

' Rename a file
' FAT_FileName2 is new name
'	FAT_FileName2[0] = "T"
'	FAT_FileName2[1] = "E"
'	FAT_FileName2[2] = "S"
'	FAT_FileName2[3] = "T"
'	FAT_FileName2[4] = "2"
'	FAT_FileName2[5] = " "
'	FAT_FileName2[6] = " "
'	FAT_FileName2[7] = " "
'	FAT_FileName2[8] = "T"
'	FAT_FileName2[9] = "X"
'	FAT_FileName2[10] = "T"
'	Gosub FSrename		' Rename file pointed to by Byte array FAT_FileName
'	Serout2 PORTC.6, 84, ["Rename: ", Dec FAT_error, $d, $a]
'	If (FAT_error != 0) Then Stop

	End
