' hid_desc.bas
' USB descriptors for a HID device
' 9/16/08 microEngineering Labs, Inc.

'USBMEMORYADDRESS Con	$400	' USB RAM starts here (set in device header file)
USBMEMORYSIZE	Con	256	' USB RAM size in bytes
USBReservedMemory Var Byte[USBMEMORYSIZE] USBMEMORYADDRESS	' Reserve memory used by USB assembler code

	Goto	hid_desc_end	' Skip over all of the USB assembler code

	Asm

#define USB_EP0_BUFF_SIZE	8	; 8, 16, 32, or 64
#define USB_MAX_NUM_INT		1
#define USB_MAX_EP_NUMBER	1
#define NUM_CONFIGURATIONS	1
#define NUM_INTERFACES		1

#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_FULL_SPEED|USB_PING_PONG__NO_PING_PONG
;#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_LOW_SPEED|USB_PING_PONG__NO_PING_PONG

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

#define USB_POLLING

; HID
; Endpoints Allocation
#define	HID_INTF_ID		0x00
#define	HID_UEP			UEP1
#define	HID_BD_OUT		ep1Bo
#define	HID_INT_OUT_EP_SIZE	8
#define	HID_BD_IN		ep1Bi
#define	HID_INT_IN_EP_SIZE	8
#define	HID_NUM_OF_DSC		1
#define HID_EP			1


	include	"usb_hid.asm"	; Include rest of USB files, starting with HID class code

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	(EndDeviceDescriptor-DeviceDescriptor)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_DEVICE	; DEVICE descriptor type
	retlw	0x00		; bcdUSBUSB Revision 1.10 (low byte)
	retlw	0x02		; high byte
	retlw	0x00		; bDeviceClass
	retlw	0x00		; bDeviceSubClass
	retlw	0x00		; bDeviceProtocol
	retlw	USB_EP0_BUFF_SIZE	; bMaxPacketSize for EP0
	retlw	0xD8		; idVendor - 0x04D8 is Microchip Vendor ID (low byte)
	retlw	0x04		; (high byte)
	retlw	0x02		; idProduct (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; bcdDevice (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; iManufacturer
	retlw	0x02		; iProduct
	retlw	0x33		; iSerialNumber
	retlw	NUM_CONFIGURATIONS	; bNumConfigurations
EndDeviceDescriptor

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	upper Config1, 0

; Configuration Descriptor
Config1
	retlw	(Interface1-Config1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_CONFIGURATION	; CONFIGURATION descriptor type
Config1Len
	retlw	low ((EndConfig1-Config1)/2)	; Length of this configuration
	retlw	high ((EndConfig1-Config1)/2)
	retlw	0x01		; bNumInterfaces Number of interfaces
	retlw	0x01		; bConfigValue Configuration Value
	retlw	0x04		; iConfigString Index for this config = #01
	retlw	0xA0		; bmAttributes attributes - bus powered
	retlw	0x50		; Max power consumption (2X mA)
Interface1
	retlw	(HIDDescriptor1-Interface1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_INTERFACE	; INTERFACE descriptor type
	retlw	0x00		; number of interface, 0 based array
	retlw	0x00		; alternate setting
	retlw	0x01		; number of endpoints used in this interface
	retlw	0x03		; interface class - assigned by the USB
	retlw	0x01		; boot device
	retlw	0x01		; interface protocol - keyboard
	retlw	0x05		; Interface string index
HIDDescriptor1
	retlw	(Endpoint1-HIDDescriptor1)/2	; Size of this descriptor in bytes
    retlw	0x21		; descriptor type (HID)
	retlw	0x01		; HID class release number (1.00)
	retlw	0x01
	retlw	0x00		; Localized country code (none)
	retlw	0x01		; # of HID class descriptor to follow (1)
	retlw	0x22		; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1-ReportDescriptor1)/2)
	retlw	high ((EndReportDescriptor1-ReportDescriptor1)/2)
Endpoint1
	retlw	(EndConfig1-Endpoint1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_ENDPOINT	; ENDPOINT descriptor type
	retlw	0x81		; EP1, In
	retlw	0x03		; Interrupt
	retlw	0x08		; This should be the size of the endpoint buffer
	retlw	0x00
	retlw	0x0A		; polling interval (10ms)
EndConfig1

ReportDescriptor1
	retlw   0x05
	retlw   0x01    ; usage page (generic desktop)
	retlw   0x09
	retlw   0x06    ; usage (keyboard)
	retlw   0xA1
	retlw   0x01    ; collection (application)
	retlw   0x05
	retlw   0x07    ;   usage (Key codes)
	retlw   0x19
	retlw   0xE0    ;   usage minimum (224)
	retlw   0x29
	retlw   0xE7    ;   usage minimum (231)
	retlw   0x15
	retlw   0x00    ;     logical minimum (0)
	retlw   0x25
	retlw   0x01    ;     logical maximum (1)
	retlw   0x75
	retlw   0x01    ;     report size (1)
	retlw   0x95
	retlw   0x08    ;     report count (8)
	retlw   0x81
	retlw   0x02    ;     Input (data,variable,absolute)
	retlw   0x95
	retlw   0x01    ;     report count (1)
	retlw   0x75
	retlw   0x08    ;     report size (8)
	retlw   0x81
	retlw   0x01    ;     Input (constant)
	retlw   0x95
	retlw   0x05    ;     report count (5)
	retlw   0x75
	retlw   0x01    ;     report size (1)
	retlw   0x05
	retlw   0x08    ;     usage page (page# for leds)
	retlw   0x19
	retlw   0x01    ;     Usage minimum (1)
	retlw   0x29
	retlw   0x05    ;     Usage maximum (5)
	retlw   0x91
	retlw   0x02    ;     output (data,variable,absolute)
	retlw   0x95
	retlw   0x01    ;     report count (1)
	retlw   0x75
	retlw   0x03    ;     report size (3)
	retlw   0x91
	retlw   0x01    ;     output (constant)
	retlw   0x95
	retlw   0x06    ;     report count (6)
	retlw   0x75
	retlw   0x08    ;     report size (8)
	retlw   0x15
	retlw   0x00    ;     logical minimum (0)
	retlw   0x25
	retlw   0x65    ;     logical maximum (101)
	retlw   0x05
	retlw   0x07    ;     usage page (keycodes)
	retlw   0x19
	retlw   0x00    ;     usage minimum (0)
	retlw   0x29
	retlw   0x65    ;     usage maximum (101)
	retlw   0x81
	retlw   0x00    ;     input (data, array)	
	retlw   0xC0    ;   end collection
EndReportDescriptor1

; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	upper String0, 0
	db	low String1, high String1
	db	upper String1, 0
	db	low String2, high String2
	db	upper String2, 0

; Language code string descriptor
String0
	retlw   (String1-String0)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   0x09		; Language ID as defined by MS - 0x0409 (low byte)
	retlw   0x04		; (high byte)

; Manufacturer string descriptor
String1
	retlw   (String2-String1)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   'M'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'r'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'h'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'p'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'T'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'h'
	retlw   0x00
	retlw   'n'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'l'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'g'
	retlw   0x00
	retlw   'y'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'n'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   '.'
	retlw   0x00

; Product string descriptor
String2
	retlw   (EndStringDescriptors-String2)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   'M'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'u'
	retlw   0x00
	retlw   's'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'n'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'a'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'C'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'r'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'l'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'D'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   'm'
	retlw   0x00
	retlw   'o'
	retlw   0x00
EndStringDescriptors



	Endasm

hid_desc_end			' End of skipped over USB assembler code
