
; PICBASIC PRO(TM) Compiler 3.0.8.4, (c) 1998, 2013 microEngineering Labs, Inc. All Rights Reserved. 
MPASMX_USED			EQU	1

#define	PBP_PATH	C:\PBP3\




        NOLIST
    ifdef PM_USED
        LIST
        "Error: PM does not support this device.  Use MPASM."
        NOLIST
    else
        LIST
        LIST p = 18F87J50, r = dec, w = -311, w = -230, f = inhx32
        INCLUDE "P18F87J50.INC"	; MPASM  Header
        NOLIST
    endif
        LIST
BLOCK_SIZE	EQU	64

ANCON0_ALT	EQU	ANCON0 + 8000h
ANCON1_ALT	EQU	ANCON1 + 8000h
CVRCON_ALT	EQU	CVRCON + 8000h
MEMCON_ALT	EQU	MEMCON + 8000h
ODCON1_ALT	EQU	ODCON1 + 8000h
ODCON2_ALT	EQU	ODCON2 + 8000h
ODCON3_ALT	EQU	ODCON3 + 8000h
PADCFG1_ALT	EQU	PADCFG1 + 8000h


PBP_HARDWAREDEF  macro
  endm


    CONFIG PLLDIV = 2       ;for 8 mhz chip
    CONFIG XINST = OFF
    CONFIG STVREN = ON    ;stack overflow reset
    CONFIG WDTEN = OFF
    CONFIG CP0 = OFF
    CONFIG IESO = OFF
    CONFIG FCMEN = OFF
    CONFIG CCP2MX = DEFAULT
    CONFIG WDTPS = 32768
    CONFIG CPUDIV = OSC1  ;DIVIDE BY 1 MODE
    CONFIG FOSC = HSPLL
    CONFIG MSSPMSK = MSK5
	


; Define statements.
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00015	    Define OSC 48
#define		OSC		 48

RAM_START       		EQU	00000h
RAM_END         		EQU	00F3Fh
RAM_BANKS       		EQU	00010h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANK8_START     		EQU	00800h
BANK8_END       		EQU	008FFh
BANK9_START     		EQU	00900h
BANK9_END       		EQU	009FFh
BANK10_START    		EQU	00A00h
BANK10_END      		EQU	00AFFh
BANK11_START    		EQU	00B00h
BANK11_END      		EQU	00BFFh
BANK12_START    		EQU	00C00h
BANK12_END      		EQU	00CFFh
BANK13_START    		EQU	00D00h
BANK13_END      		EQU	00DFFh
BANK14_START    		EQU	00E00h
BANK14_END      		EQU	00EFFh
BANK15_START    		EQU	00F00h
BANK15_END      		EQU	00F3Fh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

; C:\PBP3\PBPPI18L.RAM     	00028	A00000	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP3\PBPPI18L.RAM     	00027	A00001	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 001h
; C:\PBP3\PBPPI18L.RAM     	00016	A00002	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 002h
; C:\PBP3\PBPPI18L.RAM     	00017	A00004	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 004h
; C:\PBP3\PBPPI18L.RAM     	00018	A00006	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 006h
; C:\PBP3\PBPPI18L.RAM     	00019	A00008	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 008h
; C:\PBP3\PBPPI18L.RAM     	00020	A0000A	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 00Ah
; C:\PBP3\PBPPI18L.RAM     	00023	A0000C	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 00Ch
; C:\PBP3\PBPPI18L.RAM     	00026	A0000D	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 00Dh
; C:\PBP3\PBPPI18L.RAM     	00021	A0000E	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 00Eh
; C:\PBP3\PBPPI18L.RAM     	00024	A0000F	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 00Fh
; C:\PBP3\PBPPI18L.RAM     	00022	A00010	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 010h
; C:\PBP3\PBPPI18L.RAM     	00025	A00011	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 011h
; C:\PBP3\PBPPI18L.RAM     	00012	A00012	R0      VAR     LONG BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 012h
; C:\PBP3\PBPPI18L.RAM     	00013	A00016	R1      VAR     LONG BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 016h
; C:\PBP3\PBPPI18L.RAM     	00014	A0001A	R2      VAR     LONG BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 01Ah
; C:\PBP3\PBPPI18L.RAM     	00015	A0001E	R3      VAR     LONG BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 01Eh
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00001	A00022	    #config
T1              		EQU	RAM_START + 022h
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00028	A00026	    DelayCnt var byte
_DelayCnt        		EQU	RAM_START + 026h
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00029	A00027	    DelayVal var byte
_DelayVal        		EQU	RAM_START + 027h
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00027	A00028	    i var	Byte
_i               		EQU	RAM_START + 028h
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00023	A00029	    USBBufferCount Var Byte
_USBBufferCount  		EQU	RAM_START + 029h
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00024	A0002A	    USBBufferIn var byte[8]
_USBBufferIn     		EQU	RAM_START + 02Ah
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00025	A00032	    USBBufferOut Var Byte[8] 
_USBBufferOut    		EQU	RAM_START + 032h
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\HID_DESC.BAS	00007	A00400	USBReservedMemory Var Byte[USBMEMORYSIZE] USBMEMORYADDRESS	' Reserve memory used by USB assembler code
_USBReservedMemory		EQU	RAM_START + 000000400h
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00355	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00358	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
#define _OSCTUNE??6      	 OSCTUNE, 006h
#define _PORTB??7        	 PORTB, 007h
#define _PORTB??6        	 PORTB, 006h
#define _PORTB??5        	 PORTB, 005h
#define _PORTB??4        	 PORTB, 004h
#define _PORTB??3        	 PORTB, 003h
#define _PORTB??2        	 PORTB, 002h
#define _PORTB??1        	 PORTB, 001h
#define _PORTB??0        	 PORTB, 000h

; Constants.
_USBMEMORYADDRESS		EQU	00400h
_USBMEMORYSIZE   		EQU	00100h
_Key_a           		EQU	00004h
_Key_b           		EQU	00005h
_Key_c           		EQU	00006h
_Key_d           		EQU	00007h
_Key_e           		EQU	00008h
_Key_f           		EQU	00009h
_Key_g           		EQU	0000Ah
_Key_h           		EQU	0000Bh
_Key_i           		EQU	0000Ch
_Key_j           		EQU	0000Dh
_Key_k           		EQU	0000Eh
_Key_l           		EQU	0000Fh
_Key_m           		EQU	00010h
_Key_n           		EQU	00011h
_Key_o           		EQU	00012h
_Key_p           		EQU	00013h
_Key_q           		EQU	00014h
_Key_r           		EQU	00015h
_Key_s           		EQU	00016h
_Key_t           		EQU	00017h
_Key_u           		EQU	00018h
_Key_v           		EQU	00019h
_Key_w           		EQU	0001Ah
_Key_x           		EQU	0001Bh
_Key_y           		EQU	0001Ch
_Key_z           		EQU	0001Dh
_Key_1           		EQU	0001Eh
_Key_2           		EQU	0001Fh
_Key_3           		EQU	00020h
_Key_4           		EQU	00021h
_Key_5           		EQU	00022h
_Key_6           		EQU	00023h
_Key_7           		EQU	00024h
_Key_8           		EQU	00025h
_Key_9           		EQU	00026h
_Key_0           		EQU	00027h
_Key_ENTER       		EQU	00028h
_Key_ESC         		EQU	00029h
_Key_BACKSPC     		EQU	0002Ah
_Key_TAB         		EQU	0002Bh
_Key_SPACE       		EQU	0002Ch
_Key_Min         		EQU	0002Dh
_Key_CAPSLOCK    		EQU	00039h
_Key_F1          		EQU	0003Ah
_Key_F2          		EQU	0003Bh
_Key_F3          		EQU	0003Ch
_Key_F4          		EQU	0003Dh
_Key_F5          		EQU	0003Eh
_Key_F6          		EQU	0003Fh
_Key_F7          		EQU	00040h
_Key_F8          		EQU	00041h
_Key_F9          		EQU	00042h
_Key_F10         		EQU	00043h
_Key_F11         		EQU	00044h
_Key_F12         		EQU	00045h
_Key_PRTSCR      		EQU	00046h
_Key_SCRLOCK     		EQU	00047h
_Key_PAUSE       		EQU	00048h
_Key_INSERT      		EQU	00049h
_Key_HOME        		EQU	0004Ah
_Key_PGUP        		EQU	0004Bh
_Key_DEL         		EQU	0004Ch
_Key_END         		EQU	0004Dh
_Key_PGDN        		EQU	0004Eh
_Key_RIGHT       		EQU	0004Fh
_Key_LEFT        		EQU	00050h
_Key_DOWN        		EQU	00051h
_Key_UP          		EQU	00052h
_Key_NUMLOCK     		EQU	00053h
_Key_ENTERN      		EQU	00058h
_Key_1n          		EQU	00059h
_Key_2n          		EQU	0005Ah
_Key_3n          		EQU	0005Bh
_Key_4n          		EQU	0005Ch
_Key_5n          		EQU	0005Dh
_Key_6n          		EQU	0005Eh
_Key_7n          		EQU	0005Fh
_Key_8n          		EQU	00060h
_Key_9n          		EQU	00061h
_Key_0n          		EQU	00062h
_Key_MENU        		EQU	00065h
_LCTRL           		EQU	00001h
_LSHIFT          		EQU	00002h
_LALT            		EQU	00004h
_LWIN            		EQU	00008h
_RCTRL           		EQU	00010h
_RSHIFT          		EQU	00020h
_RALT            		EQU	00040h
_RWIN            		EQU	00080h
_USBBufferSizeTX 		EQU	00008h
_USBBufferSizeRX 		EQU	00008h

; EEPROM data.


	INCLUDE	"MYKEYBOARD.MAC"
	INCLUDE	"C:\PBP3\PBPPI18L.LIB"


; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00036	#HEADER
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00069	#CONFIG
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00329	BANKA   $0000, $005F
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00330	BANK0   $0060, $00FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00331	BANK1   $0100, $01FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00332	BANK2   $0200, $02FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00333	BANK3   $0300, $03FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00334	BANK4   $0400, $04FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00335	BANK5   $0500, $05FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00336	BANK6   $0600, $06FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00337	BANK7   $0700, $07FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00338	BANK8   $0800, $08FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00339	BANK9   $0900, $09FF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00340	BANK10  $0A00, $0AFF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00341	BANK11  $0B00, $0BFF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00342	BANK12  $0C00, $0CFF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00343	BANK13  $0D00, $0DFF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00344	BANK14  $0E00, $0EFF
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00345	BANK15  $0F00, $0F3F
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00346	
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00348	    #MSG "LONG Variables enabled (PBPL used)"
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00349	    LIBRARY  "PBPPI18L"

; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00350	    INCLUDE "PBPPI18L.RAM"
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00353	    INCLUDE "PBPPIC18.RAM"
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00354	#ENDIF

; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00357	@_PORTH	EQU     PORTC

	ASM?
_PORTH	EQU     PORTC

	ENDASM?


; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00360	@_TRISH	EQU	TRISC

	ASM?
_TRISH	EQU	TRISC

	ENDASM?

; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00361	USBMEMORYADDRESS Con	$400	' USB RAM starts here
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00362	#DEFINE ADSHR       ; Flag this device as having alternate SFR memory
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00363	#MSG "SFRs REFOCON, ODCON1, ODCON2, ODCON3, PADCFG1, MEMCON, ANCON1,"
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00364	#MSG "ANCON0, and CVRCON should be accessed in alternate memory space"
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00365	#MSG "with names REFOCON_ALT, ODCON1_ALT, ODCON2_ALT, ODCON3_ALT,"
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00366	#MSG "PADCFG1_ALT, MEMCON_ALT, ANCON1_ALT, ANCON0_ALT, and CVRCON_ALT."
; C:\PBP3\DEVICES\PIC18F87J50.PBPINC	00370	#HEADER
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00001	    #config
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00015	    Define OSC 48

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00016		OSCTUNE.6 = 1		' Enable PLL for 18F87J50 family
	MOVE?CT	001h, _OSCTUNE??6

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00017		PAUSE 500
	PAUSE?C	001F4h

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00018		Include	"hid_desc.bas"	' Include the HID descriptors
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\HID_DESC.BAS	00006	USBMEMORYSIZE	Con	256	' USB RAM size in bytes

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\HID_DESC.BAS	00009		Goto	hid_desc_end	' Skip over all of the USB assembler code
	GOTO?L	_hid_desc_end

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\HID_DESC.BAS	00011		Asm

	ASM?


#define USB_EP0_BUFF_SIZE	8	; 8, 16, 32, or 64
#define USB_MAX_NUM_INT		1
#define USB_MAX_EP_NUMBER	1
#define NUM_CONFIGURATIONS	1
#define NUM_INTERFACES		1

#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_FULL_SPEED|USB_PING_PONG__NO_PING_PONG
;#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_LOW_SPEED|USB_PING_PONG__NO_PING_PONG

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

#define USB_POLLING

; HID
; Endpoints Allocation
#define	HID_INTF_ID		0x00
#define	HID_UEP			UEP1
#define	HID_BD_OUT		ep1Bo
#define	HID_INT_OUT_EP_SIZE	8
#define	HID_BD_IN		ep1Bi
#define	HID_INT_IN_EP_SIZE	8
#define	HID_NUM_OF_DSC		1
#define HID_EP			1


	include	"usb_hid.asm"	; Include rest of USB files, starting with HID class code

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	(EndDeviceDescriptor-DeviceDescriptor)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_DEVICE	; DEVICE descriptor type
	retlw	0x00		; bcdUSBUSB Revision 1.10 (low byte)
	retlw	0x02		; high byte
	retlw	0x00		; bDeviceClass
	retlw	0x00		; bDeviceSubClass
	retlw	0x00		; bDeviceProtocol
	retlw	USB_EP0_BUFF_SIZE	; bMaxPacketSize for EP0
	retlw	0xD8		; idVendor - 0x04D8 is Microchip Vendor ID (low byte)
	retlw	0x04		; (high byte)
	retlw	0x02		; idProduct (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; bcdDevice (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; iManufacturer
	retlw	0x02		; iProduct
	retlw	0x33		; iSerialNumber
	retlw	NUM_CONFIGURATIONS	; bNumConfigurations
EndDeviceDescriptor

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	upper Config1, 0

; Configuration Descriptor
Config1
	retlw	(Interface1-Config1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_CONFIGURATION	; CONFIGURATION descriptor type
Config1Len
	retlw	low ((EndConfig1-Config1)/2)	; Length of this configuration
	retlw	high ((EndConfig1-Config1)/2)
	retlw	0x01		; bNumInterfaces Number of interfaces
	retlw	0x01		; bConfigValue Configuration Value
	retlw	0x04		; iConfigString Index for this config = #01
	retlw	0xA0		; bmAttributes attributes - bus powered
	retlw	0x50		; Max power consumption (2X mA)
Interface1
	retlw	(HIDDescriptor1-Interface1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_INTERFACE	; INTERFACE descriptor type
	retlw	0x00		; number of interface, 0 based array
	retlw	0x00		; alternate setting
	retlw	0x01		; number of endpoints used in this interface
	retlw	0x03		; interface class - assigned by the USB
	retlw	0x01		; boot device
	retlw	0x01		; interface protocol - keyboard
	retlw	0x05		; Interface string index
HIDDescriptor1
	retlw	(Endpoint1-HIDDescriptor1)/2	; Size of this descriptor in bytes
    retlw	0x21		; descriptor type (HID)
	retlw	0x01		; HID class release number (1.00)
	retlw	0x01
	retlw	0x00		; Localized country code (none)
	retlw	0x01		; # of HID class descriptor to follow (1)
	retlw	0x22		; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1-ReportDescriptor1)/2)
	retlw	high ((EndReportDescriptor1-ReportDescriptor1)/2)
Endpoint1
	retlw	(EndConfig1-Endpoint1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_ENDPOINT	; ENDPOINT descriptor type
	retlw	0x81		; EP1, In
	retlw	0x03		; Interrupt
	retlw	0x08		; This should be the size of the endpoint buffer
	retlw	0x00
	retlw	0x0A		; polling interval (10ms)
EndConfig1

ReportDescriptor1
	retlw   0x05
	retlw   0x01    ; usage page (generic desktop)
	retlw   0x09
	retlw   0x06    ; usage (keyboard)
	retlw   0xA1
	retlw   0x01    ; collection (application)
	retlw   0x05
	retlw   0x07    ;   usage (Key codes)
	retlw   0x19
	retlw   0xE0    ;   usage minimum (224)
	retlw   0x29
	retlw   0xE7    ;   usage minimum (231)
	retlw   0x15
	retlw   0x00    ;     logical minimum (0)
	retlw   0x25
	retlw   0x01    ;     logical maximum (1)
	retlw   0x75
	retlw   0x01    ;     report size (1)
	retlw   0x95
	retlw   0x08    ;     report count (8)
	retlw   0x81
	retlw   0x02    ;     Input (data,variable,absolute)
	retlw   0x95
	retlw   0x01    ;     report count (1)
	retlw   0x75
	retlw   0x08    ;     report size (8)
	retlw   0x81
	retlw   0x01    ;     Input (constant)
	retlw   0x95
	retlw   0x05    ;     report count (5)
	retlw   0x75
	retlw   0x01    ;     report size (1)
	retlw   0x05
	retlw   0x08    ;     usage page (page# for leds)
	retlw   0x19
	retlw   0x01    ;     Usage minimum (1)
	retlw   0x29
	retlw   0x05    ;     Usage maximum (5)
	retlw   0x91
	retlw   0x02    ;     output (data,variable,absolute)
	retlw   0x95
	retlw   0x01    ;     report count (1)
	retlw   0x75
	retlw   0x03    ;     report size (3)
	retlw   0x91
	retlw   0x01    ;     output (constant)
	retlw   0x95
	retlw   0x06    ;     report count (6)
	retlw   0x75
	retlw   0x08    ;     report size (8)
	retlw   0x15
	retlw   0x00    ;     logical minimum (0)
	retlw   0x25
	retlw   0x65    ;     logical maximum (101)
	retlw   0x05
	retlw   0x07    ;     usage page (keycodes)
	retlw   0x19
	retlw   0x00    ;     usage minimum (0)
	retlw   0x29
	retlw   0x65    ;     usage maximum (101)
	retlw   0x81
	retlw   0x00    ;     input (data, array)	
	retlw   0xC0    ;   end collection
EndReportDescriptor1

; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	upper String0, 0
	db	low String1, high String1
	db	upper String1, 0
	db	low String2, high String2
	db	upper String2, 0

; Language code string descriptor
String0
	retlw   (String1-String0)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   0x09		; Language ID as defined by MS - 0x0409 (low byte)
	retlw   0x04		; (high byte)

; Manufacturer string descriptor
String1
	retlw   (String2-String1)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   'M'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'r'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'h'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'p'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'T'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'h'
	retlw   0x00
	retlw   'n'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'l'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'g'
	retlw   0x00
	retlw   'y'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'n'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   '.'
	retlw   0x00

; Product string descriptor
String2
	retlw   (EndStringDescriptors-String2)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   'M'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'u'
	retlw   0x00
	retlw   's'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'n'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'a'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'C'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'r'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'l'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'D'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   'm'
	retlw   0x00
	retlw   'o'
	retlw   0x00
EndStringDescriptors



	

	ENDASM?


; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\HID_DESC.BAS	00317	hid_desc_end			' End of skipped over USB assembler code

	LABEL?L	_hid_desc_end	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00019	    Include "Keys.pbp"
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00011	Key_a    con    $4
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00012	Key_b    con    $5
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00013	Key_c    con    $6
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00014	Key_d    con    $7
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00015	Key_e    con    $8
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00016	Key_f    con    $9
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00017	Key_g    con    $0A
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00018	Key_h    con    $0B
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00019	Key_i    con    $0C
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00020	Key_j    con    $0D
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00021	Key_k    con    $0E
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00022	Key_l    con    $0F
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00023	Key_m    con    $10
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00024	Key_n    con    $11
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00025	Key_o    con    $12
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00026	Key_p    con    $13
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00027	Key_q    con    $14
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00028	Key_r    con    $15
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00029	Key_s    con    $16
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00030	Key_t    con    $17
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00031	Key_u    con    $18
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00032	Key_v    con    $19
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00033	Key_w    con    $1A
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00034	Key_x    con    $1B
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00035	Key_y    con    $1C
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00036	Key_z    con    $1D
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00037	Key_1    con    $1E
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00038	Key_2    con    $1F
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00039	Key_3    con    $20
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00040	Key_4    con    $21
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00041	Key_5    con    $22
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00042	Key_6    con    $23
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00043	Key_7    con    $24
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00044	Key_8    con    $25
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00045	Key_9    con    $26
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00046	Key_0    con    $27
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00047	Key_ENTER con   $28
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00048	Key_ESC  con    $29
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00049	Key_BACKSPC con $2A
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00050	Key_TAB  con    $2B
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00051	Key_SPACE con   $2C
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00052	Key_Min  con    $2D
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00064	Key_CAPSLOCK con $39
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00065	Key_F1   con    $3A
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00066	Key_F2   con    $3B
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00067	Key_F3   con    $3C
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00068	Key_F4   con    $3D
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00069	Key_F5   con    $3E
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00070	Key_F6   con    $3F
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00071	Key_F7   con    $40
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00072	Key_F8   con    $41
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00073	Key_F9   con    $42
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00074	Key_F10  con    $43
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00075	Key_F11  con    $44
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00076	Key_F12  con    $45
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00077	Key_PRTSCR con  $46
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00078	Key_SCRLOCK con $47
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00079	Key_PAUSE con   $48
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00080	Key_INSERT con  $49
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00081	Key_HOME con    $4A
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00082	Key_PGUP con    $4B
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00083	Key_DEL  con    $4C
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00084	Key_END  con    $4D
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00085	Key_PGDN con    $4E
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00086	Key_RIGHT con   $4F
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00087	Key_LEFT con    $50
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00088	Key_DOWN con    $51
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00089	Key_UP   con    $52
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00090	Key_NUMLOCK con $53
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00095	Key_ENTERN con  $58
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00096	Key_1n   con    $59
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00097	Key_2n   con    $5A
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00098	Key_3n   con    $5B
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00099	Key_4n   con    $5C
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00100	Key_5n   con    $5D
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00101	Key_6n   con    $5E
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00102	Key_7n   con    $5F
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00103	Key_8n   con    $60
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00104	Key_9n   con    $61
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00105	Key_0n   con    $62
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00108	Key_MENU con    $65
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00111	LCTRL    CON $01
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00112	LSHIFT   CON $02
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00113	LALT     CON $04
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00114	LWIN     CON $08
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00115	RCTRL    CON $10
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00116	RSHIFT   CON $20
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00117	RALT     con $40'(RALT LCTRL)
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\KEYS.PBP	00118	RWIN     CON $80
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00021	    USBBufferSizeTX con 8                                                                                    
; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00022	    USBBufferSizeRX con 8

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00030	    clear
	CLEAR?	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00031	    trisb=255                                                                                
	MOVE?CB	0FFh, TRISB

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00032	    usbinit              ; Init USB Hardware
	USBINIT?	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00033	    USBService   
	USBSERVICE?	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00034	    call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00035	Main:  

	LABEL?L	_Main	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00036	    DelayVal=100                                                           
	MOVE?CB	064h, _DelayVal

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00037	    call DelaymS
	CALL?L	_DelaymS

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00038	    if PORTB<255 THEN
	CMPGE?BCL	PORTB, 0FFh, L00009

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00039	        if PORTB.7=0 THEN 
	CMPNE?TCL	_PORTB??7, 000h, L00011

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00040	            For i = 0 To 20	
	MOVE?CB	000h, _i
	LABEL?L	L00013	
	CMPGT?BCL	_i, 014h, L00014

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00041	                lookup i,[KEY_R, KEY_O, KEY_U, KEY_T, KEY_E, KEY_ENTER, 0], USBBufferOut[2]
	LOOKUP?BCLB	_i, 007h, L00001, _USBBufferOut + 00002h
	LURET?C	015h
	LURET?C	012h
	LURET?C	018h
	LURET?C	017h
	LURET?C	008h
	LURET?C	028h
	LURET?C	000h

	LABEL?L	L00001	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00042	                call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00043	                IF USBBufferOut[2]=0 THEN EXIT
	CMPNE?BCL	_USBBufferOut + 00002h, 000h, L00015
	EXIT?L	L00014
	LABEL?L	L00015	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00044	            Next i 
	NEXT?BCL	_i, 001h, L00013
	LABEL?L	L00014	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00045	        elseif PORTB.6=0 THEN        
	GOTO?L	L00012
	LABEL?L	L00011	
	CMPNE?TCL	_PORTB??6, 000h, L00017

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00046	            For i = 0 To 20	
	MOVE?CB	000h, _i
	LABEL?L	L00019	
	CMPGT?BCL	_i, 014h, L00020

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00047	                lookup i,[KEY_R, KEY_I, KEY_P, KEY_U, KEY_P, KEY_ENTER, 0], USBBufferOut[2]
	LOOKUP?BCLB	_i, 007h, L00002, _USBBufferOut + 00002h
	LURET?C	015h
	LURET?C	00Ch
	LURET?C	013h
	LURET?C	018h
	LURET?C	013h
	LURET?C	028h
	LURET?C	000h

	LABEL?L	L00002	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00048	                call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00049	                IF USBBufferOut[2]=0 THEN EXIT
	CMPNE?BCL	_USBBufferOut + 00002h, 000h, L00021
	EXIT?L	L00020
	LABEL?L	L00021	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00050	            Next i 
	NEXT?BCL	_i, 001h, L00019
	LABEL?L	L00020	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00051	        elseif PORTB.5=0 THEN        
	GOTO?L	L00012
	LABEL?L	L00017	
	CMPNE?TCL	_PORTB??5, 000h, L00023

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00052	            For i = 0 To 20	
	MOVE?CB	000h, _i
	LABEL?L	L00025	
	CMPGT?BCL	_i, 014h, L00026

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00053	                lookup i,[KEY_S, KEY_E, KEY_T, KEY_SPACE, KEY_W, KEY_I, KEY_R, KEY_E, Key_Min, KEY_B, KEY_E, KEY_N, KEY_D, KEY_SPACE, KEY_2, KEY_ENTER, 0], USBBufferOut[2]
	LOOKUP?BCLB	_i, 011h, L00003, _USBBufferOut + 00002h
	LURET?C	016h
	LURET?C	008h
	LURET?C	017h
	LURET?C	02Ch
	LURET?C	01Ah
	LURET?C	00Ch
	LURET?C	015h
	LURET?C	008h
	LURET?C	02Dh
	LURET?C	005h
	LURET?C	008h
	LURET?C	011h
	LURET?C	007h
	LURET?C	02Ch
	LURET?C	01Fh
	LURET?C	028h
	LURET?C	000h

	LABEL?L	L00003	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00054	                if i=8 then USBBufferOut[0]=LSHIFT
	CMPNE?BCL	_i, 008h, L00027
	MOVE?CB	_LSHIFT, _USBBufferOut
	LABEL?L	L00027	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00055	                call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00056	                IF USBBufferOut[2]=0 THEN EXIT
	CMPNE?BCL	_USBBufferOut + 00002h, 000h, L00029
	EXIT?L	L00026
	LABEL?L	L00029	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00057	            Next i 
	NEXT?BCL	_i, 001h, L00025
	LABEL?L	L00026	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00058	        elseif PORTB.4=0 THEN        
	GOTO?L	L00012
	LABEL?L	L00023	
	CMPNE?TCL	_PORTB??4, 000h, L00031

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00059	            For i = 0 To 20	
	MOVE?CB	000h, _i
	LABEL?L	L00033	
	CMPGT?BCL	_i, 014h, L00034

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00060	                lookup i,[KEY_M, KEY_O, KEY_V, KEY_E, KEY_ENTER, 0], USBBufferOut[2]
	LOOKUP?BCLB	_i, 006h, L00004, _USBBufferOut + 00002h
	LURET?C	010h
	LURET?C	012h
	LURET?C	019h
	LURET?C	008h
	LURET?C	028h
	LURET?C	000h

	LABEL?L	L00004	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00061	                call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00062	                IF USBBufferOut[2]=0 THEN EXIT
	CMPNE?BCL	_USBBufferOut + 00002h, 000h, L00035
	EXIT?L	L00034
	LABEL?L	L00035	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00063	            Next i 
	NEXT?BCL	_i, 001h, L00033
	LABEL?L	L00034	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00064	        elseif PORTB.3=0 THEN        
	GOTO?L	L00012
	LABEL?L	L00031	
	CMPNE?TCL	_PORTB??3, 000h, L00037

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00065	            For i = 0 To 20	
	MOVE?CB	000h, _i
	LABEL?L	L00039	
	CMPGT?BCL	_i, 014h, L00040

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00066	                lookup i,[KEY_C, KEY_O, KEY_P, KEY_Y, KEY_ENTER, 0], USBBufferOut[2]
	LOOKUP?BCLB	_i, 006h, L00005, _USBBufferOut + 00002h
	LURET?C	006h
	LURET?C	012h
	LURET?C	013h
	LURET?C	01Ch
	LURET?C	028h
	LURET?C	000h

	LABEL?L	L00005	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00067	                call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00068	                IF USBBufferOut[2]=0 THEN EXIT
	CMPNE?BCL	_USBBufferOut + 00002h, 000h, L00041
	EXIT?L	L00040
	LABEL?L	L00041	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00069	            Next i 
	NEXT?BCL	_i, 001h, L00039
	LABEL?L	L00040	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00070	        elseif PORTB.2=0 THEN        
	GOTO?L	L00012
	LABEL?L	L00037	
	CMPNE?TCL	_PORTB??2, 000h, L00043

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00071	            For i = 0 To 20	
	MOVE?CB	000h, _i
	LABEL?L	L00045	
	CMPGT?BCL	_i, 014h, L00046

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00072	                lookup i,[KEY_D, KEY_E, KEY_L, KEY_E, KEY_T, KEY_E, KEY_ENTER, 0], USBBufferOut[2]
	LOOKUP?BCLB	_i, 008h, L00006, _USBBufferOut + 00002h
	LURET?C	007h
	LURET?C	008h
	LURET?C	00Fh
	LURET?C	008h
	LURET?C	017h
	LURET?C	008h
	LURET?C	028h
	LURET?C	000h

	LABEL?L	L00006	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00073	                call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00074	                IF USBBufferOut[2]=0 THEN EXIT
	CMPNE?BCL	_USBBufferOut + 00002h, 000h, L00047
	EXIT?L	L00046
	LABEL?L	L00047	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00075	            Next i 
	NEXT?BCL	_i, 001h, L00045
	LABEL?L	L00046	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00076	        elseif PORTB.1=0 THEN        
	GOTO?L	L00012
	LABEL?L	L00043	
	CMPNE?TCL	_PORTB??1, 000h, L00049

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00077	            For i = 0 To 20	
	MOVE?CB	000h, _i
	LABEL?L	L00051	
	CMPGT?BCL	_i, 014h, L00052

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00078	                lookup i,[KEY_N, KEY_A, KEY_M, KEY_E, KEY_ENTER, 0], USBBufferOut[2]
	LOOKUP?BCLB	_i, 006h, L00007, _USBBufferOut + 00002h
	LURET?C	011h
	LURET?C	004h
	LURET?C	010h
	LURET?C	008h
	LURET?C	028h
	LURET?C	000h

	LABEL?L	L00007	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00079	                call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00080	                IF USBBufferOut[2]=0 THEN EXIT
	CMPNE?BCL	_USBBufferOut + 00002h, 000h, L00053
	EXIT?L	L00052
	LABEL?L	L00053	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00081	            Next i 
	NEXT?BCL	_i, 001h, L00051
	LABEL?L	L00052	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00082	        elseif PORTB.0=0 THEN        
	GOTO?L	L00012
	LABEL?L	L00049	
	CMPNE?TCL	_PORTB??0, 000h, L00055

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00083	            For i = 0 To 20	
	MOVE?CB	000h, _i
	LABEL?L	L00057	
	CMPGT?BCL	_i, 014h, L00058

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00084	                lookup i,[KEY_V, KEY_A, KEY_L, KEY_U, KEY_E, KEY_ENTER, 0], USBBufferOut[2]
	LOOKUP?BCLB	_i, 007h, L00008, _USBBufferOut + 00002h
	LURET?C	019h
	LURET?C	004h
	LURET?C	00Fh
	LURET?C	018h
	LURET?C	008h
	LURET?C	028h
	LURET?C	000h

	LABEL?L	L00008	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00085	                call DoUsbOut
	CALL?L	_DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00086	                IF USBBufferOut[2]=0 THEN EXIT
	CMPNE?BCL	_USBBufferOut + 00002h, 000h, L00059
	EXIT?L	L00058
	LABEL?L	L00059	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00087	            Next i                                           
	NEXT?BCL	_i, 001h, L00057
	LABEL?L	L00058	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00088	        endif
	LABEL?L	L00012	
	LABEL?L	L00055	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00089	        WHILE PORTB<>255
	LABEL?L	L00061	
	CMPEQ?BCL	PORTB, 0FFh, L00062

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00090	           DelayVal=100                                                           
	MOVE?CB	064h, _DelayVal

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00091	           call DelaymS             
	CALL?L	_DelaymS

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00092	        wend    
	GOTO?L	L00061
	LABEL?L	L00062	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00093	    ENDIF
	LABEL?L	L00009	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00094	GOTO Main
	GOTO?L	_Main

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00096	DoUsbOut:      

	LABEL?L	_DoUsbOut	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00097	    USBBufferCount = USBBufferSizeTX
	MOVE?CB	_USBBufferSizeTX, _USBBufferCount

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00098	    USBService
	USBSERVICE?	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00099	    USBOut 1, USBBufferOut, USBBufferCount, DoUsbOut
	USBOUT?CBBL	001h, _USBBufferOut, _USBBufferCount, _DoUsbOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00101	        USBBufferOut[0] = 0
	MOVE?CB	000h, _USBBufferOut

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00111	rETURN
	RETURN?	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00112	DelaymS:

	LABEL?L	_DelaymS	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00113		For DelayCnt = 0 To DelayVal/10	
	MOVE?CB	000h, _DelayCnt
	LABEL?L	L00063	
	DIV?BCN	_DelayVal, 00Ah, T1
	CMPGT?BNL	_DelayCnt, T1, L00064

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00114	        USBService	' Must service USB regularly
	USBSERVICE?	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00115	        pause 10
	PAUSE?C	00Ah

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00116	    Next DelayCnt	
	NEXT?BCL	_DelayCnt, 001h, L00063
	LABEL?L	L00064	

; D:\ELEKTRONIKA\CODE PIC\MY USBKEYBOARD\MYKEYBOARD.BAS	00117	Return   
	RETURN?	

	END
