﻿Public Class frmV_ADC
    Private Sub btnClr1_Click(sender As Object, e As EventArgs) Handles btnClr1.Click
        txtAD1.Text = "0"
        txt8b1.Text = "0"
        txt10b1.Text = "0"
        txt12b1.Text = "0"
        txtAD1.Select()
    End Sub

    Private Sub btnCalc1_Click(sender As Object, e As EventArgs) Handles btnCalc1.Click
        Me.Calculate()
        btnClr1.Select()
    End Sub

    Private Sub Calculate()
        Dim Step8 As Decimal
        Dim Step10 As Decimal
        Dim Step12 As Decimal
        Dim Ad As Decimal
        Dim Vref1 As Decimal

        If Not IsNumeric(txtVref1.Text) Then
            txtVref1.Text = "5.00"
            MessageBox.Show(
                "Please Enter a Valid Number for VREF+ Value",
                "Entry Error")
            txtVref1.Select()
        End If

        Vref1 = CDec(txtVref1.Text)

        If Not IsNumeric(txtAD1.Text) Then
            txtAD1.Text = "0"
            MessageBox.Show(
                "Please Enter a Valid Number for ADC Value",
                "Entry Error")
            txtAD1.Select()
        End If

        Ad = CDec(txtAD1.Text)

        If Ad > Vref1 Then
            txtAD1.Text = "0"
            MessageBox.Show(
            "Volts Cannot Exceed VREF+",
                   "Entry Error")
            txtAD1.Select()
        End If

        Step8 = CDec(txtVref1.Text) / 255
        Step10 = CDec(txtVref1.Text) / 1023
        Step12 = CDec(txtVref1.Text) / 4096

        Dim Val8 As Decimal = Math.Round((txtAD1.Text) / Step8, 2)
        Dim Val10 As Decimal = Math.Round((txtAD1.Text) / Step10, 2)
        Dim Val12 As Decimal = Math.Round((txtAD1.Text) / Step12, 2)


        txt8b1.Text = Str(Val8)
        txt10b1.Text = Str(Val10)
        txt12b1.Text = Str(Val12)

    End Sub

    Private Sub btnVolts_Click(sender As Object, e As EventArgs) Handles btnVolts.Click
        Me.Hide()
        frmADC_V.Show()
    End Sub

    Private Sub txtVref1_Enter(sender As Object, e As EventArgs) Handles txtVref1.Enter
        'txtAD1.Select()
    End Sub

    Private Sub txtAD1_Enter(sender As Object, e As EventArgs) Handles txtAD1.Enter
        Me.Calculate()
    End Sub
End Class
