﻿Public Class frmADC_V
    Private Sub btnAdc_Click(sender As Object, e As EventArgs) Handles btnAdc.Click
        Me.Close()
        frmV_ADC.Show()
    End Sub

    Private Sub btnCalc2_Click(sender As Object, e As EventArgs) Handles btnCalc2.Click
        Dim Res As Decimal
        Dim MaxVal As Integer
        Dim ADC As Integer

        If rbB8.Checked = True Then
            MaxVal = 255
        ElseIf rbB10.Checked = True Then
            MaxVal = 1023
        ElseIf rbB12.Checked = True Then
            MaxVal = 4096
        End If

        If Not IsNumeric(txtAD2.Text) Then
            txtAD2.Text = "0"
            MessageBox.Show(
                "Please Enter a Valid Number for ADC Value",
                "Entry Error")
            txtAD2.Select()
        End If

        If CInt(txtAD2.Text) > MaxVal Then
            txtAD2.Text = "0"
            MessageBox.Show(
            "ADC_Calc Value is Too High",
                   "Entry Error")
            txtAD2.Select()
        End If

        ADC = CInt(txtAD2.Text)
        txtAD2.Text = Str(ADC)

        If rbB8.Checked = True Then
            Res = CDec(txtVref2.Text) / 255
        ElseIf rbB10.Checked = True Then
            Res = CDec(txtVref2.Text) / 1023
        ElseIf rbB12.Checked = True Then
            Res = CDec(txtVref2.Text) / 4095
        End If

        Dim Volts As Decimal = Math.Round((ADC * Res), 4)
        txtAdVolts.Text = Str(Volts)

    End Sub

    Private Sub btnClr2_Click(sender As Object, e As EventArgs) Handles btnClr2.Click
        txtAD2.Text = "0"
        txtAdVolts.Text = "0"
        txtAD2.Select()
    End Sub

    Private Sub frmADC_V_FormClosed(sender As Object, e As FormClosedEventArgs) Handles MyBase.FormClosed
        frmV_ADC.Show()
    End Sub
End Class