;==============================================================================
;************ Retroketas: kettaga telefoni ketas -> Ericsson T28 **************
;***** Felch @ juuli.2005 O.K.!!! *********************************************
; 22.7.2005.: ttab!
;==============================================================================
; Protsessor: PIC 16F88 @ 4 MHz

	INCLUDE	"P16F88.INC"
				errorlevel -302					; Compaileri vingumised ra
				errorlevel -305
				errorlevel -306 
; ***** konf. ***
 	__CONFIG    _CONFIG1, _INTRC_IO & _PWRTE_ON & _BODEN_OFF & _MCLR_OFF & _WDT_ON & _CP_OFF & _CPD_OFF & _LVP_OFF  
; ***** Definitsioonid ***** 
; ***** konstandid *********
#define sound_len 		 .1755					; helifaili pikkus
#define MaxRxBytes			.30+Puhver			; niipalju baite suudame vastu vtta
#define	MaxNumbers			.20					; niipalju numbreid saame korraga valida
#define	nettime				0x4A				; vrgu pollimise taimer (38 sekundit)
#define	serialtime			0x14				; moobla vastuse ootamise aeg (10 sekundit)
#define	dialtime			0x07				; niikaua ootame peale numbri valimist ja siis saadame moblale  (5 sekundit)
#define	T1resoL				0x01
#define	T1resoH				0x00				; Phitaimeri reso - 520mS
#define sagedus				0x90
#define kestus				0x05
#define PRESCbeep			0x07
; ***** Raudvrk *********** 
#define START			PORTB,6					; ketta klemm, mis maas kui ketas keerleb vi teda keeratakse
#define PULSE	      	PORTB,7	                ; ketta klemm, mis pulsib numbri valimisel. Normaalselt maandatud
#define	offhook			PORTB,4					; hargilliti, LOW kui toru hargil
#define	sound_primout	PORTB,0					; esimene saundi vljund
#define	sound_secout	PORTB,1					; teine saundi vljund
#define	sound_tris		TRISB,0					; esimese vljundi TRIS
#define	sound_sectris	TRISB,1					; teise vljundi TRIS
#define LED				PORTA,0					; seisundi tuluke
;#define	AmpON			PORTA,1					; aktiivne 0 llitab vimendile toite peale
; ***** varioossed flagsid ***
#define 		VIGA			Flags,0
#define 		KaskOK			Flags,1
#define 		algus			Flags,3
#define 		Sobib			Flags,4
#define			ignore_answer 	Flags,7			; kui ei taha vastust salvestada (read_SMS'is nitex)


#define			serialtimeron	Flags2,0
#define			serialtimeout	Flags2,1

#define			nettimeron		Flags3,0
#define			nettimeout		Flags3,1

#define CARRY           STATUS,C 
#define ZERO            STATUS,Z 
#define	pank			STATUS,RP0
; ***** variaablid ***
RAMbase         equ     20h            
	cblock  	RAMbase   
				sound_len_hi 					; helifaili pikkuse loendi
				sound_len_lo 
				sound_start_hi					; helifaili jooksva baidi koht 
				sound_start_lo
				sound_byte						; see jooksev bait laetakse siia
				sound_bitcount					; saundi bittide loendi
				CNT        						; viiteaegade loendi
				CNT2        
				CNT3        
				CNT4        
				CNT5
				nettimer						; vrgu polli taimer
				serialtimer						; terminali vastuse ootamise taimer (10 s ja siis VIGA kui ksk ikka poolik)
				Flags							; ssteemi seisund
				Flags1			
				Flags2		
				Flags3		
				W_Temp							; konteksti seivimine katckestuse ajaks
				S_Temp			
				lath_tmp
				FSRtmp			
				temptmp		
				Puhver:.30						; seriali vastuvtu puhver, kuni 30 baiti,
				bytecnt			
				temp			
				temp1			
				temp2			
				temp3			
				ootan			
				waitbytes 		
				RxPointer						; vastuvtu puhvri viit
				VastusNr						; dekodeeritud (mobla) vastuse number
				Parseootan		
				number							; kettaga valitud numbri puhver
				numbripuhver:.10				; siia salvestame valitud numbrid (max. 10 kohta)
				numbripointer
				numbricounter			
				Beep_TEMP1
				Beep_TEMP2
				Beep_TEMP3

	endc
; ***** RESET *****          
				org     0000h  
;==============================================================================
Reset:       goto    Main_Start       			; Alustame siis...
;==============================================================================
;==============================================================================
;===== Interrupt Vector	=======================================================
;==============================================================================
;===============================================================================
; ********************** katskestused ******************************************
;===============================================================================
				org 0x0004
Push	 		movwf   W_Temp           		; seivi kontekst         
				swapf   STATUS,W         
				movwf   S_Temp           		       
				bcf     pank
				movf	FSR,W
				movwf	FSRtmp
				movf	temp,W
				movwf	temptmp
Disable_Int:    bcf     INTCON,GIE       		; keela katkestused         
				btfsc   INTCON,GIE       		       
				goto    Disable_Int      		       

				btfsc	PIR1,RCIF				; Seriali katckestus?
				goto	SerInt					; Seriali katckestus !
I_1				bcf		pank
				btfsc	PIR1,TMR1IF				; Taimer 1'e katckestus?
				goto	T1int
I_2:			bcf		pank
				bcf     PIR1,TMR1IF		
Pop:   			movf	RCREG,W					; see peaks kackestuse maha vtma
				bcf		PIR1,RCIF
				movf	FSRtmp,W
				movwf	FSR
				movf	temptmp,W
				movwf	temp
				swapf   S_Temp,W         
				movwf   STATUS           		; Return STATUS         
				swapf   W_Temp,F         
				swapf   W_Temp,W         		; Return W         
				clrwdt
				retfie                   		; Return setting GIE  
;===============================================================================
; ********************** Taimer 1'e INT ****************************************
;===============================================================================
; * T1 on ssteemi virtuaalsete taimerite taga olev fsiline taimer intervaliga 520 ms.
T1int:	 		bsf		pank
				btfss   PIE1,TMR1IE      		; kas tohib?
				goto	I_2						; ei
				bcf		pank
				movlw	T1resoL					; lae taimer 1 uuesti (katkestus iga 520 mS tagant)
				movwf	TMR1L
				movlw	T1resoH
				movwf	TMR1H
				btfss	serialtimeron			; side taimer kib?
				goto	T1int_1
				decfsz	serialtimer				; aeg tis?
				goto	T1int_1
				bsf		serialtimeout			; jah!
				bcf		serialtimeron			; taimer seisma
				movlw	serialtime
				movwf	serialtimer

T1int_1			btfss	nettimeron				; vrgu polli taimer kib?
				goto	T1int_2
				decfsz	nettimer				; aeg tis?
				goto	T1int_2
				bsf		nettimeout				; jah!
				bcf		nettimeron				; taimer seisma
				movlw	nettime
				movwf	nettimer
T1int_2			bcf     PIR1,TMR1IF    			; katkestuse nue maha   
				goto	Pop
;===============================================================================
; ********************** Seriali INT *******************************************
;===============================================================================
SerInt:			bsf		pank
				btfss	PIE1,RCIE				; kas tohib?
				goto	I_1						; ei!
				bcf		pank
				movlw	06h						; Maskeeri tarbetud bitid
				andwf	RCSTA,W					; viga?
				btfss	STATUS,Z
				goto	RcvError				; Viga!

				movf	RxPointer,W				; lae puhvri pointer
				movwf	FSR
				movf	RCREG,W					; Geti input daata
				movwf	INDF					; Seivi puhvrisse
				movwf	temp					; seivime et vaadata kas sobib otsitavasse jadasse
				incf	RxPointer				; pointeri increment
				incf	bytecnt					; baitide arv +1
				movlw	MaxRxBytes				; tuli liiga palju baite?
				subwf	bytecnt,W				
				btfsc	STATUS,Z
				goto	RcvError1				; jama lugu! -> viga!
				movlw	HIGH Tabel				; kas ksu algus/lpp (0D,0A)?
				movwf	PCLATH		
				movf	ootan,W			
				call	Tabel					; otsitava jada smbol
				clrf	PCLATH
				subwf	temp,W
				btfss	STATUS,Z
				goto	kask_wrong				; ei ole see,salvestame edasi...
				decfsz	waitbytes				; ongi, kas viimane bait?
				goto	kask_next				; vara veel
				goto	kask_kaes				; saigi vastu vetud ksuke

kask_next		incf	ootan					; jrgmine smbol oodatavas jadas
				goto	Pop						; go to end of ISR, restore context, return

kask_kaes		btfss	algus					; kas leidsime vastuse lpu?
				goto	kask_algus				; ei,alguse. Ootame nd lppu
				bsf		KaskOK					; mrgime et ksk kes 
				bcf		algus
				bcf		VIGA					; tarbetu?
				movf	RxPointer,W
				movwf	temp1					; seivi Parseri jaux
				movf	bytecnt,W
				movwf	temp2					; seivi Parseri jaux
				goto	kask_wrong1				; exit, valmistume vastuvtux

kask_algus		bsf		algus					; leidsime alguse smbolid
				movlw	.2						; ootab jlle 2 baiti
				movwf	waitbytes
				goto	Pop
RcvError1
				movlw	Puhver					; nulli vastuvtt:
				movwf	RxPointer				; - puhvri pointer
				movlw	00H					
				movwf	bytecnt					; - baitide loendi
				goto	Pop						; exit
					
RcvError
				movf	RCREG,W					; thjenda RCREG
				bcf		RCSTA,CREN				; nullime pordi
				bsf		RCSTA,CREN
R_e1			bsf		VIGA					; mrgi viga
				goto	RcvError1				; nullime ra!
OtherInt			
				btfss	PIR1,TXIF				; Katkestus saatest?
				goto	RcvError1				; ei, keegi teine segas vahele...
				goto	Pop						; jah, ignoreerime

kask_wrong		btfsc	ignore_answer			; kas salvestame ksulauad?
				call	kask_ignore
kask_wrong1		movlw	VastusOK-Tabel-1		; ootame modemilt vastust: 0D,0A
				movwf	ootan
				movlw	.2						; taastame oodatava baitide arvu
				movwf	waitbytes
				goto	Pop
kask_ignore		decf	RxPointer				; seda baiti ei arvesta
				decf	bytecnt					; kki ei peaks??????????????????????????????????
				return
;==============================================================================
; ***** Phiprogramm **********************************************************
;==============================================================================
Main_Start:		call	init					; majapidamine jonxu
				call	sec_dly					; las rahuneb veica
a1:				clrwdt							; vahipenile saabast...
				bcf		LED						; toimub init
				call	init_gsm				; moblale ka buutsista phn ;)
a2:				clrwdt	
				clrf	PCLATH
				call	rega					; oota kuni vrku regatud
				btfss	VIGA					; sai valmis mingi aja vltel (39 sek.)?
				goto	a2a						; sai!
				call	beep
				goto	a_err					; ei, teeme reseti !
a2a:			call	sec_dly					; las rahuneb veica
a3:				clrwdt
;______________________- phitskkel!-_____________________________________________
				call	wait_a3					; valmistume mobla teate ootamiseks (huvitab RING)
a4:				clrwdt
				btfsc	KaskOK					; saimegi mingi snumi ?
				goto	a4a						; jah
				btfss	offhook					; ei, kas toru tsteti (tahetakse numbrit valida) ?
				goto	a4						; ei, tagasi tsklisse
				bcf		INTCON,GIE
				goto	a6						; hakkame valima


a4a:			bcf		INTCON,GIE
				bcf		KaskOK					; sai mingi teate moblalt, uuri seda lhemalt
				clrf	PCLATH
				call	parse_cmd				; mis KSK anti?
				movlw	0x02					; vastus 2 ehk RING (keegi helistab)?
				subwf	VastusNr,W
				btfss	ZERO				
				goto	a3						; mingi lebra...ignoreeri !
				bcf		LED
				clrf	PCLATH
				call	ringer					; oli RING, helise !
				bsf		LED
				btfss	offhook					; toru tsteti ?
				goto	a3						; ei veel kuid jme ootele

a4d:			clrwdt							; toru tsteti, tle seda moblale
				bcf		LED
;				clrf	PCLATH
				movlw	Send_ATA-TabelS-1		; Saadame ATA+CR
				call	send_Cmd				
				bcf		INTCON,GIE
; oota toru ra panekut...
a5:				clrwdt
				btfsc	offhook					; ootame toru ra panemist
				goto	a5
				call	DLY						; moluta veidi (debouncing)
				btfsc	offhook					; toru ikka ra pandud ?
				goto	a5						; ei, mingi srin kontaktides...
;				clrf	PCLATH
				movlw	Send_ATH-TabelS-1		; Saadame ATH+CR
				call	send_Cmd				; ehk: pane toru ra
				call	DLY						; anna moblale aega liigutada
				goto	a_err					; reseti lbi uus algus...
;				bsf		LED
;				movf	RCREG,W					; valmista serial tks ette 
;				bcf		PIR1,RCIF
;				bsf		pank
;				bsf		PIE1,RCIE				; luba seriali katckestused
;				bcf		pank
;				bsf		INTCON,GIE				
;				call	hangup					; jah, tle seda moblale
;				goto	restore_op				; ja jtka majandamist
; tahaks valima hakata kuid kki tsteti toru hoopis helisemise ajal. Ksime moblalt, millega ta parasjagu tegeleb.
a6:	;			clrf	PCLATH
;	bsf	PORTA,2
				movlw	Send_ATQ1-TabelS-1		; Selleks saadame ATQ1
				call	send_Cmd				; ehk: supressime enamiku mobla vastustest, eriti RINGi
				call	pool_sek_viidet
	;			clrf	PCLATH
				movlw	Send_CIND-TabelS-1		; Ksime, millega tegeled, kas keegi helistab?
				call	send_Cmd				
				clrwdt
;	bcf	PORTA,2
				clrf	PCLATH
				bsf		INTCON,GIE
				call	wait_answer				; ootame vastust
				btfsc	VIGA					; vastus vale vi ji tulemata, rokkoff
				goto	a_err
				bcf		INTCON,GIE
				bcf		KaskOK
				clrf	PCLATH
				call	parse_cmd				; mis vastuse saime?
				movlw	0x04					; tahame vastust 4 ehk CIND
				subwf	VastusNr,W
				btfss	ZERO
;**??? kordaks hoopis ???
				goto	a_err					; lks segi, teeme reseti
				movlw	.14						; vastus olemas, loeme kne olemasolu infot
				addwf	FSR,F
				movf	INDF,W
				sublw	'1'						; kui 1, helistab keegi, kui 0, taheti lihtsalt numbrit valida
				btfss	ZERO
				goto	a6b						; taheti valida...
				call	reportsback				; vastati kellegi helistamisele:luba moblal jlle pikalt mliseda ja tsta toru
				bsf		INTCON,GIE
				goto	a4d

a6b:			call	reportsback				; luba moblal jlle pikalt mliseda
				bsf		INTCON,GIE
				call	rega					; oleme levis ?
				btfss	VIGA
				goto	a6a						; jah, marss valima
				bsf		INTCON,GIE
				call	beep					; ei. ritame veel aga anname vimaluse toru ra panna
				btfsc	offhook					
				goto	a6						; tahetakse ikkagi oodata ja valida
				goto	a_err					; loobuti -> reset
a6a:			btfss	offhook					; toru ikka tstetud ?
				goto	a4						; ei, tagasi tsklisse
				bcf		LED						; tuluke plema
				clrwdt
				bsf		pank
				bcf		PIE1,RCIE				; keela seriali katckestus
				bcf		pank
				movlw	numbripuhver			; siia salvestame valitud numbrid
				movwf	numbripointer
				clrf	numbricounter			; esialgu numbreid ei ole
a7a:			movlw	dialtime				; kui 5 sekundi jooksul enam ei valita, saadame numbri moblale 
				movwf	nettimer
				bcf		nettimeout
				bsf		nettimeron
a7:				btfsc	nettimeout				; aeg valima hakata ?
				goto	a10a					; jah!
				btfss	offhook					; ei, ega vahepeal toru ra visatud ?
				goto	a5;restore_op1				; ne panidki raiped ra...
				clrf	number					; valitud number siia kirja
				clrwdt
				btfsc	START					; valimine algas?
				goto	a7						; ei
				call	DLY						; oota veidi
				btfsc	START					; START ikka =0 ?
				goto	a7						; ei, unusta ra
; **** valimine algas ****
; ootame valimispulsi algust
a8:				clrwdt
				btfsc	START					; valimine lbi ?
				goto	a10						; jah
				btfss	PULSE					; pulss algas ?
				goto	a8						; ei veel
				bsf		LED						; vilgutame kaasa - kustuta LED
				movlw	dialtime				; nulli valimisaja loendi
				movwf	nettimer
				bcf		nettimeout
				clrwdt
				call	DLY						; debounce
				btfss	PULSE					; PULSE ikka =1 ?
				goto	a8						; unusta
; ootame valimispulsi lppu
a9:				clrwdt
				btfsc	PULSE					; lppes ?
				goto	a9						; kestab veel
				call	DLY						; debounce
				btfsc	PULSE					; PULSE psib nullis ?
				goto	a9						; ei, oota veel
				bcf		LED						; vilgutame kaasa - sta LED
				movlw	dialtime				; nulli valimisaja loendi
				movwf	nettimer
				bcf		nettimeout
				clrwdt
; 1 pulss loendatud
				incf	number,F
; kas vahepeal valimine lppes ?
a10:			btfss	START					; ketas kodus ?
				goto	a8						; ei, ootame uut valimispulssi
				clrwdt
				call	DLY						; vist kik selleks korraks, tee debounce kah
				btfss	START
				goto	a8
				clrwdt
;number loetud, salvestame ja valime liinile. Enne kontrolli kas toru pole ra pandud
				btfss	offhook					; ega vahepeal toru ra visatud ?
				goto	a5;restore_op1				; ne panidki raiped ra...

				movf	numbripointer,W
				movwf	FSR
				movf	number,W				; saa soovitud number
				sublw	0x0A					; kontrolli: kui 0x0A, asenda 0x00-ga
				btfss	ZERO
				goto	a10aa					; ei ole 0x0A
				movlw	0x00					; on -> asenda !
				goto	a10ab
a10aa:			movf	number,W				; taasta valitud number
a10ab:			movwf	INDF					; salvesta puhvrisse
				incf	numbripointer,F			; viita jrgmisele kohale
				incf	numbricounter,F			; ja loenda numbreid
				movf	numbricounter,W			; ega liiga palju ?
				sublw	MaxNumbers
				btfsc	ZERO
				goto	restore_op2				; liiga palju!
				btfss	nettimeout				; 5 sekundit pausi olnud, hakkame valima ?
				goto	a7a						; vara veel, las npib ketast

a10a:			movf	numbricounter,W			; on meil ldse numbreid valida ?
				btfsc	ZERO
				goto	a7a						; ei, ootame ketta keerutamist
				movlw	Send_ATD-TabelS-1		; Saadame ATD  ehk valimist ette valmistav ksk
				call	send_Cmd
				clrwdt
				movlw	numbripuhver
				movwf	FSR
a11:			movf	INDF,W					; loe number
				addlw	0x30					; ASCII offset otca
a12:			btfss	PIR1,TXIF
				goto	a12
				movwf	TXREG					; saada moblale
				clrwdt
				incf	FSR,F
				decfsz	numbricounter			; kik ?
				goto	a11						; ei veel
				movlw	Send_ATD_end-TabelS-1	; ja ksu lpp
				call	send_Cmd
				clrwdt
				bcf		nettimeron				; sea vrgu polli taimer korda
				bcf		nettimeout
				movlw	nettime
				movwf	nettimer
				goto	a5						; nd oota toru ra panekut. Kettale jms. ei reageeri.

restore_op2:	call	beep					; tee hlt
				goto	a_err					; reset
	;vilista midagi
restore_op1:	clrwdt
				movf	RCREG,W
				bcf		PIR1,RCIF				
				bsf		pank
				bsf		PIE1,RCIE				; luba katckestused
				bcf		pank
restore_op:		movf	RCREG,W					; seriali vimalik katckestus maha
				bcf		PIR1,RCIF
				bsf		INTCON,GIE
				bsf		nettimeron
				bsf		LED						; lahkudes kustuta tuli ;)
;				call	hangup					; toru ra igaks juhuks
				goto	a3						; tskkel
;______________________- phitskkel lpeb!-________________________________________
;==============================================================================
; ***** Teeme WDT-ga reseti ***************************************************
;==============================================================================
a_err:			bsf		pank					; kiirendame resetti!	
				movlw	B'00001000'				; WDT prescaler 1:1
				movwf	OPTION_REG				
				bcf     pank
a_err_1:		goto	a_err_1					; reset vahipeniga
;==============================================================================
; ***** vrgu polli taimeri reload ja enable **********************************
;==============================================================================
nettimer_on:	movlw	nettime
				movwf	nettimer
				bcf		nettimeout
				bsf		nettimeron				; lubame vrgu polli (taimeri)
				return
;==============================================================================
; ***** Mobla juhtimine *******************************************************
;==============================================================================
;==============================================================================
; ***** lubame verbose reportsid **********************************************
;==============================================================================
reportsback:	bcf		VIGA
				movlw	Send_ATQ0-TabelS-1		; saadame ATQ0
				call	send_Cmd
				bsf		INTCON,GIE
				clrwdt
				clrf	PCLATH
				bsf		INTCON,GIE
				call	wait_answer				; ootame vastust
				btfsc	VIGA					; vastus vale vi ji tulemata, rokkoff
				return
				bcf		INTCON,GIE
				bcf		KaskOK
				clrf	PCLATH
				call	parse_cmd				; mis vastuse saime?
				movlw	0x00					; tahame vastust 0 ehk OK
				subwf	VastusNr,W
				btfsc	ZERO
				return							; oli selline vastus
				bsf		VIGA					; vale vastus
				return
;==============================================================================
; ***** vrku regatuse pollimine **********************************************
;==============================================================================
rega:			clrwdt
				call	nettimer_on				; 39 sekundit ootame ja loodame...
rega0:			bcf		VIGA
				bcf		LED						; vrgu pollimise indikacioon
				movlw	Send_CREG-TabelS-1		; Saadame AT+CREG?+CR
				call	send_Cmd				; kas oleme vrgus?
				clrwdt
				clrf	PCLATH
				bsf		INTCON,GIE
				call	wait_answer				; ootame vastust
				btfsc	VIGA					; vastus vale vi ji tulemata, rokkoff
				return
				bcf		INTCON,GIE
				bcf		KaskOK
				clrf	PCLATH
				call	parse_cmd				; mis vastuse saime?
				movlw	0x03					; tahame vastust 3 ehk CREG
				subwf	VastusNr,W
				btfsc	ZERO
				goto	rega1					; oli selline vastus
rega2:			bsf		VIGA					; mingi kama...
rega3:			bsf		LED						; initsialiseerimine lbi
				bcf		nettimeron				; rohkem ei polli midagi !
				bsf		INTCON,GIE
				return
rega1:			movf	INDF,W					; VAATAME CREG'i argumenti
				sublw	'1'						; 1-vrgus, 2-vljas
				btfsc	ZERO	
				goto	rega3					; initsialiseerimine lbi
				btfss	nettimeout				; kaua juba levi ra?
				goto	rega4					; ei, las ta ritab veel
				bcf		nettimeout
				goto	rega2					; ei saa asja...
rega4:			call	beep					; piiksu
				goto	rega0					; ja rita uuesti
;==============================================================================
; ***** saadame moblale ksu **************************************************
;==============================================================================
send_Cmd:		movwf	ootan
snd_loop:		movlw	HIGH TabelS
				movwf	PCLATH		
				movf 	ootan,W
				movwf	temp
				incf	temp,F
				movlw 	LOW TabelS
				addwf	temp,W
				btfsc	STATUS,C	
				incf	PCLATH
				movf	ootan,W
				call	TabelS
				clrf	PCLATH
snd_cmd_busy:	clrwdt
				btfss   PIR1,TXIF     			; saatja valmis ?   
			    goto    snd_cmd_busy
				movwf	temp
				movlw	1Ah						; kas saime lpubaidi (1Ah, edasi saadame aktiivse sisendi numbri)?
				subwf	temp,W
				btfsc	STATUS,Z
				goto	snd_exit				; lpp
				movf	temp,W
    			movwf   TXREG    				; saada!
				movwf	temp
				movlw	0Dh						; kas saatsime lpubaidi (0Dh)?
				subwf	temp,W
				btfsc	STATUS,Z
				goto	snd_exit				; lpp
				incf	ootan					; jrgmine bait
				goto	snd_loop
snd_exit:		clrwdt
				btfss   PIR1,TXIF     			; saatja valmis ?   
			    goto    snd_exit
				clrwdt
			    return
;==============================================================================
; ***** saadame moblale saapa... **********************************************
;==============================================================================
init_gsm:		bcf		VIGA
				movlw	Send_ATZ-TabelS-1		; Saadame ATZ+CR
				call	send_Cmd				; reset, lae salvestatud profiil
				call	sec_dly					; 1 sekund viidet
S_ATE0			clrwdt
				clrf	PCLATH
				movlw	Send_ATE0-TabelS-1		; Saadame ATE0+CR
				call	send_Cmd				; saate kaja maha
				call	sec_dly					; 1 sekund viidet
				movlw	Puhver
				movwf	RxPointer				; vastuvtupuhvri pointer
				movlw	00H					
				movwf	bytecnt					; vastuvetud baitide loendi
				
				bsf		T1CON,TMR1ON			; vrgu polli timer kima
				clrwdt
				return
;==============================================================================
; ***** Moblalt vastuse ootamine... *******************************************
;==============================================================================
wait_answer:	movlw	serialtime
				movwf	serialtimer
				bcf		serialtimeout
				bsf		serialtimeron			; taimer vastuvttu jlgima
				call	wait_a3
wait_a1:		clrwdt
				btfsc	serialtimeout			; kas vastus viibib (midagi tuksus)?
				bsf		VIGA					; modem ei tsta toru :(
wait_a11		btfsc	VIGA					; kik igesti?
				goto	wait_a_viga1			; vesi peale
				btfss	KaskOK					; saimegi ige vastuse?
				goto	wait_a1					; oota kannatlikult
				goto	wait_a_viga				; exit
wait_a_viga1:	clrwdt
				bcf		serialtimeout
				bcf		serialtimeron
				movlw	serialtime
				movwf	serialtimer
				return		
wait_a_viga:	bcf		VIGA
				bcf		serialtimeout
				bcf		serialtimeron
				movlw	serialtime
				movwf	serialtimer
				clrwdt
				return
;-------------------------------
wait_a3:		bcf		algus
wait_a3b		movlw	VastusOK-Tabel-1		; ootame modemilt vastust: OK
				movwf	ootan
				movlw	.2						; see teeb 2 baiti
				movwf	waitbytes
wait_a3a		movlw	Puhver
				movwf	RxPointer				; vastuvtupuhvri pointer
				movlw	00H					
				movwf	bytecnt					; vastuvetud baitide loendi
				bcf		KaskOK
				bcf		VIGA
				return
;==============================================================================
; ***** Mobla vastuse parsimine... ********************************************
;==============================================================================
parse_cmd:		movlw	Puhver+.2				; stringi algus
				movwf	FSR
				movwf	CNT3					; siia seivib pointeri
				movlw	0x00					; alustame vastusest nr. 0
parse_cmd1		movwf	VastusNr				; siia siseneme SMS-ksu dekodeerimisel
				movwf	Parseootan				; offset tabelites sorimiseks
				bsf		Sobib					; esialgu vastet ..olgu olemas
parser			movf	INDF,W					; Geti input daata
				movwf	CNT						; seivime 
				sublw	0x0d					; Kas stringi lpp?
				btfsc	STATUS,Z
				goto	parser_strend			; 1 kirje lbi kidud
				movlw	MaxRxBytes				; le puhvri re?
				subwf	FSR,W				
				btfsc	STATUS,Z
				goto	str_err					; jah, otsitavat ei leitud...

parser_comp		call	IndexTabelV
				movwf	CNT2					; ajutine seiv
				sublw	0x0d					; kas stringi lpp tabelis?
				btfsc	ZERO
				goto	str_kaes				; jah, edasine ei huvita
				movf	CNT2,W					; kas kki vastuste tabeli rest le mindud?
				sublw	0xFF					; tabeli lpu string
				btfsc	STATUS,Z
				goto	parser_strerr			; vastust ei leitud, vastuse numbriks kirjutame 0xFF
				movf	CNT2,W					; ei, taasta tabelist saadud vrtus
				subwf	CNT,W
				btfss	STATUS,Z
				goto	str_wrong				; ei ole see...

				goto	str_next
				goto	str_kaes				; saigi vastu vetud ksuke

str_next		incf	Parseootan				; jrgmine smbol oodatavas jadas
				incf	FSR						; pointeri increment
				goto	parser					; tskkel
str_wrong		movf	CNT3,W					; otsimine jlle puhvri algusest
				movwf	FSR
				incf	VastusNr				; jrgmine snum
				bsf		Sobib		
parse_next_str	incf	Parseootan
				call	IndexTabelV				; keri jrgmise stringi algusesse
				sublw	0x0D		
				btfss	STATUS,Z
				goto	parse_next_str
				incf	Parseootan
				goto	parser					; tskkel
str_kaes		bsf		KaskOK					; mrgime et ksk kes ja valmistame puhvri jrgnevaks ette
;				movf	FSR,W					; seivime baidi aadressi
;				movwf	temp3
				goto	str_exit
parser_strerr	movlw	0xFF					; FF=et vastust ei leitudki
				movwf	VastusNr
				bsf		VIGA
str_err			bcf		KaskOK					; vi teex lipu ParsedOK ??? Parem kasutax Sobib lippu aga puhvri nullimine jgu ra!
str_exit		movlw	Puhver					; valmistume jrgnevaks vastuvtuks:
				movwf	RxPointer				; - puhvri pointer
				movlw	00H					
				movwf	bytecnt					; - baitide loendi
				movwf	ootan					; - tabeli pointer !!! ja mida sellega teha??????????????????????????
				clrwdt
				return		
parser_strend	btfss	Sobib					; vastavus leitud?
				goto	parser_strend1			; ei
				goto	str_exit				; jepp, lpetame ra	- VastuseNR-s ksu number, kui VIGA=1, ei leitud vastust
parser_strend1	incf	VastusNr				; vtame jrgmise stringi tabelist
				bsf		Sobib					; oletame jlle, et leidsime ige asja
				goto	str_next				; jtka
; *** otsime TabelV-st **********************************************************
IndexTabelV:	movlw	HIGH TabelV				; stringide tabel
				movwf	PCLATH		
				movf	Parseootan,W			; offset
				movwf	temp
				incf	temp,F
				movlw 	LOW TabelV
				addwf	temp,W
				btfsc	STATUS,C	
				incf	PCLATH
				movf	Parseootan,W
				call	TabelV					; saa otsitava jada smbol
				clrf	PCLATH
				return
;==============================================================================
; ***** Helieffektid **********************************************************
;==============================================================================
;==============================================================================
; ***** lihtsalt piiks ********************************************************
;==============================================================================
beep:			movlw	kestus
				movwf	Beep_TEMP2				; vta kestus
				movlw	sagedus
				movwf	Beep_TEMP1				; vta sagedus
				bcf		sound_primout			; heli otc nulli
				clrf	TMR0
				bsf		pank
				movlw	PRESCbeep				; sea ajakonstant
				movwf	OPTION_REG
				bcf		pank
beep1:			bcf		INTCON,T0IF
				clrwdt
beep2:			bsf		sound_primout			; hle otc krgeks
				call	B_Wait					; oota natuke
				bcf		sound_primout			; hle otc jlle nulli
				call	B_Wait					; oota veel
				btfss	INTCON,T0IF	
				goto	beep2
				decfsz	Beep_TEMP2
				goto	beep1
				bsf		pank
				movlw	B'00001111'				; taasta originaalkonf
				movwf	OPTION_REG				
				bcf		pank
				return

B_Wait:			movf	Beep_TEMP1,W
				movwf	Beep_TEMP3
B_Wait1:		clrwdt
				decfsz	Beep_TEMP3
				goto	B_Wait1
				return
;==============================================================================
; ***** Kella helin ***********************************************************
;==============================================================================
ringer:			bsf     pank					; konfib masinat natuke ringi
				movlw	b'10000000'				; PORTB pull-upid maha, prescaler 1:1 ja T0-le
				movwf   OPTION_REG      		 
				bcf     pank
				clrwdt
				bcf		INTCON,GIE
				movlw	high (sound_len) +1		; lae saundi pikkuse loendi
				movwf	sound_len_hi
				movlw	low (sound_len)+1
				movwf	sound_len_lo

				movlw	0x00					; saundi jooksva baidi viit mlna algusesse
				movwf	sound_start_hi
				movlw	0x00
				movwf	sound_start_lo
ringer_1:		clrwdt
				movlw	0x08					; baidis on 8 bitti...tavaliselt
				movwf	sound_bitcount
				call	get_byte				; lae jrjekordne saundi bait
ringer_2:		btfss	TMR0,6					; Timer 0 >= 64 ?
				goto	ringer_2				; ei, oota seda hetke
				movlw	.6						; lae timer 0 uuesti
				movwf	TMR0					; we lost around 6 cycles in the loop above
				clrwdt
				bcf		CARRY
				rlf		sound_byte,F			; nihuta saundi MSB bitt ette
				btfss	CARRY					; bitt oli 1 ?
				goto	sound_output0			; bitt oli 0 -> saada esimesesse vljundisse 
				btfsc	sound_primout			; bitt oli 1 aga enne oli...?
				goto	sound_last1_1			; enne oli samuti 1 => mlemad vljundid HIGH
				bsf		pank					; enne oli 0 ehk erinev => 1. jb HIGH, 2. lheb float'i
				bsf		sound_sectris			; 2. vljund llitada sisendiks
				bcf		pank
				goto	sound_last1				; finally set the primary Output-Pin to 1

sound_last1_1:	bsf		pank
				bcf		sound_sectris			; 2. vljund vljundiks
				bcf		pank
				bsf		sound_secout			; 2. vljund -> HIGH

sound_last1:	bsf		sound_primout			; 1. vljund -> HIGH
				goto	sound_nextbit			; bitt maha mngitud!
	
sound_output0:	btfss	sound_primout			; saime biti 0 aga mis enne bitt enne oli ?
				goto	sound_last0_0			; enne oli samuti 0 => vrdsed => mlemad vljundiks ja LOW (?)
				bsf		pank					; enne oli 1 ehk erinevad => 1. vljund -> LOW, 2. vljund lheb float'i
				bsf		sound_sectris			; sea 2. vljund sisendiks
				bcf		pank
				goto	sound_last0				; sti 1. vljund -> LOW'ks

sound_last0_0:	bsf		pank
				bcf		sound_sectris			; 2. vljund vljundiks
				bcf		pank
				bcf		sound_secout			; 2. vljund -> LOW

sound_last0:	bcf		sound_primout			; 1. vljund -> LOW

sound_nextbit:	decfsz	sound_bitcount,F		; mrgi et 1 bitt juba jlle taasesitatud
				goto	ringer_2				; vta jrgmine bitt
				decfsz	sound_len_lo,F			; kas fail otsa saanud ?
				goto	ringer_1				; laula, laula linnuke...
				decfsz	sound_len_hi,F		
				goto	ringer_1
				bsf		pank	
				bcf		sound_tris				; vaikus on kuldne...
				bcf		sound_sectris			
				bcf		pank
				bcf		sound_primout			
				bcf		sound_secout			
				bcf		PIR1,RCIF				; pendivad katckestused naahui!
				bcf		PIR1,TMR1IF
				movf	RCREG,W
				bsf		pank					; eelmine konf tagasi
				movlw	B'00001111'				; WPU-d sisse, WDT peale, prescaler 1:128, TMR0 sisemise taktiga
				movwf	OPTION_REG				
				movlw	B'00100001'		 		; luba ser. receive ja T1 intsid
				movwf	PIE1
				bcf		pank
				bsf		INTCON,GIE
				return							
;==============================================================================
; ***** Lae helina jrjekordne bait *******************************************
;==============================================================================
get_byte:		movf	PCLATH,W				; loeb messitabelist baidi vastavalt LCD_Count vrtusele
				movwf	lath_tmp
   				call	saund					; loe bait
				movwf	sound_byte				; ja seivi
				movf	lath_tmp,W				; taasta PCLATH
				movwf	PCLATH	
				bcf		CARRY
				movf	sound_start_lo,W		; viita jrgmisele
				addlw	.1
				movwf	sound_start_lo
				btfsc	CARRY
				incf	sound_start_hi,F
				return
;===============================================================================
;	Wiide W*0.5 sekundit		       
;===============================================================================
pool_sek_viidet:movlw	0x01
				goto	SEC_DELAY
sec_dly:		movlw	0x02					; 1 sekund viidet
SEC_DELAY: 		MOVWF	CNT						;LOAD DISPLAY TIME IN APPROX SECONDS   
LOOP5:			MOVLW	.4						;LOAD W WITH .42 	
				MOVWF	CNT4					;AND INTO COUNTER  
LOOP4:			MOVLW	.198					;LOAD W WITH .198 	
				MOVWF	CNT3					;AND INTO COUNTER  
LOOP3:			MOVLW	.200					;LOAD W WITH .200 	
				MOVWF	CNT2					;AND INTO COUNTER  
LOOP2: 			DECFSZ	CNT2					;DECREMENT THE COUNTER 	
				GOTO	LOOP2					;GOTO LOOP AGAIN  	
				clrwdt
				DECFSZ	CNT3					;DECREMENT THE OTHER COUNTER 
				goto	LOOP3					;IF NOT FINNISHED, GOTO LOOP AGAIN  	
				DECFSZ	CNT4					;DECREMENT THE OTHER COUNTER 	B	LOOP4		
				goto	LOOP4					;IF NOT FINNISHED, GOTO LOOP AGAIN  	
				DECFSZ	CNT,1					;DECREMENT THE OTHER COUNTER 	B	LOOP5		
				goto	LOOP5					;IF NOT FINNISHED, GOTO LOOP AGAIN  	
				RETURN 
DLY:			MOVLW	.200					;LOAD W WITH .200 	
				MOVWF	CNT2					;AND INTO COUNTER  
DLY1: 			DECFSZ	CNT2					;DECREMENT THE COUNTER 	
				GOTO	DLY1					;GOTO LOOP AGAIN  	
				RETURN 
;==============================================================================
; ***** Seame kik mis vaja korda... ******************************************
;==============================================================================
; **** kalibreeri sisemine gener ****
init:			clrf	INTCON					; katckestused maha
				bsf     pank     		 
				movlw	0x6E					; sisemine 4MHz oss 					
				movwf 	OSCCON 				
				movlw 	0x07 					; analoog komparaator vlja
				movwf 	CMCON 
				clrf	ANSEL					; kik digi
;				clrf	ADCON1
				bcf		pank
;				clrf	ADCON0
;				clrf	CCP1CON
; **** konf. ****
				bsf		pank
				movlw	B'00001111'				; WPU-d sisse, WDT peale, prescaler 1:128, TMR0 sisemise taktiga
				movwf	OPTION_REG				
				movlw	B'00100001'		 		; luba vaid ser. receive ja T1 intsid
				movwf	PIE1
				bcf		pank
; **** pordid ****
				clrf	PORTA					; port nullida	
				clrf	PORTB					; port nullida	
				bsf		pank
				movlw 	B'11110100'				; ketas,nupp, hargilliti ja RS232 sisendiks, heli otcad vljundiks
				movwf	TRISB			
				movlw	0x00					; LED ja muud pinnid vljundid
				movwf	TRISA			
				bcf		pank
				movlw	0xF4;E					; pordi lhteseis: ketta otsad, rs232 ja offhook krged, heli vljundid madalad
				movwf 	PORTB 
				movlw	0x03					; pordi lhteseis: LEDi ja muud vljundid madalad
				movwf 	PORTA 
; **** variaablid ****
				movlw	Puhver
				movwf	RxPointer				; vastuvtupuhvri pointer
				movlw	00H					
				movwf	bytecnt					; vastuvetud baitide loendi
				movwf	Flags					; libud pikali
				movwf	Flags1	
				movwf	Flags2	
				movwf	Flags3
; **** USARTi hlestus ****
				bsf		pank		
				movlw	.25						; baudrate = 9600
				movwf	SPBRG		
				movlw	B'00100110'
				movwf	TXSTA
				bcf		STATUS,RP0
				movlw	B'10010000'
				movwf	RCSTA
; **** initsialiseerime taimerid ****
				movlw	serialtime				; initsialiseerime taimerid
				movwf	serialtimer
				movlw	nettime
				movwf	nettimer
; **** lae ssteemi phitaimer ****
				movlw	T1resoL					; lae taimer 1 (katkestus iga 520 mS tagant)
				movwf	TMR1L
				movlw	T1resoH
				movwf	TMR1H
				movlw	B'00110001'
				movwf	T1CON					; 1:8 prescaler, taimerina, kima !
				bcf     PIR1,TMR1IF    			; ja katkestuse nue maha  
				movlw	B'11000000'				; GIE ja PEIE  lubada!
				movwf	INTCON
				movf	RCREG,W					; seriali vimalik katckestus maha
				bcf		PIR1,RCIF
				bsf		PIR1,TXIF
    			return  
				org 	0x300
;===============================================================================
;****************** tabelid ****************************************************
;===============================================================================
Tabel:			addwf	PCL,F
VastusOK:		retlw	0Dh						; ksu alguse/lpu smbolid
				retlw	0Ah
;===============================================================================
TabelV:			addwf	PCL,F					; modemi vastuste loetelu
VastusOKEI:		retlw	'O'						; OK (0)
				retlw	'K'
				retlw	0Dh
VastusERR:		retlw	'E'						; ERROR (1)
				retlw	'R'
				retlw	'R'
				retlw	'O'
				retlw	'R'
				retlw	0Dh
VastusRING:		retlw	'R'						; RING (2)
				retlw	'I'
				retlw	'N'
				retlw	'G'
				retlw	0Dh
VastusCREG		retlw	'+'						; +CREG: 0, (3)
				retlw	'C'						
				retlw	'R'
				retlw	'E'
				retlw	'G'
				retlw	':'
				retlw	' '
				retlw	'0'
				retlw	','
				retlw	0Dh
VastusCIND:		retlw	'+'						; +CIND: (4)
				retlw	'C'						
				retlw	'I'
				retlw	'N'
				retlw	'D'
				retlw	':'
				retlw	' '
				retlw	0Dh
				retlw	0xFF					; vastust ei leitud !
;===============================================================================
;-------------------------------				; saatmine
;===============================================================================
TabelS:			addwf	PCL,F
Send_ATZ:		retlw	'A'						; lae salvestatud profiil
				retlw	'T'
				retlw	'Z'
				retlw	0Dh
Send_ATE0:		retlw	'A'						; kaja maha
				retlw	'T'
				retlw	'E'
				retlw	'0'
				retlw	0Dh
Send_CREG:		retlw	'A'						; ksi vrku logitust
				retlw	'T'
				retlw	'+'
				retlw	'C'
				retlw	'R'
				retlw	'E'
				retlw	'G'
				retlw	'?'
				retlw	0Dh
Send_ATH:		retlw	'A'						; pane toru ra
				retlw	'T'
				retlw	'H'
				retlw	0Dh
Send_ATA:		retlw	'A'						; vasta knele
				retlw	'T'
				retlw	'A'
				retlw	0Dh
Send_ATD:		retlw	'A'						; helista numbril xxxx
				retlw	'T'
				retlw	'D'
				retlw	1Ah
Send_ATD_end:	retlw	';'						; helistamise ksu lpp
				retlw	0Dh
Send_ATQ0:		retlw	'A'						; teated tagasi
				retlw	'T'
				retlw	'Q'
				retlw	'0'
				retlw	0Dh
Send_ATQ1:		retlw	'A'						; enamik teadetest maha
				retlw	'T'
				retlw	'Q'
				retlw	'1'
				retlw	0Dh
Send_CIND:		retlw	'A'						; ksi seisundit
				retlw	'T'
				retlw	'+'
				retlw	'C'
				retlw	'I'
				retlw	'N'
				retlw	'D'
				retlw	'?'
				retlw	0Dh
;==============================================================================
; ***** Inkluudime helifilee **************************************************
;==============================================================================
	org 0x400
	INCLUDE	"sound.inc"	; helifail
	END
