'****************************************************************
'*  Name    : ELAPSED.PBP                                       *
'*  Author  : Darrel Taylor                                     *
'*  Notice  : Copyright (c) 2003                                *
'*  Date    : 12/16/2003                                        *
'*  Notes   :                                                   *
'****************************************************************

Define  INTHAND _ClockCount    ' Tell PBP Where the code starts on an interrupt
Include "ASM_INTS.bas"         ' ASM Interrupt Stubs

Ticks    var byte   ' 1/100th of a second
CentiSeconds var byte
Seconds  var byte
Minutes  var byte
Hours    var byte
extint	 var word
R0save   var word
R1save   var word

sendpulses var word[25]
intsync var bit

TicksChanged	var bit
SecondsChanged   var bit
CentiChanged var bit
SecondsChanged = 1
Goto OverElapsed

' ------------------------------------------------------------------------------
Asm

TimerConst = 03CB7h

  
; -----------------  ADD TimerConst to TMR1H:TMR1L
ADD2_TIMER   macro
    CHK?RP  T1CON
    BCF     T1CON,TMR1ON           ; Turn off timer
    MOVLW   LOW(TimerConst)        ;  1
    ADDWF   TMR1L,F                ;  1    ; reload timer with correct value
    BTFSC   STATUS,C               ;  1/2
    INCF    TMR1H,F                ;  1
    MOVLW   HIGH(TimerConst)       ;  1
    ADDWF   TMR1H,F                ;  1
    endm

; -----------------  ADD TimerConst to TMR1H:TMR1L and restart TIMER1 
RELOAD_TIMER  macro
    ADD2_TIMER
    BSF     T1CON,TMR1ON           ;  1    ; Turn TIMER1 back on
    CHK?RP  PIR1
    bcf     PIR1, TMR1IF           ; Clear Timer1 Interrupt Flag
    endm

; -----------------  Load TimerConst into TMR1H:TMR1L 
LOAD_TIMER  macro
EndAsm
    T1CON.0 = 0                    ; Turn OFF Timer1
    TMR1L = 0
    TMR1H = 0
Asm
    ADD2_TIMER
    endm
EndAsm

' ------[ This is the Interrupt Handler ]---------------------------------------
ClockCount:   ' Note: this is being handled as an ASM interrupt
@ INT_START                    
'
  R0save = R0                     
  R1save = R1                     

@ RELOAD_TIMER                    ; Reload TIMER1


Ticks = Ticks + 1

'CentiSeconds = CentiSeconds + 1
'if CentiSeconds = 10 then
'CentiSeconds = 0;
'CentiChanged = 1;
'endif


if Ticks = 100 then
Ticks = 0
Seconds = Seconds + 1
sendpulses[0] = sendpulses[0] + 1
       SecondsChanged = 1
       if Seconds = 60 then
Seconds = 0
Minutes = Minutes + 1
       endif
       if Minutes = 60 then
Minutes = 0
Hours = Hours + 1
       endif
       if Hours = 24 then
Hours = 0
endif
endif

overextint:

 R1 = R1save                     ; Restore the PBP system vars
 R0 = R0save
@ INT_RETURN                      ; Restore context and return from interrupt

'-----====[ END OF TMR1 Interrupt Handler ]====---------------------------------

StartTimer:
    T1CON.1 = 0                   ; (TMR1CS) Select FOSC/4 Clock Source
    T1CON.3 = 0                   ; (T1OSCEN) Disable External Oscillator
    PIR1.0  = 0                   ; (TMR1IF) Clear Timer1 Interrupt Flag
    PIE1.0  = 1                   ; (TMR1IE) Enable TMR1 overflow interrupt
    INTCON.6 = 1                  ; (PEIE) Enable peripheral interrupts
    INTCON.7 = 1                  ; (GIE) Enable global interrupts
    T1CON.0 = 1                   ; (TMR1ON) Start TIMER1
return

; -----------------
StopTimer:
    T1CON.0 = 0                   ; Turn OFF Timer1
return

; -----------------
ResetTime:
    R0save = T1CON.0              ; Save TMR1ON bit
    T1CON.0 = 0                   ; Turn OFF Timer1
    TMR1L = 0
    TMR1H = 0
@   LOAD_TIMER                    ; Load TimerConst
    T1CON.0 = R0save              ; Restore TMR1ON bit
    Ticks = 0
    Seconds = 0
    Minutes = 0
    Hours = 0
return

OverElapsed:



