' Program MAX_TEMP.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read the temperature from an LM35 connected to the input of a MAX187 ADC
' and display the result in degrees Centigrade on a serial LCD set for Inverted 9600 baud
' This program uses a 3 wire interface with the MAX187

' MAX187 pin connections: -

' DOUT  (Serial data out,   PORTB.2)
' CS    (Active-low select, PORTB.1)
' SCLK  (Serial clock line, PORTB.0)

	Include "Modedefs.Bas"

' ** Setup Crystal Frequency in Mhz **

	Define 	OSC		4			' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA			' Debug PortA
	Define	DEBUG_BIT	0			' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600			' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1			' Set Serial Mode Inverted
	Define	DEBUG_PACING	500			' Delay 'in Us' between characters sent

' ** Declare the variables **

	Max_Val		Var	Word			' 12 bit ADC result
	Bit_Cnt		Var	Max_Val .Lowbyte	' General purpose loop (re-use MAX_VAL)
	Chr		Var	Max_Val .Highbyte	' Degrees sign build variable (re-use MAX_VAL)
	Sclk  		Var 	PortB.0			' MAX187 serial clock input
	Cs    		Var 	PortB.1			' MAX187 chip select line
	Dout   		Var 	PortB.2			' MAX187 serial data output

' ** Declare the LCD control constants **

	I		Con	254	  		' Control byte for LCD
	Clr		Con	1	  		' Code to clear the LCD
	Line1		Con	128	  		' Point to Line 1 of the LCD
	Line2		Con	192	  		' Point to Line 2 of the LCD

' ** THE MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30				' Clear the LCD
	Debug I,Line1,"  TEMPERATURE"

' Build the degrees symbol in the LCD's character ram
' As character four

	For Bit_Cnt =0 to 7			' 
	Lookup Bit_Cnt,[%00000110,%00001001,%00001001,%00000110,0,0,0,0],Chr
  	Debug I,(CGRAM+32)+Bit_Cnt,Chr		' Output the bit patterns to the LCD's CGRAM
	Next

Main:	Gosub MAX_In					' Go and do a sample
	Debug I,Line2+4,dec2 (Max_Val/10),".",dec1 (Max_Val//10),4,"C" ' Display the degrees centigrade
	Pause 500
	Goto Main					' Do it forever

' This subroutine aquires a sample from the MAX187.
' And returns with the voltage in the variable "MAX_VAL" 
MAX_In:
	Max_Val=0
	Low Cs						' Activate the MAX187
	Shiftin Dout,Sclk,Msbpost,[Max_Val\12]		' Clock 12 bits into "Max_Val"
	High Cs						' Deactivate the MAX187
	Return						' Exit the subroutine



