' Program LM35_87X.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read the temperature, using the National Semiconductor LM35 temperature sensor
' The temperature and its corresponding voltage is displayed on a serial LCD
' Connected to PortC.6

' For use with the PIC16F87X range of PICs

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		20		' Set Xtal Frequency

' ** Setup the DEBUG Defines **

	Define	DEBUG_REG	PortC		' Debug PortC
	Define	DEBUG_BIT	6		' *** Debug pin Bit-6 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Setup the ADCIN Defines **

	Define	ADC_BITS	10		' Set resolution of conversion
	Define	ADC_CLOCK	2		' Set clock source (x/FOSC or FRC)
	Define	ADC_SAMPLEUS	50		' Set sampling time (in uS)

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD

' ** Declare the Variables **

	AD_Raw		Var	Word		' 16-bit result of A/D conversion
	AD_Result	Var	Word		' Quantasized ADC result
	Bit_Cnt		Var	Byte		' General purpose loop
	Chr		Var	Byte		' Degrees sign build variable
	Quanta		Con	1250

' ** THE MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30			' Clear the LCD

' Build the degrees symbol in the LCD's character ram
' As character four

	For Bit_Cnt =0 to 7			' 
	Lookup Bit_Cnt,[%00000110,%00001001,%00001001,%00000110,0,0,0,0],Chr
  	Debug I,(CGRAM+32)+Bit_Cnt,Chr		' Output the bit patterns to the LCD's CGRAM
	Next

	ADCON1= %10001110			' Configure for AN0 as analogue input
						' With right justified result
Again:	ADCIN 0,AD_Raw				' Place the conversion of channel0 into AD_RAW
'	AD_Result=(AD_Raw*10) */ Quanta		' Quantasize the result
	Debug I,Line1,#(AD_Result/100),".",#(AD_Result//100),4,"C "	' Display the temperature
	Debug I,Line2,#(AD_Result/1000),".",#(AD_Result//1000)," Volts   "' Display the voltage
	Pause 200				' A small delay
	Goto Again				' Do it forever