' Program
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Picbasic Pro program to read DS1820 1-wire temperature sensor
' and display temperature on a serial LCD, in Big Digits.

	Include "Modedefs.Bas"
'	Include "BigNums.Inc"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
'	Define	DEBUG_PACING	50		' Delay 'in Us' between characters sent

' ** Declare the Variables **

	Cmd 		Var     Byte            ' Storage for command
	Loop    	Var     Byte            ' Storage for loop counter
	Temperature    	Var     Word            ' Storage for temperature
	Degrees		Var	Word
	DQ      	Var     PortB.0         ' Alias DS1820 data pin (with pullup resistor)
	Dq_Dir  	Var     TrisB.0         ' Alias DS1820 data direction pin


        Pause 300               		' Wait for Pic to wake up from reset
	Debug I,Clr:Pause 30			' Clear the LCD

'        Debug I,Line1,"Temp in degrees C"      ' Display message


' Mainloop to read the temperature and display on LCD
mainloop:
        Gosub Init1820          		' Initialize the DS1820
        Cmd=204:Gosub Write1820           	' Issue the SKIP ROM command
        Cmd=68:Gosub Write1820           	' Start the temperature conversion
        
        Pause 100              			' Wait for the conversion to complete

        Gosub Init1820          		' Do another init
        Cmd=204:Gosub Write1820           	' Issue another SKIP ROM command
        Cmd=190:Gosub Write1820           	' Read the temperature
        
	DispVal=Degrees				' Load DispVal with the temperature to display
	Debug I,Line4+14,4			' Place the decimal point
	Gosub BigLCD				' Display the temperature with big numbers.
'       Debug I,Line2,#Degrees			' ** Display the decimal temperature **

	Goto Mainloop           		' Do it forever

' Initialize DS1820 and check for its presence
init1820:
        Low DQ                  		' Set the data pin low to init
        Pauseus 500             		' Wait for more than 480us
        Dq_Dir=1              			' Release the data pin (set to input for high)
        Pauseus 100             		' Wait for more than 60us
'        If DQ = 1 then
'        Debug I,Line2,"DS1820 not present        "
'        Pause 500
'        Goto mainloop   			' Try again
'        Endif
        Pauseus 400             		' Wait for the end of presence pulse
        Return

' Write "command" byte to the DS1820
write1820:
        For Loop=1 to 8          		' 8 bits to a byte
        If Cmd.0=0 then
        Low DQ					' Write a 0 bit
        Pauseus 60              		' Pull low for more than 60us for 0
        Dq_Dir=1              			' Release the data pin (set to input for high)
        Else
        Low DQ                  		' Pull low for less than 15us for 1
@       Nop                     		' Delay 1us at 4MHz
        Dq_Dir=1              			' Release the data pin (set to input for high)
        Pauseus 60              		' Use up rest of time slot
        Endif
        Cmd=Cmd >> 1  				' Shift to the next bit
        Next Loop
        Return

' Read temperature from the DS1820
Read1820:
        For Loop=0 to 15         		' 16 bits to a word
        Low DQ                  		' Start the time slot
@       Nop                     		' Delay 1us at 4MHz
        Dq_Dir=1              			' Release the data pin (set to input for high)
        If DQ=0 then
	Temperature.0[Loop]=0
	Else
	Temperature.0[Loop]=1		
        Endif
        Pauseus 60              		' Wait out rest of time slot
        Next Loop
	Degrees=((Temperature &%11111110)>>1)*10
	Degrees=Degrees+(Temperature.0*5)	' Strip off and add bit 0 (0.5 degree)
        Return


