' Program DS1820.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read a DS1820 1-wire temperature sensor 
' and display the temperature (in degrees centigrade) on a serial LCD

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD

' ** Declare the Variables **

	Cmd 		Var     Byte            ' Command byte
	Bit_Cnt    	Var     Byte            ' Bit Counting loop
	Temp    	Var     Word            ' Temperature Word
	Deg		Var	Word		' Conversion to centigrade Word
	DQ      	Var     PortB.0         ' Assign the DS1820 data pin (with pullup resistor)
	DQ_DIR  	Var     TrisB.0         ' Assign the DS1820 data direction pin
	DS_Valid	Var	Bit		' DS1820 present flag
	Negative	Var	Bit		' Negative or positive temperature flag
	Neg_Pos		Var	Byte		' Holds the minus character for negative temperatures

' ** THE MAIN PROGRAM STARTS HERE **

	Debug I,Clr:Pause 30			' Clear the LCD

' Build the degrees symbol in the LCD's character ram
' As character four
	For Bit_Cnt =0 to 7			' 
	Lookup Bit_Cnt,[%00000110,%00001001,%00001001,%00000110,0,0,0,0],Cmd
  	Debug I,(CGRAM+32)+Bit_Cnt,Cmd		' Output the bit patterns to the LCD's CGRAM
	Next

' Read the temperature from the DS1820
Main:
        Gosub DS_Init          			' Initialise the DS1820
        Cmd=204:Gosub DS_Write           	' Send SKIP ROM command (CCh))
        Cmd=68:Gosub DS_write           	' Send START TEMPERATURE CONVERSION command (44h)
        Pause 20              			' Wait for conversion to complete (*precautionary only*)
        Gosub DS_Init          			' Do another initialisation
        Cmd=204:Gosub DS_Write           	' Send SKIP ROM command (CCh)
        Cmd=190:Gosub DS_Write 			' Send READ SCRATCHPAD command (BEh)         	
        Gosub DS_Read				' Read the temperature

	If DS_Valid=0 then			' If DS_VALID is clear then no device was detected
	Debug I,Line1," * No Device * "		' Display a warning
        Pause 500				' Wait
	Debug I,Clr:Pause 30			' Clear the LCD
	Goto Main				' Try again
	Endif

' ** Display the temperature **
' First check the flag, NEGATIVE,
' If its 1 then the temperature is a negative value
' So place the minus sign in the variable NEG_POS
' If its 0 then the temperature is positive
' SO place a space in the NEG_POS variable
	If Negative=1 then 			' Check the flag NEGATIVE			
	 Neg_Pos="-"				' Minus sign if negative
	Else					' Else
	 Neg_Pos=" "				' Space if positive temperature
	Endif
	Debug I,Line1,"  Temperature"
	Debug I,Line2+4,Neg_Pos,#(Deg/10),".",#(Deg//10),4,"C " ' Display the temperature on line 1
	Goto Main           			' Do it forever

' Initialize the DS1820 and check for its presence
' DS_VALID will return holding 1 if the DS1820 was detected
' DS_VALID will return holding 0 if the DS1820 was NOT detected

DS_Init:
        Low DQ                  		' Set the data pin low to initialize
        Pauseus 500             		' Wait for more than 480us
        DQ_DIR=1              			' Release the data pin (set to input for high)
        Pauseus 100             		' Wait for more than 60us
        If DQ=1 then				' Is there a DS1820 detected
	 DS_Valid=0				' If not, then clear DS_VALID flag
       	 Return					' And return with DS_Valid holding 0
        Endif					' Else
        Pauseus 400             		' Wait for end of presence pulse
	DS_Valid=1				' Set DS_VALID flag
        Return					' And return with DS_Valid holding 1

' ** Read the temperature from the DS1820 **
' The temperature in degrees centigrade is returned in the variable DEG
' Flag, NEGATIVE will return 1 if the temperature is less than 0 degrees centigrade
' And 0 if normal
DS_Read:
        For Bit_Cnt=1 to 16         		' Create a loop of 16-bits (WORD)
        Temp=Temp >> 1    			' Shift down bits
        Temp.15=1             			' Preset read bit to 1
        Low DQ                  		' Start the time slot
@       nop                     		' Delay 1us at 4MHz
        DQ_DIR=1              			' Release data pin (set to input for high)
        If DQ=0 Then
         Temp.15 = 0     			' Set bit to 0
        Endif
        Pauseus 60              		' Wait out rest of time slot
        Next					' Close the loop

' ** Check if temperature is positive or negative **
	If Temp.8=1 then			' If bit-8 of temperature is set then its negative		
	 Negative=1				' Indicate temperature is NEGATIVE
	 Temp.lowbyte=Temp.lowbyte ^ 255	' Reverse the bits of the lowbyte of TEMP
	Else					' Else
	 Negative=0				' Indicate temperature is POSITIVE
	Endif
	Deg=((Temp.lowbyte)>>1)*10 		' Shift the lowbyte of the result right 1 place
	Deg=Deg+(Temp.0*5)			' Strip off bit 0 (0.5 degree) and add it to DEG
        Return

' Write a command byte to the DS1820
DS_Write:
        For Bit_Cnt=1 to 8          		' Create a loop of 8-bits (BYTE)
        If Cmd.0=0 then
         Low DQ					' Write a 0 bit
         Pauseus 60              		' Send a low for more than 60us for 0
         DQ_DIR=1              			' Release data pin (set to input for high)
        Else
         Low DQ                  		' Send a low for less than 15us for 1
@        nop                     		' Delay 1us at 4MHz
         DQ_DIR=1              			' Release the data pin (set to input for high)
         Pauseus 60              		' Use up rest of time slot
        Endif
        Cmd=Cmd >> 1  				' Shift to next bit
        Next					' CLose the loop
        Return
