' Program BIGNUMS.Bas (Display four 1" digits on 4x20 display)
' Connect the input of a 4x20 Serial LCD display to PortA.0 
' and run this program. The program will define a set 
' of symbols that allow it to display 4-line-tall numerals on the LCD. 
' To incorporate this capability into your own programs, just 
' substitute your code for the demo loop. When you want to display 
' a value (0-9999) in big numerals, write it to dispVal, then gosub Biglcd.

' The original BIGNUMS code was written by Scott Edwards.
' However it would not compiler using the PICBASIC PRO
' Therefore, it has been modified.

' ** Declare Variables **

	EEptr		var	word	' Pointer into EEPROM. 
	pat		var	EEptr	' Alias for EEptr. 
	dispVal		var	word	' Value to be displayed as big digits. 
	temp		var	byte	' Temporary byte variable. 
	decade		var	word
	nbl		var	Byte	' Index into number-pattern tables. 
	digit		var	Byte	' Current digit to display
	line		var	Byte	' LCD line
	Nib0		Var	Byte
	Nib1		Var	Byte
	Nib2		Var	Byte
	Nib3		Var	Byte

' ** Define LCD Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD
	Shift_L		Con	24			' Shift display left
	Shift_R		Con	28			' Shift display right

' ** Define bit patterns for the LCD new characters **
' ** These reside inside the onboard Eeprom **

	bitPat0	DATA	0,0,0,1,3,7,15,31	' Left-right up-ramp shape. 
	bitPat1	DATA	0,0,0,16,24,28,30,31	' Right-left "       "    
	bitPat2 DATA	31,15,7,3,1,0,0,0 	' Left-right down ramp. 
	bitPat3	DATA	31,30,28,24,16,0,0,0	' Right-left "    "
	bitPat4	DATA	0,0,0,0,31,31,31,31	' Lower block. 
	bitPat5 DATA	31,31,31,31,0,0,0,0	' Upper block. 
	bitPat6	DATA	31,31,31,31,31,31,31,31	' Full block. 
	bitPat7	DATA	0,0,0,0,0,0,0,0		' Full blank


	Debug I,Cgram	' Enter CG RAM. 
	for EEptr = 0 to 63			' 64 new patterns
  	Read EEptr,temp				' read them from the onboard Eeprom 
  	Debug temp				' Output the bit patterns to the Serial LCD
	next

	Goto Over_BigNums

'                 Subroutine Displaying Large Numbers
Biglcd:
	For line = 0 to 3				' Four lines to display.
	decade = 1000					
  	Lookup line,[Line1,Line2,Line3,Line4],temp	' Get start address of line.
  	Debug I,temp					' Position the cursor on line.
  	For digit = 3 to 0 step -1			' For each digit:
    	nbl = dispVal dig digit 
    	Gosub getPattern				' Get symbols for line/digit.
    	If dispVal = 0 and digit = 0 then skip0		
    	If dispVal < decade then blankIt   		' Blank out the digit 
Skip0:
	Nib0=Pat .lowbyte & %00001111			' Split Pat into first 4 bits
	Nib1=Pat .lowbyte & %11110000			' Split Pat into Second 4 bits
	Nib1=Nib1 >>4
	Nib2=Pat .highbyte & %00001111			' Split Pat into Third 4 bits
	Nib3=Pat .highbyte & %11110000			' Split Pat into Fourth 4 bits
	Nib3=Nib3 >>4
    	Debug Nib3,Nib2,Nib1,Nib0			' Print the big numbers
    	goto cont
Blankit:
   	Debug "    "

Cont:   If digit = 0 then Skip1
    	Debug " "

Skip1:  Decade = Decade/10
  	Next
	Next
	Return


'         ***** Subroutines Defining Big-Character Patterns *****
' Each digit is represented by four lines of four symbols. The branch
' instruction below picks the appropriate lookup table for the current
' line. The lookup table then returns the corresponding four symbols
' packed into a single word (16-bit) variable.

getPattern:
	branch line,[first,second,third,fourth] 

'             0     1     2     3     4     5     6     7     8     9
'            ---   ---   ---   ---   ---   ---   ---   ---   ---   ---
first:
	lookup2 nbl,[$0551,$7067,$0551,$0551,$6776,$6555,$0557,$2556,$0551,$0551],pat
	return

second:
	lookup2 nbl,[$6776,$7767,$7743,$7743,$6776,$2441,$6041,$7703,$2443,$6776],pat
	return

third:
	lookup2 nbl,[$6776,$7767,$0577,$7751,$2556,$7776,$6776,$7767,$0551,$2536],pat
	return

fourth:
	lookup2 nbl,[$2443,$7464,$6444,$2443,$7776,$2443,$2443,$7767,$2443,$7443],pat
	return
Over_Bignums:
