' Program SON_PROX.BAS 
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Ultrasonic proximity detector
' 
' Pic connections
'
' PortA.0-1 Transmitter Transducer
' PortA.2 Receiver Input
' PortA.3 Green LED 
' PortB.0 Serial Out Data

	Include "Modedefs.Bas"

' ** Set Xtal Value in mHz

	Define	OSC		4		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PORTA
	Define	DEBUG_BIT	2		' *** Debug pin Bit2 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	100		' Delay 'in uS' between characters sent

' ** Define LCD Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD

' ** Declare Pin Assignments **
	TX1		Var	PortA.0			' Transmitter transducer pin-1
	TX2		Var	PortA.1			' Transmitter transducer pin-2
	RX		Var	PortA.3			' Receiver transducer pin
	Green_LED	Var	PortB.0			' Assign the green led to this pin

' ** Declare Variables **
	E_Time		Var	Byte			' Distance gauge
	Hits		Var	Byte			' Amount of hits received from target
	Samples		Var	Byte			' Amount of pings transmitted
	Ping_Dur	Var	Byte	BANK0		' The length of the pulse transmitted

' *** THE MAIN PROGRAM STARTS HERE ***
	
	Pause 200
	Debug I,Clr:Pause 30		' Clear the LCD

	TrisA.0=0			' Make PortA.0-1 outputs
	TrisA.1=0			' For the transmitting transducer
	TrisA.3=1			' Make PortA.3 an input, for the receiving transducer
Main:	Hits=0				' Clear the HITS counter
	For Samples=1 to 10		' We are Sampling 10 times
	Gosub Ping			' Send out a sonar ping
	 For E_Time=0 to 254		' Wait for 255 loops for a signal reflection
	  If RX=0 then 			' If a reflection has been heard
	   Hits=Hits+1			' Then increment the HITS counter
	   Goto Exit_Loop		' And exit the for-next loop
	  Endif				' Else
	 Next 				' Close the loop		
	E_Time=0			' No reflection were heard within 255 loops	
Exit_Loop:
	Pause 5				' Wait for the Transducers to settle
	Next				' Close the SAMPLES loop

	If Hits=10 then			' Check if 10 out of 10 reflections have bee heard
	  High Green_Led		' If yes, then light the green LED
	 Else				' Else
	  Low Green_Led			' Turn off the green LED
	  E_Time=0			' Clear the distance gauge if 10 hits were not counted
	Endif
	Debug I,Line2,#E_Time,"  "	' E_TIME is a distance measurement gauge
	Pause 200
	Goto Main

' Echo Ping subroutine
Ping:
Asm
 	Movlw	16			; Send Out A 40kHz pulse for Approx 600us
	Movwf	_Ping_Dur
PingIt	Clrwdt				; Walk the dog and keep the PIC happy
	Nop				; Delay
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Bcf PortA,0			; Turn off one pin of the transducer
	Bsf PortA,1			; And turn on the other pin
	Nop				; Delay
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Bsf PortA,0			; Turn on one pin of the transducer
	Bcf PortA,1			; And turn off the other pin
	Decfsz	_Ping_Dur		; Do it for the duration of PING_DUR
	Goto	PingIt
Endasm
	Pauseus 100			' Wait for the RX transducer to stop ringing
	Return




