' Program 8mHzPROX.BAS 
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Ultrasonic proximity detector
' USing an 8mHz crystal
' 
' PortA.0-1 Transmitter Transducer
' PortA.3 Receiver Input
' PortA.2 Serial Out Data
' PortB.0 Green LED 

	Include "Modedefs.Bas"

' ** Set Xtal Value in mHz

	Define	OSC		8		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PORTA
	Define	DEBUG_BIT	2		' *** Debug pin Bit2 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	100		' Delay 'in uS' between characters sent
' ** Define LCD Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD
	Shift_L		Con	24			' Shift display left
	Shift_R		Con	28			' Shift display right

' ** Declare Pin Assignments **
	TX1		Var	PortA.0
	TX2		Var	PortA.1
	RX		Var	PortA.3
	Green_LED	Var	PortB.0

' ** Declare Variables **
	E_Time		Var	Word		' 
	Hits		Var	Byte
	Inches		Var	Byte
	Ping_Dur	Var	Byte

' *** THE MAIN PROGRAM STARTS HERE ***
	
	Pause 200
	Debug I,Clr:Pause 30		' Clear the LCD

	TrisA.0=0
	TrisA.1=0
	TrisA.3=1
Main:	
	Gosub Ping			' Send out a sonar ping
	RCtime RX,1,E_Time
	Inches=E_Time/13
	Debug I,Line1,#Inches,"   "
	Pause 100
	Goto Main

' Echo Ping subroutine using an 8mHz crystal
Ping:
Asm
 	Movlw	32			; Send Out A 40kHz pulse for Approx 800us
	Movwf	_Ping_Dur
PingIt	Clrwdt				; Walk the dog and keep the PIC happy
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Bcf PortA,0
	Bsf PortA,1
	Clrwdt
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Bsf PortA,0
	Bcf PortA,1
	Decfsz	_Ping_Dur
	Goto	PingIt
Endasm
'	Pauseus 100		' Wait for the RX transducer to stop ringing
	Return




