' Program LR_PROX.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Directional infra-Red proximity detector
' An infrared beam of light, modulated at 38kHz is transmitted for approx 400us 
' From the left infrared led first and a reflection is searched for
' Then the same is done for the right led
' This is done 10 times for each side in an attempt to eliminate false readings,
' caused by ambient light sources. 
' The left display led will light if a reflection is detected from the left
' The centre display led will light if a reflection is detected from both left and right
' The right display led will light if a reflection is detected from the right

' Connections
' PortB.0  Left Display LED
' PortB.1  Centre Display LED
' PortB.2  Right Display LED
' PortB.3  Infrared receiver module
' PortB.4  Left Infrared LED
' PortB.5  Right Infrared LED

	Include "Modedefs.Bas"

' ** Set Xtal Value in mHz **

	Define	OSC		4		' Set Xtal Frequency

' ** Declare Variables **

	Ping_Dur	Var	Byte		' Timing loop for Duration of 38kHz Pulse
	Hits_Left	Var	Byte		' No# of reflections received to the left
	Hits_Right	Var	Byte		' No# of reflections received to the right
	Sample		Var	Byte		' Amount of samples taken
	Left_Led	Var	PortB.0		' Left display LED
	Centre_Led	Var	PortB.1		' Centre display LED
	Right_Led	Var	PortB.2		' Right display LED
	IR_Sensor	Var	PortB.3		' Place the IR Receiver on this Pin
	Left_IR		Var	PortB.4		' Place the Left IR Led on this Pin
	Right_IR	Var	PortB.5		' Place the Right IR Led on this Pin

' ** THE MAIN PROGRAM STARTS HERE **

	TrisB.3=1				' Set PortB.3 as an Input (IR_Sensor)
	
Main:	Hits_Left=0				' Clear the variable "HITS_LEFT"
	Hits_Right=0				' Clear the variable "HITS_RIGHT"
	For Sample=1 to 10			' We are taking 10 samples
	Gosub Ping_Left				' Send a pulse of light from the Left IR Led
	If IR_Sensor=0 then Hits_Left=Hits_Left+1 ' Check for a reflection from the Left Led	
	Gosub Ping_Right			' Send a pulse of light from the Right IR Led
	If IR_Sensor=0 then Hits_Right=Hits_Right+1 ' Check for a reflection from the Right Led	
	Next 					' Close the Loop
	Pause 20				' Wait for everything to settle

' ** NOW TO DISPLAY THE RESULTS **

' If both directions sense 7 or more reflections out of 10 
' There is a good chance that something is in front
' So the Centre LED is illuminated and the other two are extinguished.
	If Hits_Left>=7 and Hits_Right>=7 then
	Low Left_Led				' Turn off the Left LED
	Low Right_Led				' Turn off the Right LED 
	High Centre_Led				' And turn On the Centre LED
	Goto Main				' Go back to start of program
	Endif

' If reflections from the left, number 10 out of 10,
' There is an object to the Left, so the Left LED is illuminated and the other two extinguished.
	If Hits_Left=10 then
	Low Right_Led				' Turn off the Right LED 
	Low Centre_Led				' Turn Off the Centre LED				' Turn off the Right LED 
	High Left_Led				' And turn on the Left LED
	Goto Main				' Go back to start of program
	Endif

' If reflections from the right, number 10 out of 10,
' There is an object to the Right, so the Right LED is illuminated and the other two extinguished.
	If Hits_Right=10 then
	Low Left_Led				' Turn off the Left LED
	Low Centre_Led				' Turn Off the Centre LED
	High Right_Led				' And turn on the Right LED 
	Goto Main				' Go back to start of program
	Endif

' If the program reaches here then,
' there is nothing in front or to the sides so extinguish the LED's
	Low Left_Led				' Turn off
	Low Right_Led				' All three LED's
	Low Centre_Led
	Goto Main				

' ** SUBROUTINES **

'********************************************************
'*							*
'* Send a pulse, modulated at appox 38kHz		*
'* with a duration of 400us out of the LEFT IR_LED	*
'* Using a 4mHz crystal 				*
'*							*
'********************************************************
Ping_Left:
	For Ping_Dur= 1 to 14		' Create a loop for the pulse duration required
	High Left_IR			' Turn on the IR_LED. (This takes 4 clock cycles) (uS)
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop				' Do nothing for 8 clock cycles (uS)
	Low Left_IR			' Turn off the IR_LED. (This takes 4 clock cycles)
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop				' Do nothing for a further 7 clock cycles (uS)
	Next 				' Close the pulse duration loop
	Return				' Exit the subroutine

'********************************************************
'*							*
'* Send a pulse, modulated at appox 38kHz		*
'* with a duration of 400us out of the RIGHT IR_LED	*
'* Using a 4mHz crystal 				*
'*							*
'********************************************************
Ping_Right:
	For Ping_Dur= 1 to 14		' Create a loop for the pulse duration required
	High Right_IR			' Turn on the IR_LED. (This takes 4 clock cycles) (uS)
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop				' Do nothing for 8 clock cycles (uS)
	Low Right_IR			' Turn off the IR_LED. (This takes 4 clock cycles)
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop				' Do nothing for a further 7 clock cycles (uS)
	Next 				' Close the pulse duration loop
	Return				' Exit the subroutine