' Program IR_PROX.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Infra-Red Proximity detector with distance gauge
' In infra-red beam modulated at 38kHz is transmitted, then the reflection is detected
' This is done 10 times in a bid to eliminate false readings  
' The Leds will light up as an object is brought into its field of view
' Connections
' PortB.0  Green LED
' PortB.1  Yellow LED
' PortB.2  Red LED
' PortB.3  Infra-red receiver module
' PortB.4  Infra-red LED

	Include "Modedefs.Bas"

' ** Set Xtal Value in mHz

	Define	OSC		4		' Set Xtal Frequency

' ** Declare Variables **
	Ping_Dur	Var	Byte		' Timing loop for Duration of 38kHz Pulse
	Hits		Var	Byte		' Amount of reflections received
	Sample		Var	Byte		' Amount of samples taken
	Green_Led	Var	PortB.0		' Assign the Green Led to this Pin
	Yellow_Led	Var	PortB.1		' Assign the Yellow Led to this Pin
	Red_Led		Var	PortB.2		' Assign the Red Led to this Pin
	IR_Sensor	Var	PortB.3		' Assign the IR Receiver to this Pin
	IR_Led		Var	PortB.4		' Assign the IR Led to this Pin

' ** THE MAIN PROGRAM STARTS HERE **

	TrisB.1=1				' Configure PortB.1 as an Input (IR sensor)
Main:	Hits=0					' Clear the variable "HITS"
	For Sample=1 to 30			' We are taking 10 samples
	Gosub Ping				' Send a pulse of IR light modulated at 38kHz
	If IR_Sensor=0 then Hits=Hits+1		' Increment HITS if a reflection is detected
	Next 					' Close the loop
	Pause 15				' Wait for everything to settle

	If Hits >20 then		' Check the value held in "HITS"
	High Red_Led				' Light the Red LED if HITS is between 20 and 30
'	Goto Main
	Else					' Otherwise
	Low Red_Led				' Turn the Red LED Off
	Endif

	If Hits >10 and Hits <=20 then		' Check the value held in "HITS"
	High Yellow_Led				' Light the Yellow LED if HITS is between 10 and 20
'	Goto Main
	Else					' Otherwise
	Low Yellow_Led				' Turn the Yellow LED Off
	Endif

	If Hits >0 and Hits <=10 then		' Check the value held in "HITS"
	High Green_Led				' Light the Green LED if HITS is between 5 and 10
'	Goto Main
	Else					' Otherwise
	Low Green_Led				' Turn the Green LED Off
	Endif

	Goto Main				' Do it Indefinately


'********************************************************
'*							*
'* Send a pulse, modulated at appox 38kHz		*
'* with a duration of 400us				*
'* Using a 4mHz crystal 				*
'*							*
'********************************************************
Ping:
	For Ping_Dur= 1 to 14		' Create a loop for the pulse duration required
	High IR_LED			' Turn on the IR_LED. (This takes 4 clock cycles) (uS)
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop				' Do nothing for 8 clock cycles (uS)
	Low IR_LED			' Turn off the IR_LED. (This takes 4 clock cycles)
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop				' Do nothing for a further 8 clock cycles (uS)
	Next 				' Close the pulse duration loop
	Return				' Exit the subroutine
