' Program L293D.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Controlling an L293D quad driver IC
' Configured as an H-Bridge

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** Declare the pin assignments for the L293D **
	Line_A		Var	PortB.0		' Connect to IN1 on the L293D
	Line_B		Var	PortB.2		' Connect to IN2 on the L293D

' ** Declare a Constant **
	Second		Con	1000		' Value to place into pause for a 1 second delay

' ** THE MAIN PROGRAM STARTS HERE **
	Debug I,Clr:Pause 30			' Clear the LCD
	Debug I,Line1,"    Turning"

Main:	Gosub All_Stop				' Stop the motor
	Debug I,Line2,"    Stopped    "		' Display the motion of the motor
	Pause Second				' Wait for 1 second
	Gosub Turn_CW				' Turn the motor Clockwise
	Debug I,Line2,"   Clockwise   "		' Display the motion of the motor
	Pause Second				' Wait for 1 second
	Gosub All_Stop				' Stop the motor
	Debug I,Line2,"    Stopped     "	' Display the motion of the motor
	Pause Second				' Wait for 1 second
	Gosub Turn_CCW				' Turn the motor Anti-Clockwise
	Debug I,Line2," Anti-Clockwise"		' Display the motion of the motor
	Pause Second				' Wait for 1 second
	Goto Main				' Do it forever

' Turn the motor Clockwise
Turn_CW:
	High Line_A
	Low Line_B
	Return	
' Turn the motor Anti-Clockwise
Turn_CCW:
	Low Line_A
	High Line_B
	Return
' Stop the motor turning
All_Stop:
	Low Line_A
	Low Line_B
	Return

