' Program BAS_TRX.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Control Sony equipment via IR 
' This include file is a sony infrared transmitter.
' To send out the 12-bit packet of data:-
' Load IR_BYTE with the button value to be sent (0..127)
' Load IR_CMD  with the ID-Code for this transmitter (0..31)
' Then make a call to SONY_OUT (i.e Gosub SONY_OUT)
' ***********************************************************************

	Goto Over_Bas_TRX

' ** Declare the Variables **

	IR_LED		Var	PortB.7		' The IR LED is attached to this pin
	IR_Word		Var	Word		' Holds the 12-bit packet word to Transmit
	IR_Byte		Var	Byte		' The button pressed, code (0..127)
	IR_Cmd		Var	Byte		' Device code (0..31)
	B_Loop		Var	Byte		' Temp varaible used in BURST subroutine
	B_Time		Var	Byte		' This holds the duration of the pulse
	S_Loop		Var	Byte		' Temp variable us to build up the 12-bit packet


' ** Declare the Constants **
	B_600us		Con	16		' Value for a 600us pulse, placed into B_TIME
	B_1200us	Con	33		' Value for a 1200us pulse, placed into B_TIME
	B_2400us	Con	67		' Value for a 2400us pulse, placed into B_TIME

'************************************************************************
'*									*
'* Transmit a 12-bit packet over an IR-Signal, using the Sony protocol. *
'* The Device code (0..31) is loaded into IR_Cmd			*
'* The Button data (0..127) is loaded into IR_Byte			*
'*									*
'************************************************************************
Sony_Out:
	IR_Word=0			' Clear IR_Word
	IR_Word .highbyte = IR_Cmd	' Place the Device code in the top half of IR_Word	
	IR_Word=IR_Word >> 1		' Move it down into the 7th bit position
	IR_Byte.7=0			' Make sure we can only send upto 127
	IR_Word=IR_Word | IR_Byte	' OR the IR_Byte value into IR_WORD
	B_Time=B_2400us			' Set the duration of the pulse to 2400us
	Gosub Burst			' Sent the header pulse
	For S_Loop=0 to 11		' 12-bits to sent, least significant bit first 
	If IR_Word.0[S_Loop]=1 then	' Check the individual bits of IR_WORD
	B_Time=B_1200us			' If the bit is 1 then set the pulse duration to 1200us
	Else				' Else
	B_Time=B_600us			' It must be a zero, therefor, set the pulse duration to 600us
	Endif
	Gosub Burst			' Send the pulse
	Next S_Loop			' Close the loop
	Pause 34			' Make the total time up to approx 45ms
	Return

'********************************************************
'*							*
'* Send a pulse, modulated at 38kHz			*
'* the duration of the pulse is placed into B_TIME	*
'* Using a 4mHz crystal the pulse length values are: -	*
'* 600us......16					*
'* 1200us.....33					*
'* 2400us.....67					*
'*							*
'********************************************************
Burst:
	For B_Loop= 1 to B_Time		' Create a loop for the pulse duration required
	Gosub IR_Mod			' Modulate the IR led, the gosub command takes 2 cycles
	Next B_Loop			' Close the pulse duration loop
	Pauseus 600			' Pause for 600us after every pulse sent
	Return				' Exit the subroutine
	
' ** Modulate the IR_LED at 38kHz, using a 4mHz crystal **
IR_Mod:
	High IR_LED			' Turn on the IR_LED. (This takes 4 clock cycles)
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop				' Do nothing for 8 clock cycles
	Low IR_LED			' Turn off the IR_LED. (This takes 4 clock cycles)
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop
@	Nop				' Do nothing for a further 7 clock cycles
	Return				' Return from the subroutine, this takes 1 cycle
Over_Bas_TRX:	