' Program SNY_SEND.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Control Sony equipment via IR 
' The 12-button keypad is used to transmit the channel numbers,
' as well as the Volume up and down.
' Buttons 0..9 change the channel,
' Button * is for volume down,
' Button # is for volume up.
'
' To send out the 12-bit packet of data:-
' Load IR_BYTE with the button value to be sent (0..127)
' Load IR_CMD  with the ID-Code for this transmitter (0..31)
' Then make a call to SONY_OUT (i.e Gosub SONY_OUT)
' ***********************************************************************

	Include "Modedefs.Bas"
	Include "SONY_TRX.Inc"			' Load in the IR transmitter subroutine
	Include "Inkeys12.Inc"			' Load in the 12-button keypad subroutine

' ** Setup the Crystal Frequency, in mHz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Declare the Variables **
	Green_Led	Var	PortB.6		' The green LED is attached to this pin

' ** The main program starts here **

	IR_Cmd=15				' Set the Device code to 15
Again:	Low Green_Led				' Turn off the Green LED
	Gosub Inkeys				' Scan the keypad
	If Key=128 then goto Again		' If no key pressed, then look again
	Lookup Key,[9,0,1,2,3,4,5,6,7,8,19,18],Key ' Arrange the keys to match a sony remote
	IR_Byte=Key				' Place the Key pressed, into IR_BYTE
	High Green_Led				' Turn on the Green LED
	Gosub Sony_Out				' Transmit the IR signal
	Goto Again				' Do it forever.

