' Program SONY_TX.Inc
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Include file for a Sony protocol IR transmitter 

' This subroutine Transmits the 12-bit packet over an IR-Signal, using the Sony protocol.
' The Device code (0..31) is loaded into IR_Cmd
' The Button data (0..127) is loaded into IR_Byte

Goto Over_Sony_TX
' ** Declare the Variables used within the subroutine**

	IR_Cmd		Var	Byte	BANK0	SYSTEM	' Device code (0..31)
	IR_Byte		Var	Byte	BANK0	SYSTEM	' The button pressed, code (0..127)
	Packet		Var	Word	BANK0	' Holds the 12-bit packet word to Transmit
	Bit_Cnt		Var	Byte	BANK0	' Counts the 12-bits sent out

Sony_Out:
Asm

#Define	IR_LED	IROUT_PORT,IROUT_BIT	;' Get the Port and Pin from the two new Defines

;' Set Defaults for IROUT_PORT and IROUT_BIT to "PORTA.0"
	Ifndef IROUT_PORT
IROUT_PORT = PortA
	endif 
	Ifndef IROUT_BIT
IROUT_BIT = 0
	endif

	Bcf IROUT_PORT,IROUT_BIT	;' Clear the appropriate pin
	Bsf Status,5			;' Set to Bank1
	Bcf IROUT_PORT,IROUT_BIT	;' Make the appropriate pin an Output
	Bcf Status,5			;' Back to Page 0	

	Bcf	IR_LED			;' Turn off the IR led
	Clrwdt				;' Walk the dog
	Movf	IR_Cmd,W		;' Get the Device byte to Transmit
	Movwf	_Packet+1		;' Store it		
	Movf	IR_Byte	,W		;' Get the Command Data byte to Transmit
	Addwf	IR_Byte	,W		;' Arrange the 12 bits	
	Movwf	_Packet			;' in the correct order
	Rrf	_Packet+1
	Rrf	_Packet

	Movlw	12			;' 12-Bits in a packet, to sent
	Movwf	_Bit_Cnt		;' Store it
	Movlw	92			;' Set up for a 2500us Pulse
	Call	Burst			;' Transmit the pulse
Sloop1	Movlw	22			;' Set up for initally a 600us Pulse			
	Rrf	_Packet+1		;' Move the 12-bit packet right
	Rrf	_Packet			;' And test the state of the individual bits
	Btfsc	Status,C		;' If 0, then Transmit the 600us pulse
	Movlw	44			;' Else, Set up for a 1200us Pulse
	Call	Burst			;' Transmit the pulse
	Decfsz	_Bit_Cnt		;' Have we done 12-bits yet?
	Goto	Sloop1			;' If no, then loop until we have

	Movlw	35			;' Now delay, to make a total time of at least 45 mS
	Movwf	_Bit_Cnt		;' This will give the receiver time to catch the next transmission.
Sloop3	Call	Del_600			;' Delay for 600 * 35 us
	Clrwdt				;' Walk the dog
	Decfsz	_Bit_Cnt
	Goto	Sloop3
	Return				;' Return from the "Sony_In" Subroutine

;' *** Subroutines ***

Delay12	Clrwdt				;' Delay for 9us, turning on the led, and the call pads out to 12us
	Nop
	Nop
	Nop
	Nop
Delay7	Nop				;' Delay for 9us, turning off the led, and the call pads out to 7us
	Nop
	Nop
	Return

;' Transmit a 38 KHz IR burst (the cycle count is held in W). 
;' Followed by a 600uS Delay
Burst
Burst1	Bsf	IR_LED			;' Turn On the IR Led
	Call	Delay12			;' Delay for 12us
	Bcf	IR_LED			;' Turn Off the IR_Led
	Call	Delay7			;' Delay for 7us
	Nop				;' These, NOP's fine tune the IR-Modulation
	Nop				;' Without them, modulation is 40khz
	Addlw	255			;' Add 255 to the delay time held in W
	Btfss	Status,Z		;' If W=0 then Delay for 600us
	Goto	Burst1			;' 

Del_600	Movlw	150			;' Delay for 600us
Burst2	Addlw	255				 
	Btfss	Status,Z			 
	Goto	Burst2				 
	Return

EndAsm
Over_Sony_TX: