' Program SONY_TRX.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
'Control Sony equipment via IR 
'The 12 button keypad is used to transmit the channel numbers as well as the Volume up and down.
' Buttons 0..9 change the channel,
' Button * is for volume down,
' Button # is for volume up.

' ** Two New Defines Have been Added **

' IROUT_PORT  Selects the port for Sony_Out
' IROUT_BIT   Selects the Pin for Sony_Out

' ** If these Defines are not used the Default is PORTA Bit 0 **
'
' To send out the 12-bit packet of data:-
' Load IR_BYTE with the Byte to be sent (0..127)
' Load IR_CMD  with the ID-Code for this transmitter (0..31)
' Then make a call to Sony_OUT (i.e Gosub Sony_OUT)

' All the above Variables are Pre-Declared within the Include file (SONY_TX.Inc)

	Include "Modedefs.Bas"
	Include "Sony_TX.Inc"			' Load the Sony IR Xmitter subroutine
	Include "INKEYS12.Inc"			' Load in the 12 button Keypad decoder

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the new SONY_OUT Defines **

	Define	IROUT_PORT	PortB		' Set the Port for the IR LED to attach
	Define	IROUT_BIT	7		' Set the Pin for the IR LED to attach

' ** Declare the Pin assignments **

	Green_LED	Var	PortA.0		' The green LED is attached to this pin

' ** The Main program starts here ** 

	IR_Cmd=15				' Set the Device code to 15
Again:	Low Green_Led				' Turn off the Green LED
	Gosub Inkeys				' Scan the keypad
	If Key=128 then goto Again		' If no key pressed, then look again
	Lookup Key,[9,0,1,2,3,4,5,6,7,8,19,18],Key ' Arrange the keys to match a sony remote
	IR_Byte=Key				' Place the Key pressed, into IR_BYTE
	High Green_Led				' Turn on the Green LED
	Gosub Sony_Out				' Transmit the IR signal
	Goto Again				' Do it forever.
