'Program SONY_RX.Inc
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
'This Include file reads signals from a Sony IR remote control,
'and returns the button code in the variable "IR_DATA".
'the device code in the variable "IR_DEV", 
'and the variable, "IR_VALID" is set to one if a valid packet is received else it is cleared
'The infrared receiver module used is the Siemens SFH506-38.

'The infrared receiver module for this experiment should, 
'be a type that is set for a 38 kHz carrier frequency. 
'If another type is used. some reduction in range may be noticed. 
'** The output pin of the IR module connects to PortA.4 **

'The remote control used, may be either a Sony manufactured unit,
'or one of the universal remotes that can be configured for Sony equipment. 
'This is important since we are dealing with a specific signal protocol.

'With Sonys SIRCS specification, a start pulse is initially sent to
'indicate the beginning of a frame of data. This pulse is approx 2.4 msec in length. 
'Following this, are 7-bits of data, which represent the instruction being sent. 
'Then an additional 5-bit command byte, which signifies the target device (TV, VCR, etc.). 
'Data bits are sent with the least significant bit first.



' ** Declare the Variables **

	IR_Sensor 	Var     PortA.4       	' The IR sensor is attached to this pin
	IR_Valid	Var	Bit		' Flag to indicate a valid header pulse has been received
	ST      	Var     Word    	' Header length, signal
	IR_Word		Var	St		' Double up the variable, to save ram
	ID		Var	Byte		' The sony bit length 600us = 0, 1200us = 1
	IR_Data		Var	Byte		' The data byte returned
	IR_Dev		Var	Byte		' The command byte returned
	Sony_LP		Var	Byte		' Temporary variable used for a loop

Goto Over_Sony_In
' The subroutine "SONY_IN", receives the signal from a Sony remote control,
' and returns with the 7-bit data byte in the variable "IR_DATA",
' and the 5-bit command byte in the variable "IR_Dev".
' Also the bit flag "IR_VALID" is set to one if a valid header has been detected
' and reset to zero if not
Sony_In:
	TrisA.4=1				' Make the Sensor pin an Input
	IR_Valid=1				' Initialize the valid data flag
	If IR_Sensor=0 then Goto No_Sig  	' We are already in the middle of a pulse so, exit
'        IR_Word = 0:IR_Data=0:IR_Dev=0        	' Clear the variables used within the subroutine
        Pulsin IR_Sensor,0,ST			' Measure the header length.
        If St < 200 then goto No_Sig   		' Verify a good start bit, should be approx 240-260, using a 4mhz Crystal    		
        If St > 270 then goto No_Sig       	' If not valid then return IR_VALID=0

' Receive the 12 data bits (LSB first), and convert them into a 12-bit word,
' A high (1) should be approx 120, actual timing is 1200 us
' A low (0) should be approx 60, actual timing is 600 us
' We split the difference and say that < 90 is a low, >= 90 is a high
' These values are for use with a 4mhz crystal
	For Sony_Lp=0 to 11			' Do 12-bits
	Pulsin IR_Sensor,0,ID			' Receive the IR bit pulse
	If ID>=90 then 
	IR_Word.0[Sony_Lp]=1			' If it's greater than 90 then we have received a 1
	Else 
	IR_Word.0[Sony_Lp]=0			' If it's less than 90 we have received a 0 
	Endif
	Next 					' Close the loop

' Split the 7-bit data byte, and the 5-bit device byte
	IR_Data=IR_Word & %01111111		' Mask the first 7 "DATA" bits
	IR_Dev=(IR_Word >>7)&%00011111		' Move down and mask the last 5 "DEVICE" bits
	Return					' Exit the subroutine
No_Sig:
	IR_Valid=0				' Indicate, No signal or invalid header, detected
	Return					 
Over_Sony_In:
