'Program SONY_RX.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
'This program reads signals from a Sony IR remote control, 
'and displays them on a Serial LCD, connected to PortA.0 at inverted 9600 Baud 8-N-1
'The infrared receiver module used is the Sharp GP1U58X.

'The infrared receiver module for this experiment should, 
'be a type that is set for a 38 kHz carrier frequency. 
'If another type is used. some reduction in range may be noticed. 
'The output pin of the IR module connects to PortB.0 

'The remote control used, may be either a Sony manufactured unit,
'or one of the universal remotes that can be configured for Sony equipment. 
'This is important since we are dealing with a specific signal protocol.

'With Sonys SIRCS specification, a start pulse is initially sent to
'indicate the beginning of a frame of data. This pulse is approx 2.5 msec in length. 
'Following this, are 7-bits of data, which represent the instruction being sent. 
'Then an additional 5-bit command byte, which signifies the target device (TV, VCR, etc.). 
'Data bits are sent with the least significant bit first.

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	1		' *** Debug pin Bit-1 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode to 1=Inverted
	Define	DEBUG_PACING	50		' Delay 'in Us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD

' ** Declare the Variables **
	
	Green_Led	Var	PortA.0		' The Led flashes when a valid IR signal is received
	IR_Sense 	Var     PortA.4       	' The IR sensor is attached to this pin
	ST      	Var     Word    	' Header length, signal
	IR_Word		Var	St		' Double up the variable, to save ram
	ID		Var	Byte		' The sony bit length 600us = 0, 1200us = 1
	IR_Data		Var	Byte		' The data byte returned
	IR_Dev		Var	Byte		' The command byte returned
	Sony_LP		Var	Byte		' Temporary variable used for a loop
	IR_Valid	Var	Bit		' Flag to indicate a valid signal has been received

	Debug I,Clr:Pause 30				' Clear the LCD

        Debug I,Line1,"Sony Data=   "
	Debug I,Line2,"Sony Command="

Main:	Low Green_Led					' Turn off the green LED
	Gosub Sony_In					' Receive the remote control signal
	If IR_Valid=1 then				' Do the following code, if a valid packet has been received
	High Green_Led					' Turn on the green LED
' Display the data Byte (7-bit code), and the command byte (5-bit code)
        Debug I,Line1+13,#IR_Data,"  ",I,Line2+13,#IR_Dev," "			
	Endif
        Goto Main					' Loop Forever.

' The subroutine "SONY_IN", receives the signal from a Sony remote control,
' and returns with the 7-bit data byte in the variable "IR_DATA",
' and the 5-bit command byte in the variable "IR_Dev".

Sony_In:
	TrisA.4=1				' Set the sensor pin to input
	IR_Valid=1				' Initialize the valid data flag
	If IR_Sense=0 then goto No_Sig  	' We are already in the middle of a pulse so, exit
        IR_Word = 0:IR_Data=0:IR_Dev=0        	' Clear the variables used within the subroutine
        Pulsin IR_Sense,0,ST			' Measure the header length.
        If St < 200 then goto No_Sig   		' Verify a good start bit, should be approx 240-260, using a 4mhz Crystal    		
        If St > 270 then goto No_Sig       	' If not valid then return with "IR_DATA"=255

' Receive the 12 data bits (LSB first), and convert them into a 12-bit word,
' A high (1) should be approx 120, actual timing is 1200 us
' A low (0) should be approx 60 , actual timing is 600 us
' We split the difference and say that < 100 is a low, >= 100 is a high
' These values are for use with a 4mhz crystal
	For Sony_Lp=0 to 11			' Do 12-bits
	Pulsin IR_Sense,0,ID			' Receive the IR bit pulse
	If ID>=100 then 
	IR_Word.0[Sony_Lp]=1			' If it's greater than 100 then we have received a 1
	Else 
	IR_Word.0[Sony_Lp]=0			' If it's less than 100 we have received a 0 
	Endif
	Next 					' Close the loop

' Split the 7-bit data byte, and the 5-bit command byte
	IR_Data=IR_Word & %01111111		' Mask the first 7 "DATA" bits
	IR_Dev=(IR_Word >>7)&%00011111		' Move down and mask the last 5 "COMMAND" bits
	Return					' Exit the subroutine

No_Sig:
	IR_Valid=0				' Indicate, No signal detected
	Return					' was detected