'Program SONY_RX.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
'This program reads signals from a Sony IR remote control, 
'and displays them on a Serial LCD, connected to PortA.1 at inverted 9600 Baud 8-N-1
'The infrared receiver module used is the Sharp SFH506.

'The infrared receiver module for this experiment should, 
'be a type that is set for a 38Khz carrier frequency. 
'If another type is used. some reduction in range may be noticed. 
'The output pin of the IR module connects to PortA.4 

'The remote control used, may be either a Sony manufactured unit,
'or one of the universal remotes that can be configured for Sony equipment. 
'This is important since we are dealing with a specific signal protocol.

'With Sonys SIRCS specification, a start pulse is initially sent to
'indicate the beginning of a frame of data. This pulse is approx 2.5 msec in length. 
'Following this, are 7-bits of data, which represent the instruction being sent. 
'Then an additional 5-bit command byte, which signifies the target device (TV, VCR, etc.). 
'Data bits are sent with the least significant bit first.

	Include "Modedefs.Bas"
	Include "Sony_RX.Inc"			' Load in the Sony IR receiver subroutine

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	1		' *** Debug pin Bit-1 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	100		' Delay 'in Us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD

' ** Declare the Variables **
	Green_Led	Var	PortA.0		' The green LED is attached to this pin

	Debug I,Clr:Pause 30				' Clear the LCD

        Debug I,Line1,"Sony Data=   "
	Debug I,Line2,"Sony Command="
	
Main:	Low Green_Led					' Turn off the green LED
	Gosub Sony_In					' Receive the remote control signal
	If IR_Valid=1 then				' Do the following code, if a valid packet has been received
	High Green_Led					' Turn on the green LED
' Display the data Byte (7-bit code), and the command byte (5-bit code)
        Debug I,Line1+13,#IR_Data,"  ",I,Line2+13,#IR_Dev," "			
	Endif
        Goto Main					' Loop Forever.

