'Program "ASM_RX.INC"
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This Include file reads signals from a Sony IR remote control,
' and returns the button code in the variable "IR_DATA".
' the device code in the variable "IR_DEV", 
' and the variable, "IR_VALID" is set to one if a valid packet is received else it is clear
' The infrared receiver module used is the Siemens SFH506-38.

' The infrared receiver module for this experiment should, 
' be a type that is set for a 38 kHz carrier frequency. 
' If another type is used. some reduction in range may be noticed. 

' The remote control used, may be either a Sony manufactured unit,
' or one of the universal remotes that can be configured for Sony equipment. 
' or the transmitter shown in the book.
' This is important since we are dealing with a specific signal protocol.

' With Sonys SIRCS specification, a start pulse is initially sent to
' indicate the beginning of a frame of data. This pulse is approx 2.4 msec in length. 
' Following this, are 7-bits of data, which represent the instruction being sent. 
' Then an additional 5-bit command byte, which signifies the target device (TV, VCR, etc.). 
' Data bits are sent with the least significant bit first.

Goto Over_Sony_RX
' ** Declare the Variables used within the subroutine **

	P_Val		Var	Byte	BANK0	' Value From Pulsin Routine
	IR_Valid	Var	Bit	BANK0	SYSTEM	' Flag to indicate a valid header pulse has been received
	IR_Temp		Var	Byte	BANK0	' Temporary Variable
	IR_Word		Var	Word	BANK0	' Double up the variable, to save ram
	IR_Data		Var	Byte	BANK0	SYSTEM	' The data byte returned
	IR_Dev		Var	Byte	BANK0	SYSTEM	' The command byte returned
	Sony_LP		Var	Byte	BANK0	' Temporary variable used for a loop

' The subroutine "SONY_IN", receives the signal from a Sony remote control,
' and returns with the 7-bit data byte in the variable "IR_DATA",
' and the 5-bit command byte in the variable "IR_Dev".
' Also the bit flag "IR_VALID" is set to one if a valid header has been detected
' and reset to zero if not
Sony_In:
Asm
#Define	IR_Sensor	IRIN_PORT,IRIN_BIT	;' Get the Port and Pin from the two new Defines

;' Set Defaults for IRIN_PORT and IRIN_BIT to   PORTA BIT 4
	Ifndef IRIN_PORT
IRIN_PORT = PortA
	endif 
	Ifndef IRIN_BIT
IRIN_BIT = 4
	endif

	Bcf IR_Sensor				;' Clear the appropriate pin
	Bsf Status,5				;' Set to Bank1
	Bsf IR_Sensor				;' Make appropriate pin an Input
	Bcf Status,5				;' Back to Page 0
EndAsm
	Goto IR_In:				' Jump over the Pulsin subroutine
Pulse_In:
Asm
;' Detect a pulse on appropriate pin and leave the result in "P_VAL"
Pulse_In
  	Clrwdt					;' Walk the dog
	Clrf    _IR_Temp			
        Clrf    _P_Val
O_1	Btfss   IR_Sensor			;' At logic one, wait for transition
        Goto    E_0
        Incfsz  _P_Val
        Goto    O_1
        Incfsz  _IR_Temp
        Goto    O_1
	Return
E_0  	Clrf    _P_Val				;' 1 To 0 transition occurred
E_0_1   Btfsc   IR_Sensor        		;' This is an 11 Us time loop
	Return					
	Clrwdt					;' Walk the dog					
	Nop
	Nop
	Nop
	Nop
	Nop
        Incfsz  _P_Val       		
        Goto    E_0_1        	
	Return
Endasm
' With this subroutine the Header length is approx 220..230
' The Mark (1) is approx 115..120
' The Space (0) is approx 55..61
IR_In:
Asm	Clrwdt					;' Walk the dog
	Bsf IR_Valid				;' Initialize the valid data flag
	Call Pulse_In				;' Measure the header length.
	Cjb _P_Val,#200,No_Sig			;' Jump if P_Val is below 200
	Cjae _P_Val,#250,No_Sig			;' Jump if P_Val is equal to or greater than 250

;' Build up the 12-bit packet, by pulling in all 16-bits and then seperate them later
	Movlw 16				;' We will pull in all 16-bits
	Movwf _Sony_Lp
S_again	Call Pulse_In				;' Get the bit duration
	Cjae _P_Val,#80,One			;' If the pulse is greater then 80 then it is a 1
	Bcf Status,C				;' Clear the carry, prior to the shift	(0-Bit)
	Goto Cont
One	Bsf Status,C				;' Set the carry, prior to the shift    (1-Bit)
Cont	
	Rrf _IR_Word+1,f			;' Rotate the bits into their correct place
	Rrf _IR_Word,f
	Decfsz _Sony_Lp				;' Have we reached 16-bits yet?
	Goto S_again				;' No! then loop again

;' Split the 7-bit data byte, and the 5-bit command byte
	Movf _IR_Word,w
	Andlw 01111111B				;' Mask the first 7 "DATA" bits
	Movwf IR_Data
	Rrf _IR_Word+1				;' Move "IR_WORD", right, 7 times
	Rrf _IR_Word
	Rrf _IR_Word+1
	Rrf _IR_Word
	Rrf _IR_Word+1
	Rrf _IR_Word
	Rrf _IR_Word+1
	Rrf _IR_Word
	Rrf _IR_Word+1
	Rrf _IR_Word
	Rrf _IR_Word+1
	Rrf _IR_Word
	Rrf _IR_Word+1
	Rrf _IR_Word
	Movf _IR_Word,w
	Andlw 00011111B				;' Mask the last 5 "DEVICE" bits
	Movwf IR_Dev
	Return					;' Exit the subroutine

No_Sig	Bcf IR_Valid				;' Indicate, No signal or invalid header, detected
	Return					;' Exit the subroutine					
Endasm
Over_Sony_RX:

