' Program IR_TRANS.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
'IR remote control, using the sony protocol 

' ** Two New Defines Have been Added **

' IROUT_PORT  Selects the port for IROut
' IROUT_BIT   Selects the Pin for IROut

' ** If these Defines are not used the Default is PORTA Bit 0 **
'
' To send out the 16-bit packet of data:-
' Load IR_BYTE with the Byte to be sent (0..255)
' Load IR_ID  with the ID-Code for this transmitter (0..255)
' Then make a call to IROUT (i.e Gosub IROUT)

' All the above Variables are Pre-Declared within the Include file (IR_TX.Inc)
' ***********************************************************************

	Include "Modedefs.Bas"
	Include "IR_RX_TX.Inc"			' Load the IR Tranceiver subroutine

' ** Setup the Crystal Frequency, in mHz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the new IROUT Defines **

	Define	IROUT_PORT	PortB		' Set the Port for the IR LED to attach
	Define	IROUT_BIT	7		' Set the Pin for the IR LED to attach

' ** Declare the Pin assignments **

	Counter		Var	Byte

' ** The Main program starts here ** 

	IR_ID=200				' Set the transmitter ID to 200
		
Again:	For Counter=0 to 255			' Set up a loop of 256
	IR_Byte=Counter				' Place the variable "COUNTER", into IR_BYTE
	Gosub IROut				' Transmit the IR signal
	Next
	Goto Again				' Do it forever.
