' Program IR_RX_TX.Inc
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Include file for a Sony protocol IR transmitter and receiver

' The infrared receiver detector used is the SFH506.

' The infrared receiver detector for this experiment should, 
' be a type that is set for a 38kHz carrier frequency. 
' If another type is used. some reduction in range may be noticed. 

' A start pulse is initially sent to indicate the beginning of a frame of data. 
' This pulse is approx 2.5 msec in length. 
' Following this, are 8-bits of data, which represent the instruction being sent. 
' Then an additional 8-bit command byte, which signifies the transmitter in use. 
' Data bits are sent with the least significant bit first.

' The subroutine "IROUT", transmits a 16-bit packet over an IR-Signal, using the Sony protocol.
' The Device code (0..255) is loaded into "IR_ID"
' The Actual data (0..255) is loaded into "IR_BYTE"

' The subroutine "IRIN", receives the 16-bit packet sent from the transmitter,
' and splits it into two, 8-bit byte's.
' The  transmitter ID is loaded into the variable "IR_ID", 
' The Actual data is loaded into the variable "IR_BYTE".
' The variable, "IR_VALID" is set to one if a valid packet is received,
' else it is reset to zero
' ***********************************************************************

Goto Over_IR_RX_TX				' Jump over all the assembly routines

'****************************************************************************
'* The variables used within the subroutines are internal ram loacations    *
'* used by the compiler itself, the only variables that need to be declared *
'* are the ones that are returned to your basic program			    *
'****************************************************************************

' ** Declare the Variables used within the Transmitter subroutine**

	IR_ID		Var	Byte	BANK0	SYSTEM	' Device code (0..255)
	IR_Byte		Var	Byte	BANK0	SYSTEM	' Command data code (0..255), for TX and RX
	IR_Packet	Var	Byte	BANK0		' Holds the 16-bit packet word to Transmit
	Bit_Cnt		Var	Byte	BANK0		' Counts the 16-bits sent out

' ** Declare the Variables used within the Receiver subroutine **

	P_Val		Var	Byte	BANK0		' Value From Pulsin Routine (Doubled up with another variable)
	IR_Valid	Var	Bit	BANK0	SYSTEM	' Flag to indicate a valid header pulse has been received
	IR_Temp		Var	Byte	BANK0		' Temporary Variable
	IR_Word		Var	IR_Packet		' Double up this variable, to save ram
	Sony_LP		Var	Byte	BANK0		' Temporary variable used for a loop


Asm
; ** Set the Defines for IROUT **
#Define	IR_LED	IROUT_PORT,IROUT_BIT	; Get the Port and Pin from the two new Defines

; Set Defaults for IROUT_PORT and IROUT_BIT to "PORTA.0"
	Ifndef IROUT_PORT
IROUT_PORT = PortA
	endif 
	Ifndef IROUT_BIT
IROUT_BIT = 0
	endif

; ** Set the Defines for IRIN **
#Define	IR_Sensor	IRIN_PORT,IRIN_BIT	; Get the Port and Pin from the two new Defines

; Set Defaults for IRIN_PORT and IRIN_BIT to   PORTA BIT 4
	Ifndef IRIN_PORT
IRIN_PORT = PortA
	endif 
	Ifndef IRIN_BIT
IRIN_BIT = 4
	endif
; *** Subroutines ***
; Detect a pulse on appropriate pin and leave the result in "P_VAL"
; The resolution of the pulse_in subroutine is 11us
; This is done to allow the header pulse to fit into a single byte
; With this subroutine the Header length is approx 220..230
; The Mark (1) is approx 115..120
; The Space (0) is approx 55..61
Pulse_In
  	Clrwdt					; Walk the dog
	Clrf    _IR_Temp			; Initially clear IR_TEMP			
        Clrf    _P_Val				; and P_VAL
Pls_01	Btfss   IR_Sensor			; At logic one, wait for transition
        Goto    Pls_02				
        Incfsz  _P_Val
        Goto    Pls_01
        Incfsz  _IR_Temp
        Goto    Pls_01
	Return
Pls_02  Clrf    _P_Val				; 1 To 0 transition occurred
Pls_03  Btfsc   IR_Sensor        		; This is an 11 us delay loop
	Return					
	Clrwdt					; Walk the dog					
	Nop
	Nop
	Nop
	Nop
	Nop
        Incfsz  _P_Val       		
        Goto    Pls_03        	
	Return

; Delay for 11us including the call to it.
Delay11	Clrwdt				; Delay for 9us, turning on the led, and the call pads out to 12us
	Nop				; Waste 1 cycle
	Nop				; Waste 1 cycle
	Nop				; Waste 1 cycle
	Nop				; Waste 1 cycle
Delay7	Nop				; Delay for 9us, turning off the led, and the call pads out to 7us
	Nop				; Waste 1 cycle
	Nop				; Waste 1 cycle
	Return				; Exit the subroutine

; Transmit a 38 kHz IR burst (the cycle count is held in W). 
; Followed by a 600uS Delay
Burst
Burst1	Bsf	IR_LED			; Turn On the IR Led (which takes 1 cycle)
	Call	Delay11			; Delay for 11us
	Bcf	IR_LED			; Turn Off the IR_Led (which takes 1 more cycle)
	Call	Delay7			; Delay for 7us
	Nop				; These, NOP's fine tune the IR-Modulation
	Nop				; Without them, modulation is 40kHz
	Addlw	255			; Add 255 to the delay time held in W
	Btfss	Status,Z		; If W=0 then Delay for 600us
	Goto	Burst1			; Else loop again.

Del_600	Movlw	150			; Delay for 600us
Burst2	Addlw	255				 
	Btfss	Status,Z			 
	Goto	Burst2				 
	Return
Endasm
'********************************************************************************
'*            Infrared transmitter subroutine starts here                  	*
'*										*
'*		Load the byte to send into IR_BYTE				*
'*		Load the transmitter ID into IR_ID				*
'*										*
'********************************************************************************
IROut:
Asm
	Bcf IROUT_PORT,IROUT_BIT	; Clear the appropriate pin
	Bsf Status,5			; Set to Page 1
	Bcf IROUT_PORT,IROUT_BIT	; Make the appropriate pin an Output
	Bcf Status,5			; Back to Page 0	

	Bcf	IR_LED			; Turn off the IR led
	Clrwdt				; Walk the dog
	Movf	IR_ID,W			; Get the Device byte to Transmit
	Movwf	_IR_Packet+1		; Store it		
	Movf	IR_Byte,W		; Get the Command Data byte to Transmit
	Movwf	_IR_Packet			


	Movlw	16			; 16-Bits in a packet, to be sent
	Movwf	_Bit_Cnt		; Store it
	Movlw	92			; Set up for a 2.5ms Pulse
	Call	Burst			; Transmit the pulse
Sloop1	Movlw	22			; Set up for initally a 600us Pulse			
	Rrf	_IR_Packet+1		; Move the 16-bit packet right
	Rrf	_IR_Packet		; And test the state of the individual bits
	Btfsc	Status,C		; If 0, then Transmit the 600us pulse
	Movlw	44			; Else, Set up for a 1200us Pulse
	Call	Burst			; Transmit the pulse
	Decfsz	_Bit_Cnt		; Have we done 16-bits yet?
	Goto	Sloop1			; If no, then loop until we have
	Movlw	5			; Now delay, to make a total time of at Most 25mS
	Movwf	_Bit_Cnt		; This will give the receiver time to catch the next transmission.
Sloop3	Call	Del_600			; Delay for (600 * 5)us
	Clrwdt				; Walk the dog
	Decfsz	_Bit_Cnt
	Goto	Sloop3
	Return				; Return from the "IROUT" Subroutine
Endasm

'********************************************************************************
'*            	Infrared receiver subroutine starts here                  	*
'*										*
'*		The byte received is returned in IR_BYTE			*
'*		The Transmitter ID is returned in IR_ID				*
'*		The IR_VALID bit is set if a valid IR packet was received	*
'*										*
'********************************************************************************
IRIn:
Asm
	Bcf IR_Sensor			; Clear the appropriate pin
	Bsf Status,5			; Set to Page 1
	Bsf IR_Sensor			; Make appropriate pin an Input
	Bcf Status,5			; Back to Page 0
IR_Start
	Clrwdt				; Walk the dog
	Bsf IR_Valid			; Initialize the valid data flag
	L?Call Pulse_In			; Measure the header length.
	Cjb _P_Val,#200,No_Sig		; Jump if P_Val is below 200
	Cjae _P_Val,#250,No_Sig		; Jump if P_Val is equal to or greater than 250

; Build up the 16-bit packet, by pulling in all 16-bits and then seperate them later
	Movlw 16			; We will pull in all 16-bits
	Movwf _Sony_Lp
S_again	L?Call Pulse_In			; Get the bit duration
	Cjae _P_Val,#80,One		; If the pulse is greater then 80 then it is a 1
	Bcf Status,C			; Clear the carry, prior to the shift	(0-Bit)
	btfsc Status,C			; Jump over the next instructiom
One	Bsf Status,C			; Set the carry, prior to the shift    (1-Bit)
Cont	Rrf _IR_Word+1,f		; Rotate the bits into their correct place
	Rrf _IR_Word,f
	Decfsz _Sony_Lp			; Have we reached 16-bits yet?
	L?Goto S_again			; No! then loop again

; Split the 8-bit data byte, and the 8-bit command byte
	Movf _IR_Word,w			; Point to the Data byte
	Movwf IR_Byte			; Place it in "IR_BYTE"
	Movf _IR_Word+1,w		; Point to the Device byte
	Movwf IR_ID			; Place it in "IR_ID"
	Return				; Exit the IRIN subroutine

No_Sig	Bcf IR_Valid			; Indicate, No signal or invalid header, detected
	Return				; Exit the IRIN subroutine					
Endasm
Over_IR_RX_TX: