'Program IR_REC.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This program reads signals from the complimentary transmitter,
' and returns the date byte in the variable "IR_BYTE",
' the ID code in the variable "IR_ID",  
' and the variable, "IR_VALID" is set to one if a valid packet is received, 
' else it is reset to zero
' The infrared receiver module used is the Sharp ISU60.

' The infrared receiver module for this experiment should, 
' be a type that is set for a 38kHz carrier frequency. 
' If another type is used. some reduction in range may be noticed. 
' ** The output pin of the IR module connects to PortA.4 **

' With Sonys SIRCS specification, a start pulse is initially sent to
' indicate the beginning of a frame of data. This pulse is approx 2.4 msec in length. 
' Following this, are 8-bits of data, which represent the instruction being sent. 
' Then an additional 8-bit command byte, which identifies the transmitter used . 
' Data bits are sent with the least significant bit first.
' ***********************************************************************

	Include "Modedefs.Bas"
	Include "IR_RX_TX.Inc"			' Load in the IR receiver subroutine

' ** Setup the Crystal Frequency, in mHz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	1		' *** Debug pin Bit-1 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
'	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD

' ** Setup the new IRIN Defines **

	Define	IRIN_PORT	PortA		' Set the Port for the IR Detector to attach
	Define	IRIN_BIT	4		' Set the Pin for the IR Detector to attach

' ** Declare the Variables **
	Green_Led	Var	PortA.0		' The green LED is attached to this pin

' ** The main program starts here **

	Debug I,Clr:Pause 30			' Clear the LCD

        Debug I,Line1,"Data=   "
	
Main:	Low Green_Led				' Turn off the green LED
	Gosub IRIn				' Receive the remote control signal
	If IR_Valid=0 then goto Main		' Look again, if a valid packet has not been received
	If IR_ID=200 then			' If it is the correct transmitter, do the following code
	High Green_Led				' Turn on the green LED
        Debug I,Line1+9,#IR_Byte,"  "		' Display the data Byte (8-bit code)	
	Endif
        Goto Main				' Loop Forever.

