' Program SER_IR.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Send Asyncronous Serial Data over an Infra-Red Link
' At Various Baud Rates and Inverted Mode
' An Infra-Red LED should be Connected to PORTA.1
' If longer range is required and NPN transistor could be employed as an amplifier
'
' Place  Include "IRSEROUT.INC"
' At the front of the Program to load the new subroutine in
'
' To Use the IRSEROUT subroutine, Load the Variable:- 
' IR_BYTE with the appropriate value (0-255)
' And Call the Subroutine:-
' GOSUB IRSEROUT
'
' Five New Defines have been added:-
' IRSEROUT_PORT.....Selects the Port for sending (ie PORTB)	, Default PortA
' IRSEROUT_BIT......Selects the Pin for sending (ie 7)		, Default 1
' IRSEROUT_BAUD.....Selects the Baud Rate (ie 300,600,1200,2400), Default 1200 baud
' IRSEROUT_PACING...Selects the delay inbetween bytes sent.	, Default 1ms
' IRSEROUT_HEADER...Turns ON or OFF the 3-character header "#OK", Default OFF

' IRSerout works with 4mHz, 8mHz, 10mHz and 12mHz Xtals

' This routine is for the 16F84, but any 14bit core PIC could be used
' ***********************************************************************

	Include "Modedefs.Bas"
	Include "Irserout.Inc"			' Load in the New Subroutine

' ** Set Xtal Value in mHz **

	Define	OSC		4		' Set Xtal Frequency

' ** New Defines for IRSEROUT **
 
	Define	IRSEROUT_PORT	PortB		' Set IRSEROUT Port
	Define	IRSEROUT_BIT	7		' Set IRSEROUT Pin
	Define	IRSEROUT_BAUD	2400		' Set IRSEROUT Baud Rate
	Define	IRSEROUT_PACING	1		' Set the delay between bytes sent (in ms)
	Define	IRSEROUT_HEADER	0		' Turn on/off the three byte header "#OK"

' ** Declare Variables **

	Counter		Var	Byte		' Count from 0 to 255
	IR_ID		Con	1		' Transmitter number

' ** Start of Program **

Start:	Pause 500				' Wait For the Pic to Initialize

Main:	For Counter=0 to 255
	IR_BYTE="#":Gosub IRSerout		' Send a three byte header
	IR_BYTE="O":Gosub IRSerout		' to syncronise the receiver
	IR_BYTE="K":Gosub IRSerout		' with the actual byte sent
	IR_BYTE=IR_ID:Gosub IRSerout		' Send out the transmitter number		
	IR_BYTE=Counter				' Send out the data byte
	Gosub IRserout
	Next
	Goto Main				' Infinite Loop


