' Program IRSEROUT.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Send Asyncronous Serial Data over an Infra-Red Link
' At Various Baud Rates and Inverted Mode

' Place this Include file at the beginning of the program to load the new subroutine in
' i.e INCLUDE "IRSEROUT.INC"
'
' To Use the New Routine, Load the Variable:- 
' IR_BYTE with the appropriate value (0-255)
' And Call the Subroutine:-
' GOSUB IRSEROUT
'
' Four New Defines have been added:-
' IRSEROUT_PORT.....Selects the Port for sending (ie PORTB)
' IRSEROUT_BIT......Selects the Pin for sending (ie 7)
' IRSEROUT_BAUD.....Selects the Baud Rate (ie 300,600,1200,2400)
' IRSEROUT_PACING...Selects the delay between bytes sent.
' IRSEROUT_HEADER...Turn ON/OFF the three byte header, "#OK"

' IRSerout works with 4mHz, 8mHz, 10mHz and 12mHz Xtals

' This routine is for the 16F84, but any 14bit core PIC could be used
'*****************************************************************************************

' Define Variables

	Dlctr		Var	Byte	BANK0	' Counter For Serial Delay Routines
	Bctr		Var	Byte	BANK0	' Number Of Transmitted Bits
	Tr_B		Var	Byte	BANK0	' Variable Used In Transmitter
	IR_BYTE		Var	Byte	BANK0	SYSTEM	' Value To Be Send Out
	IR_Bit		Var	Bit	BANK0	' Pulse ON or OFF 
	Dl_Temp		Var	Byte	BANK0	' Counter2 For Serial Delay Routines
	On_Delay	Var	DL_Temp
	Off_Delay	Var	DL_Temp
	IR_Pacing_Dly	Var	Byte	BANK0	' Delay between bytes sent out (in us).
	IR_Temp_Reg	Var	Byte	BANK0

' ******************************
' ** Jump Over the Subroutine **
' ******************************
Goto	Over_IRSEROUT			

IRSerout:
Asm
#Define	IR_LED	IRSEROUT_PORT , IRSEROUT_BIT	;' Get the Port and Pin from the two new Defines

;' Set Defaults for IRSEROUT_PORT and IRSEROUT_PIN  to   PORTA BIT 0
	Ifndef IRSEROUT_PORT
IRSEROUT_PORT = PortA
	endif 
	Ifndef IRSEROUT_BIT
IRSEROUT_BIT = 0
	endif

;' Set Default to 1200 Baud Inverted
	Ifndef IRSEROUT_BAUD
IRSEROUT_BAUD = 1200
	endif

;' Set Default to No Pacing
	Ifndef IRSEROUT_PACING
IRSEROUT_PACING = 0
	endif

;' Set Default to No three byte Header
	Ifndef IRSEROUT_HEADER
IRSEROUT_HEADER = 1
	endif
			
		Bcf IRSEROUT_PORT,IRSEROUT_BIT	;' Clear the appropriate pin
		Bsf Status,5			;' Set to Bank1
		Bcf IRSEROUT_PORT,IRSEROUT_BIT	;' Make the appropriate pin an Output
		Bcf Status,5			;' Back to Page 0		

;' Place the SEROUT_PACING into the variable, "IR_PACING_DLY"
;' This is a form of interfacing between ASM and PBP.

		Movlw	IRSEROUT_PACING	;' Get the value of the define IRSEROUT_PACING
		Movwf	_IR_PACING_DLY		;' Place it into the variable IR_PACING_DLY


	If (IRSEROUT_HEADER == 1)

		Movf	IR_BYTE,w
		Movwf	_IR_Temp_Reg		
		Movlw	"#"
		Movwf	IR_BYTE
		Call IRSend_it
		Movlw	"O"
		Movwf	IR_BYTE
		Call IRSend_it
		Movlw	"K"
		Movwf	IR_BYTE
		Call IRSend_it
		Movf	_IR_Temp_Reg,w 
		Movwf	IR_BYTE	
	endif
;' Send out the Data serially at Various bauds, Inverted
IRSend_It	Clrwdt			;' Walk the Dog
		Mov w,IR_BYTE		;' Move the byte to send into the W register
		Movwf	_TR_B	
		Movlw	08
		Movwf	_Bctr		;' Eight Bits In A Byte!.
		Bsf	_IR_Bit
		Call	Send_Bit	;' Send the Start Bit at Approx 38kHz. 
SIRXmt		Rrf	_Tr_B		;' Rotate Right Moves the Data Bits Into the Carry
					;' Starting With Bit 0. 
   		Btfsc   Status,0	;' Test the Carry Flag
		Bcf	_IR_Bit		;' Send a Zero
    		Btfss   Status,0	;' Test the Carry Flag
		Bsf	_IR_Bit		;' Send A One
		Call	Send_Bit	;' Send the Data Bit at Approx 38 kHz. 
		Decfsz	_Bctr		;' Not Eight Bits Yet? Send the Next Data Bit
		Goto	SIRXmt
		Bcf	_IR_Bit		;' Set LO	
		Call	Send_Bit	;' Send the stop bit at Approx 38kHz

;' Do the IRSEROUT_PACING delay (in ms).
Endasm
	Pause IR_PACING_DLY
	Return
Asm

;' This Routine Sends a Pulse, modulated at 38kHz 
;' Out of the Appropriate pin within a Delay of 1 bit time

Send_Bit	
;' Assemble this code if the Baud rate is 300
	If (IRSEROUT_BAUD == 300)
		Movlw	128		;' Set the Delay Time for 300 Baud
	endif
;' Assemble this code if the Baud rate is 600
	If (IRSEROUT_BAUD == 600)
		Movlw	64		;' Set the Delay Time for 600 Baud
	endif
;' Assemble this code if the Baud rate is 1200
	If (IRSEROUT_BAUD == 1200)
		Movlw	32		;' Set the Delay Time for 1200 Baud
	endif
;' Assemble this code if the Baud rate is 2400
	If (IRSEROUT_BAUD == 2400)
		Movlw	16		;' Set the Delay Time for 2400 Baud
	endif

Pulse_Bit	Movwf	_Dlctr		;' Store it
Irlp1		Clrwdt			;' Walk The Dog
   		Btfsc   _Ir_Bit		;' If Ir_Bit=1 Then	
		Bsf	IR_LED		;' Turn the IR_Led On
    		Btfss   _Ir_Bit		;' If Ir_Bit=0 Then	
    		Bcf     IR_LED		;' Turn the IR_Led Off	

;' Assemble this code if the Xtal is 4mHz
	if  (OSC == 4)
		Movlw	3
		Movwf	_On_Delay
Inner1		Decfsz	_On_Delay
		Goto Inner1
	endif

;' Assemble this code if the Xtal is 8mHz
	if  (OSC == 8)
		Movlw	8
		Movwf	_On_Delay
Inner1		Decfsz	_On_Delay
		Goto Inner1
	endif

;' Assemble this code if the Xtal is 10mHz
	if  (OSC == 10)
		Movlw	12			;' *****Not Sure Untested ***
		Movwf	_On_Delay
Inner1		Decfsz	_On_Delay
		Goto Inner1
	endif

;' Assemble this code if the Xtal is 12mHz
	if  (OSC == 12)
		Movlw	17
		Movwf	_On_Delay
Inner1		Decfsz	_On_Delay
		Goto Inner1
	endif

		Bcf 	IR_LED		;' Turn the IR_LED Off

;' Assemble this code if the Xtal is 4mHz
	if  (OSC == 4)
		Nop
		Nop
		Nop
		Nop
		Nop
		Nop
	endif
;' Assemble this code if the Xtal is 8mHz
	if  (OSC == 8)
		Movlw	5
		Movwf	_Off_Delay
Inner2		Decfsz	_Off_Delay
		Goto Inner2
	endif

;' Assemble this code if the Xtal is 10mHz
	if  (OSC == 10)
		Movlw	5
		Movwf	_Off_Delay
Inner2		Decfsz	_Off_Delay
		Goto Inner2
	endif

;' Assemble this code if the Xtal is 12mHz
	if  (OSC == 12)
		Movlw	5
		Movwf	_Off_Delay
Inner2		Decfsz	_Off_Delay
		Goto Inner2
	endif

		Decfsz	_Dlctr
		Goto	Irlp1	
		Return

Endasm
Over_IRSEROUT: