' Program IRSERIN.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This Program Complements the IRSerTst.Bas Program
' A Sharp Infra-Red Sensor should be connected to PORTA.4
' And the Serial LCD should be connected to PORTA.1
'
' Because of the Inverting affect of the IR sensor 
' the serial receiver is the opposite mode to the transmitter

' The Transmitter sends at 2400 Baud Inverted Mode
' The Receiver will be set to 2400 Baud True Mode

' This routine is for the 16F84, but any 14bit core PIC could be used
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Set Xtal Value in Mhz **

	Define	OSC		4		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PORTA
	Define	DEBUG_BIT	1		' *** Debug pin 1 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
'	Define	DEBUG_PACING	100		' Delay 'in us' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD
	Shift_L		Con	24		' Shift display left
	Shift_R		Con	28		' Shift display right

' ** Declare Variables **

	SI		Var	PortA.4		' Set Serin Pin to PORTA.4
	IR_ID		Var	Byte
	IR_Rcv		Var	Byte		' Received Value

' ** Declare Constants **

	Baud_C0		Con	2400		' Calculate the Baud rate for T2400 baud
	Baud_C1		Con	Baud_C0/100	
	Baud_C2		Con	10000/Baud_C1
	Baud		Con	Baud_C2-20


	Pause 400				' Wait for Pic to Initialize
	Debug I,Clr:Pause 30			' Clear the LCD

Main:	Serin2 SI,Baud,[ wait ("#OK"),IR_ID,IR_Rcv]	' Receive the Data from the IR-Sensor
						' And search for the three byte header "#OK"		
	If IR_ID = 1 then
	Debug I,Line1,#IR_Rcv,"  "		' Send the Data to the LCD
	Endif
	Goto Main				' Repeat Forever

