' Program AM_TX.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Transmit a two byte code using the AM-TX1-418 or AM-RT4-418 transmitters
' Preceded by a 3 character syncronizing header consisting of "#OK"
' S_BYTE, holds the byte to be transmitted
' RC_ID, holds a unique transmitter number
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in mHz **

	Define 	OSC		4		' Set Xtal Frequency


' ** Declare the Variables **
	Counter		Var	Byte		' For-next loop variable
	S_Byte		Var	Byte		' The data byte to be transmitted
	RC_ID		Var	Byte		' The transmitter ID

' ** Declare the Constants **
	B1200		Con	17197  		' Inverted 1200 baud for SERIN2
	B2400		Con	16780  		' Inverted 2400 baud for SERIN2
	B4800		Con	16572  		' Inverted 4800 baud for SERIN2

	RC_ID=21					' Transmitter number is 21
Main:	For Counter= 0 to 255
	S_Byte=Counter					' Transfer COUNTER into S_BYTE
	Serout2 PortA.0,B2400,["#OK",RC_ID,S_Byte]	' Send out the 2 bytes preceded by a 3 chr header
	Pause 100					' Pause so we can see whats happening at the receiving end
	Next
	Goto Main

