' Program AM_RX.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Receive a two byte code using the AM-HRRX-418 range of receivers.
' And display the results on a serial LCD connected to PortA.0 and configured for N9600 baud
' The syncronizing header consisting of "#OK" is looked for first
' then the 2 byte code is received
' RCV_BYTE, holds the data byte
' RC_ID, holds the unique transmitter number
' ***********************************************************************

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in mHz **

	Define 	OSC		4			' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortA			' Debug PortA
	Define	DEBUG_BIT	0			' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600			' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1			' Set Serial Mode 0=True, 1=Inverted

' ** Declare the Variables **
	
	Rcv_Byte	Var	Byte			' The data byte received
	RC_ID		Var	Byte			' Transmitter ID code

' ** Define LCD Constants **
	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2

' ** Declare the Constants **
	B1200		Con	17197  			' Inverted 1200 baud for SERIN2
	B2400		Con	16780  			' Inverted 2400 baud for SERIN2
	B4800		Con	16572  			' Inverted 4800 baud for SERIN2
	
	Debug I,Clr:Pause 30				' Clear the LCD

Main:	Serin2 PortA.1,B4800,[wait ("#OK"),RC_ID,Rcv_Byte] ' Wait for the header characters then receive the 2 byte code
	Debug I,Line1,#RC_ID,",",#Rcv_Byte,"  "		' Display the results on the LCD
	Goto Main					' Do it forever
