' Program SLEEP2.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' A demonstration of placing the PIC into low power mode
' Using the Assemblers SLEEP command.
' And waking on a key stroke.
' PortB.0 wakes up the PIC from sleep in this program
 
' As with all the flag bits, the interrupt of interest first needs to be set (INTE in this instance).
' This will not cause a global interrupt unless the GIE bit is set.
' Upon sensing a change on PortB.0 the PIC sets flag INTF
' However, this is not cleared by hardware. so before entering SLEEP it must be cleared.
' Another bit that must be set is the type of edge that the pin sees
' INTEDGE is set for a rising edge, and cleared for a falling edge.
' As we are detecting a pin going low, the edge is falling (INTEDGE=0)

' For the SLEEP command to work, the watchdog timer must be disabled.
' Otherwise it will wake the PIC every few milliseconds.
' And the PortB pullup resistors must be enabled, 
' or the floating pins will cause a change on PortB.
' ***********************************************************************

' ** Disable the Watchdog timer **
@        Device  wdt_off

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Declare the Variables **
	Red_LED		Var	PortA.2		' Assign the LED's pin
	GIE		Var	INTCON.7	' Global interrupt enable
	RBPU		Var	OPTION_REG.7	' PortB pullups (1=disabled, 0=enabled)
	INTEDG		Var	OPTION_REG.6	' RB0/INT Edge select (1=rising, 0=falling)
	INTE		Var	INTCON.4	' RB0/INT interrupt enable 
	INTF		VAr	INTCON.1	' RB0/INT interrupt flag

' ** THE MAIN PROGRAM STARTS HERE **
Main:
	GIE=0					' Turn OFF global interrupts (just in case)
	While GIE=1:GIE=0:Wend			' And make sure they are off
	TrisB.0=1				' Set PortB.4 as an Input
	RBPU=0					' Enable PortB Pullup Resistors
	INTEDG=0				' Trigger on the falling edge of RB0
	INTE=1					' Enable RB0/INT interrupt

Again:
	Pause 100				
	Low Red_LED				' Turn off the LED
	INTF=0					' Clear the RB0/INT interrupt flag
@	Sleep					' Put the PIC to sleep
	Pause 100				' When it wakes up, pause for 100ms
	High Red_LED				' Then light the LED
	Goto Main				' Do it forever
