' Program SLEEP.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' A demonstration of placing the PIC into low power mode
' Using the Assemblers SLEEP command.
' And waking on a key stroke.
' A change on PortB's pins 4..7 wakes up the PIC from sleep in this program
' 
' As with all the flag bits, the interrupt of interest first needs to be set (RBIE in this instance).
' This will not cause a global interrupt unless the GIE bit is set.
' Upon sensing a change on PortB pins 4..7 the PIC sets flag RBIF
' However, this is not cleared by hardware. so before entering SLEEP it must be cleared.
'
' For the SLEEP command to work, the watchdog timer must be disabled.
' Otherwise it will wake the PIC every few milliseconds.
' And the PortB pullup resistors must be enabled, 
' or the floating pins will cause a change on PortB.
' ***********************************************************************

' ** Disable the Watchdog timer **
@        Device  wdt_off

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Declare the Variables **
	LED		Var	PortB.0		' Assign the LED's pin
	RBIF		Var	INTCON.0	' PORTB[4..7] Change Interrupt Flag
	RBIE		Var	INTCON.3	' PORTB[4..7] Change Interrupt Enable
	RBPU		Var	OPTION_REG.7	' PortB pullups (1=disabled, 0=enabled)
	GIE		Var	INTCON.7	' Global interrupt enable/disable

' ** THE MAIN PROGRAM STARTS HERE **
Main:
	GIE=0					' Turn OFF global interrupts
	While GIE=1:GIE=0:Wend			' And make sure they are off
	TrisB.4=1				' Set PortB.4 as an Input
	RBPU=0					' Enable PortB Pullup Resistors
	RBIE=1					' Enable PortB[4..7] interrupt

Again:
	Pause 100				
	Low LED					' Turn off the LED
	RBIF=0					' Clear the PORTB[4..7] interrupt flag
@	Sleep					' Put the PIC to sleep
	Pause 100				' When it wakes up, pause for 100ms
	High LED				' Then light the LED
	Goto Again				' Do it forever
