' Program TMR0_INT
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Flash an LED Using the TMR0 interrupt on a PIC16F84
' ***********************************************************************

' ** Disable the watchdog timer **
@       Device  wdt_off

	Include "Modedefs.Bas"
	Include "2k_Int.Inc"			' Load the Interrupt register context saving macros

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

	Define	INTHAND		My_Int		' Point to the Assembler interrupt handling routine

' ** Assign the connections to the Green LED **
	Green_Led	Var	PortA.0

' ** Declare the bits and flags of the various registers **

	T0IE		Var	INTCON.5	' Timer0 Overflow Interrupt Enable
	T0IF		Var	INTCON.2	' Timer0 Overflow Interrupt Flag
	GIE		Var	INTCON.7	' Global Interrupt Enable

	PS0		Var	OPTION_REG.0	' Prescaler division bit-0
	PS1		Var	OPTION_REG.1	' Prescaler division bit-0
	PS2		Var	OPTION_REG.2	' Prescaler division bit-0
	PSA		Var	OPTION_REG.3	' Prescaler Assignment (1= assigned to WDT)
						'		       (0= assigned to oscillator)
	T0CS		Var	OPTION_REG.5	' Timer0 Clock Source Select (0=Internal clock) 
						'			     (1=External PORTA.4)
	RBPU		Var	OPTION_REG.7	' PortB pullups (1=disabled, 0=enabled)

Goto Over_Interrupt				' Jump over the interrupt handler

' This is our Interrupt handler subroutine
' It flashes an LED connected to PortB.0
' every time the interrupt is called
Asm
My_Int
	Int_Start				; Context saving Macro
	Movlw 255				; Xor PortB with 255,Which will turn on on one interrupt	
	Xorwf PortB				; and turn off on the next, the led connected to PortB.0
	Bcf INTCON,T0IF				; Clear the TMR0 overflow flag
	Int_End					; Context restore and exit interrupt maco
Endasm

' ** THE MAIN PROGRAM STARTS HERE **

Over_Interrupt:
	TrisB=0					' Configure PortB as all outputs
	GIE=0					' Turn off global interrupts
	While GIE=1:GIE=0:Wend			' Make sure they are off
	PSA=0					' Assign the prescaler to external oscillator
	PS0=1					' Set the prescaler
	PS1=1					' to increment TMR0
	PS2=1					' every 256th instruction cycle
	T0CS=0					' Assign TMR0 clock to internal source
	TMR0=0					' Clear TMR0 initially
	T0IE=1					' Enable TMR0 overflow interrupt
	GIE=1					' Enable global interrupts

' This is the main program loop
' All it does is flash a Green LED connected to PortA.0
' every half a second
	
Again:	High Green_Led				' Turn on the Green LED
	Pause 500				' For .5 seconds
	Low Green_LED				' Turn off the Green LED
	Pause 500				' For .5 seconds
	Goto Again				' Do it forever
