' Program TMR0CLCK.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' TMR0 interrupt driven clock
' Using the true PIC hardware interrupts in assembler
' Displays the time on a serial LCD connected to PortA.0
' ***********************************************************************

' ** Disable the watchdog timer **
@       Device  wdt_off

	Include "Modedefs.Bas"
	Include "2k_Int.Inc"			' Load the Interrupt context saving macros

' ** Setup the Crystal Frequency in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

	Define	INTHAND		Clock_Int	' Point to the Assembler interrupt handling routine

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit1 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted

' ** Define LCD Control Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to begining of line 1
	Line2		Con	192		' Point to begining of line 2
	Line3		Con	148		' Point to begining of line 3
	Line4		Con	212		' Point to begining of line 4

' ** Declare the Variables **

	Hour    	Var     Byte    	' Holds the hours value (0-23)
	Minute  	Var     Byte    	' Holds the minutes value (0-59)
	Second  	Var     Byte    	' Holds the seconds value (0-59)
	Ticks   	Var     Byte    	' Holds the pieces of seconds value (0-59)
	U_Flag  	Var     Byte    	' Indicator to allow the update of the display

' ** Declare the bits and flags of the various registers **

	T0IE		Var	INTCON.5	' TMR0 Overflow Interrupt Enable
	T0IF		Var	INTCON.2	' TMR0 Overflow Interrupt Flag
	GIE		Var	INTCON.7	' Global Interrupt Enable
	PS0		Var	OPTION_REG.0	' Prescaler division bit-0
	PS1		Var	OPTION_REG.1	' Prescaler division bit-0
	PS2		Var	OPTION_REG.2	' Prescaler division bit-0
	PSA		Var	OPTION_REG.3	' Prescaler Assignment (1= assigned to WDT)
						'		       (0= assigned to oscillator)
	T0CS		Var	OPTION_REG.5	' Timer0 Clock Source Select (0=Internal clock) 
						'			     (1=External PORTA.4)

Goto Over_Interrupt				' Jump over the interrupt handler

' ** INTERRUPT ROUTINE TO HANDLE EACH TIMER TICK **
' The interupt will be called every 16.384ms.
' Each time the interupt is called the variable TICKS will be incremented.
' When TICKS reaches 61, an approximate second has elapsed. 
' Calculated by:- (16.384*61)=999.424ms or .999424 of a second
' If the time has changed then the flag U_FLAG is set, else it is left alone.
Asm
Clock_Int					; Interrupts name
	Int_Start				; use the context saving macro

	Incf _Ticks				; Increment the TICKS variable
	Cjbe _Ticks,#61,Clock_Exit		; Have we reached a second yet?

; One second has elasped so update the time variables
	Clrf _Ticks				; YES! so reset TICKS
	Incf _Second				; and increment the SECONDS variable
	Cjb _Second,#60,Minute			; Have we reached a minute yet?
	Clrf _Second				; YES! so reset SECONDS
	Incf _Minute				; and increment MINUTES
Minute	Cjb _Minute,#60,Hour			; Have we reached an hour yet?
	Clrf _Minute				; YES! so reset MINUTES
	Incf _Hour				; and increment HOURS
Hour	Cjb _Hour,#23,Day			; Have we reached 24 hours yet?
	Clrf _Hour				; YES! so reset HOURS
Day	Movlw 1
	Movwf _U_Flag      			; Inform the main program that the time has changed
Clock_Exit
	Bcf INTCON,T0IF				; Clear the TMR0 overflow flag

	Int_End					; Context restore, and exit interrupt macro
Endasm

Over_Interrupt:

' ** THE MAIN PROGRAM STARTS HERE **
        Hour=0        				' Set the initial time to 00:00:00
        Minute=0
        Second=0
        Ticks=0
        U_Flag=1      				' Allow the display to update initially

	GIE=0					' Turn off global interrupts
	While GIE=1:GIE=0:Wend			' Make sure they are off
	PSA=0					' Assign the prescaler to external oscillator
	PS0=1					' Set the prescaler
	PS1=0					' to increment TMR0
	PS2=1					' every 64th instruction cycle
	T0CS=0					' Assign TMR0 clock to internal source
	TMR0=0					' Clear TMR0 initially
	T0IE=1					' Enable TMR0 overflow interrupt
	GIE=1					' Enable global interrupts

' ** THE MAIN LOOP STARTS HERE **
	Debug I,Clr:Pause 30			' Clear the LCD
Main:	If U_Flag=1 then			' Check if the time has changed
	Debug I,Line1, dec2 Hour, ":", dec2 Minute, ":", dec2 Second ' Display time as hh:mm:ss
	U_Flag=0      				' Clear the display update flag
	Endif
	Goto Main				' Loop forever



