' Program INT_CLCK.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' TMR0 interrupt driven clock
' Using the ON INTERRUPT command
' Displays the time on a serial LCD connected to PortA.0
' ***********************************************************************

' ** Disable the watchdog timer **
@       Device  wdt_off

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortA
	Define	DEBUG_BIT	0		' *** Debug pin Bit1 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted

' ** Define LCD Control Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4
	Cgram		Con	64		' Point to Cgram within LCD

' ** Declare the Variables **
	Hours    	Var     Byte    	' Holds the hours value (0-23)
	Minutes  	Var     Byte    	' Holds the minutes value (0-59)
	Seconds  	Var     Byte    	' Holds the seconds value (0-59)
	Ticks   	Var     Byte    	' Holds the pieces of seconds value (0-59)
	U_Flag  	Var     Byte    	' Indicator to allow the update of the display

' ** Declare the bits and flags of the various registers **

	T0IE		Var	INTCON.5	' Timer0 Overflow Interrupt Enable
	T0IF		Var	INTCON.2	' Timer0 Overflow Interrupt Flag
	GIE		Var	INTCON.7	' Global Interrupt Enable
	PS0		Var	OPTION_REG.0	' Prescaler division bit-0
	PS1		Var	OPTION_REG.1	' Prescaler division bit-0
	PS2		Var	OPTION_REG.2	' Prescaler division bit-0
	PSA		Var	OPTION_REG.3	' Prescaler Assignment (1= assigned to WDT)
						'		       (0= assigned to oscillator)
	T0CS		Var	OPTION_REG.5	' Timer0 Clock Source Select (0=Internal clock) 
						'			     (1=External PORTA.4)

' ** THE MAIN PROGRAM STARTS HERE **
        Hours=0        				' Set the initial time to 00:00:00
        Minutes=0
        Seconds=0
        Ticks=0
        U_Flag=1      				' Allow the display to update initially

' Set TMR0 to interrupt every 16.384ms. Using a prescaler value of 64 (64*256)
	GIE=0					' Turn off global interrupts
	While GIE=1:GIE=0:Wend			' Make sure they are off
	PSA=0					' Assign the prescaler to external oscillator
	PS0=1					' Set the prescaler
	PS1=0					' to increment TMR0
	PS2=1					' every 64th instruction cycle
	T0CS=0					' Assign TMR0 clock to internal source
	TMR0=0					' Clear TMR0 initially
	T0IE=1					' Enable TMR0 overflow interrupt
	GIE=1					' Enable global interrupts

        On Interrupt Goto Clock_Int		' Point to the interrupt handler

' ** THE MAIN LOOP STARTS HERE **
	Debug I,Clr:Pause 30			' Clear the LCD
Main:	If U_Flag=1 then			' Check if the time has changed
	Debug I,Line1, dec2 Hours, ":", dec2 Minutes, ":", dec2 Seconds ' Display time as hh:mm:ss
	U_Flag=0      				' Clear the flag
	Endif
	Goto Main				' Loop forever


' ** INTERRUPT ROUTINE TO HANDLE EACH TIMER TICK **
' The interupt will be called every 16.384ms.
' Each time the interupt is called the variable TICKS will be incremented.
' When TICKS reaches 61, an approximate second has elapsed. 
' Calculated by:- (16.384*61)=999.424ms or .999424 of a second

        Disable         			' Disable all interupts during the interrupt handler
Clock_Int: 
	Ticks=Ticks+1      			' Increment the TICKS variable
	If Ticks <=61 then Clock_Exit       	' Have we reached a second yet?

' One second has elasped so update the time variables
	Ticks=0					' YES! so reset TICKS
	Seconds=Seconds+1			' and increment the SECONDS variable
	If Seconds >=60 then			' Have we reached a minute yet?
	Seconds=0				' YES! so reset SECONDS
	Minutes=Minutes + 1			' and increment MINUTES
	If Minutes >=60 then			' Have we reached an hour yet?
	Minutes=0				' YES! so reset MINUTES
	Hours=Hours+1				' and increment HOURS
	If Hours >=23 then			' Have we reached a 24 hours yet?
	Hours=0					' YES! so reset HOURS
	Endif
	Endif
	Endif
	U_Flag=1      				' Inform the main program that the time has changed

Clock_Exit:
	T0IF=0    				' Reset timer interrupt flag
        Resume					' Exit the interupt
	Enable					' Allow more interrupts

