' Program 4K_INTS.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' A macro designed to ease the use of hardware interrupts
' On PICs with 4K of ROM

' The macro INT_END, must be placed at the end of the interrupt handler 
' ASM
' MY_INT

' Interrupt handler goes here

' INT_END
' ENDASM
' ***********************************************************************
Asm
Int_end Macro
	Movf	Psave,w				; Restore PCLATH register
	Movwf	PCLATH
	Swapf	Ssave,w				; Restore STATUS register			
	Movwf	STATUS
	Swapf	Wsave,f
	Swapf	Wsave,w				; Restore W register
	Retfie					; Exit the interrupt subroutine	
	Endm
Endasm
' ** Declare the variables to store the hardware registers into **
	Wsave	Var	Byte	$20	SYSTEM	' Save location for the W register in bank-0
	Wsave1	Var	Byte	$A0	SYSTEM	' Save location for the W register in bank-1
	Ssave	Var	Byte	Bank0	SYSTEM	' Save location for the STATUS register
	Psave	Var	Byte	Bank0	SYSTEM	' Save location for the PCLATH register






