' 2K_INTS.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Two macro's designed to ease the use of hardware interrupts
' On PICs with 2K or less of ROM

' The first macro INT_START, must be placed just after declaring the interrupts name
' The second macro INT_END, must be placed at the end of the interrupt handler 
' ASM
' MY_INT
' INT_START
'
' Interrupt handler goes here

' INT_END
' ENDASM
Asm
Int_Start Macro
	Movwf	Wsave
	Swapf	STATUS,w
	Clrf	STATUS
	Movwf	Ssave
	Movf	PCLATH,w
	Movwf	Psave
	Endm

Int_end Macro
	Movf	Psave,w				; Restore PCLATH register
	Movwf	PCLATH
	Swapf	Ssave,w				; Restore STATUS register			
	Movwf	STATUS
	Swapf	Wsave,f
	Swapf	Wsave,w				; Restore W register
	Retfie					; Exit the interrupt subroutine	
	Endm
Endasm
' ** Declare the variables to store the hardware registers into **
	Wsave	Var	Byte 	SYSTEM 		' Save location for the W register
	Ssave	Var	Byte 	SYSTEM		' Save location for the STATUS register
	Psave	Var	Byte 	SYSTEM		' Save location for the PCLATH register






