' Program SERKEY.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Scan a 12 or 16 button keyboard and transmit the key pressed, 
' PortB.4, PortB.5, and PortA.4 are linked to ground for various configurations: -

' PortB.5 (LINK1) LOW - Output 9600 baud, HIGH - Output 1200 baud
' PortB.4 (LINK2) LOW - ASCII output, HIGH - Numeric output
' PortA.4 (LINK3) LOW - 16 button keypad connected, HIGH - 12 button keypad connected

' PortB.6 goes high when a key is pressed 50ms before the serial data is transmitted. 
' The serial data (T1200 or T9600 baud) is sent from PortB.7.
' It transmits 128 or 32 depending on Numeric or ACSII flag, if no keys are pressed.
' The serial output is built up of three bytes
' The FIRST byte is the sync, which is "@".
' The SECOND byte is the actual keypress value.
' The THIRD byte is the debounce flag (1 if the key is still being pressed).

' ** Set the CONFIG bits for the 16F84 **
@        Device  Pic16F84, XT_OSC, WDT_ON, PWRT_ON, PROTECT_OFF

	Include "Modedefs.Bas"

' ** Set Xtal Value in Mhz **

	Define	OSC		4	  ' Set Xtal Frequency

' ** Declare Subroutine Variables **


	Key		Var	Byte		' Value of the key pushed
	Debounce 	Var 	Bit 	  	' Flag to indicate a keypress.
	D_Flag 		Var 	Bit 	  	' Debounce flag used by Inkeys.
	K_Flag		Var	Bit		' Used by the inkeys subroutine
	Baud		Var	Word	  	' The serout baud rate 2400 or 9600 baud
	SO		Var	PortB.7	  	' Serout pin
	Strobe		Var	PortB.6	  	' Data valid pin, goes high 50ms before serial data is sent
	Butt_Link	Var	PortA.4	  	' 12 or 16 button keypad link Input
	Num_Link	Var	PortB.4	  	' Numeric or ASCII link Input
	Baud_Link	Var	PortB.5	  	' Baud rate Link Input

' ** These are flags that inform the program, 
' ** which keypad, baudrate, output type, and sync byte to configure to.

	Buttons		Var	Bit	  	' Holds the keypad type, 1 = 12-button,0 = 16-button
	Numeric		Var	Bit	  	' Output type, 1 = Numeric, 0 = ASCII
	Baudrate	Var	Bit	  	' Select baudrate 1 = 1200baud, 0 = 9600baud

' ** The Main program starts here **
	Pause 500
	D_Flag=0
	PortA=0
	PortB=0
	TrisA=%11110000			  ' Make PortA, bits 0-3 Outputs and bit 4 an input
	TrisB=%00111111			  ' Make PortB, bits 6-7 outputs and the rest inputs	
	Option_Reg.7=0			  ' Enable Internal PortB Pullup Resistors
	
Main:	Buttons=Butt_Link		  ' Check Link 3, Number of buttons on keypad
	Numeric=Num_Link		  ' Check Link 2, Numeric or ASCII output
	Baudrate=Baud_Link		  ' Check Link 1, Baudrate 1200 or 9600

	 If Baudrate=1 then		  ' Check if the Baudrate should be 1200 or 9600
	  Baud=T1200			  ' If BAUDRATE is 1 then make the baudrate 1200
	  Else				  ' Else
	  Baud=T9600			  ' Make it 9600 baud
	 Endif
Again:	Gosub Inkeys			  ' Go and scan the keypad
	If Key=128 or Key=32 then	  ' If no key is pressed then do the following: -
	Nap 0				  ' Go into low power mode for 18ms
	Goto Again			  ' And look again when woken up.
	Endif
	High Strobe  			  ' Enable the Strobe pin
	  Pause 50			  ' Delay for 50ms after strobe pin is set HIGH
	  Serout SO,Baud,["@"]	  	  ' Transmit the sync byte
	  Pause 1			  ' Delay for 1ms after the sync byte is sent
	  Serout SO,Baud,[Key]	  	  ' Transmit the KEY byte
	  Pause 1			  ' Delay for 1ms after the KEY byte is sent
	  Serout SO,Baud,[Debounce]	  ' Transmit the Debounce bit with a delay inbetween
	  NAP 0				  ' Low power delay of 18ms using a 4Mhz xtal
	Low Strobe			  ' Disable the Strobe pin
	Goto Main			  ' Do it all again!

' This subroutine Scans a 12 or 16-button keypad 
' and returns the key Pressed in KEY
' And the debounce flag in DEBOUNCE
' If no key is pressed; the value returned is 128 or 32, 
' depending on the Numeric or ASCII flag.

Inkeys: Debounce=1
	Key=0					' Clear the variable KEY, prior to scanning
	PortA=%0111				' Pull the fourth Row line LOW
	Gosub ScanCol				' Scan the Columns
	If K_Flag=1 then goto Map		' If a key is pressed then map it 
	PortA=%1011				' Pull the third Row line LOW
	Gosub ScanCol				' Scan the Columns
	If K_Flag=1 then goto Map		' If a key is pressed then map it 
	PortA=%1101				' Pull the second Row line LOW
	Gosub ScanCol				' Scan the Columns
	If K_Flag=1 then goto Map		' If a key is pressed then map it 
	PortA=%1110				' Pull the first Row line LOW
	Gosub ScanCol				' Scan the Columns
	If K_Flag=1 then goto Map		' If a key is pressed then map it 
	D_Flag=0				' No key pressed, so Reset debounce flag
	Debounce=0 			        ' No key pressed, so Reset key Debounce flag
	Goto Exit				' Exit from the subroutine via the lookups commands
' ** Do the following code if a key has been pressed **
Map:	If D_Flag=1 then Exit 			' Already responded to this press, so exit
	D_Flag=1				' Set Debounce flag
	Debounce=0 				' Reset key Debounce flag	
Exit:	If Buttons=0 then			' *** Check for a 16-button keypad ***
	 If Numeric=1 then		  	' *** Check if NUMERIC or ASCII output ***
	  Lookup Key,[1,4,7,15,2,5,8,0,3,6,9,14,10,11,12,13,128],Key ' Arrange Numeric output for a 16-button keypad
	  Else
	  Lookup Key,["1","4","7","F","2","5","8","0","3","6","9","E","A","B","C","D",32],Key
	 Endif
	Endif	
	If Buttons=1 then			' *** Check for a 12-button keypad ***
	 If Numeric=1 then		  	' *** Check if NUMERIC or ASCII output ***
	  Lookup Key,[1,2,3,4,5,6,7,8,9,10,0,11,128],Key ' Map of the keypad legends for numeric output
	  Else
	  Lookup Key,["1","2","3","4","5","6","7","8","9","*","0","#",32],Key ' Map of the keypad legends for ascii output
	 Endif
	 Endif
	Return					' Exit from the subroutine

' This subroutine scans the Columns
' The bit, K_FLAG returns a 1 if a key is pressed, and 0 if no key pressed
' Also, if no key is pressed the variable KEY will return with the value of 12 or 16,
' depending on which keypad is chosen.
ScanCol:
	K_Flag=1				' Set K_Flag initially to 1
	If PortB.0=0 then Return		' Return if a key on the first column is pressed
	Key=Key+1				' Else increment KEY, and try another row
	If PortB.1=0 then Return		' Return if a key on the second column is pressed
	Key=Key+1				' Else increment KEY, and try another row
	If PortB.2=0 then Return		' Return if a key on the third column is pressed
	Key=Key+1				' Else increment KEY, and try another row
	If Buttons=0 then		  	' *** Check for a 16-button keypad ***
	 If PortB.3=0 then Return		' Return if a key on the fourth column is pressed
	 Key=Key+1				' Else increment KEY
	Endif
	K_Flag=0				' Set the K_Flag to indicate no key pressed
	Return					' And exit the subroutine
