' Program KEYIN.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Read the serial data from the Serial keypad controller
' And display the results on the Serial LCD set to Inverted 9600 baud.
' The serial data is received on PortA.0
' And the Serial LCD is attached to PortA.1

	Include "Modedefs.Bas"

' ** Set Xtal Value in Mhz

	Define	OSC		4		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PortB
	Define	DEBUG_BIT	2		' *** Debug pin Bit-0 ***
	Define	DEBUG_BAUD	9600		' *** 9600 Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode Inverted
'	Define	DEBUG_PACING	100		' Delay 'in Us' between characters sent

' ** Declare Variables **

	Key		Var	Byte	  	' Value of the key pushed
	Debounce	Var	Byte		' Value of the debounce flag
	Key_Port	Var	PortA.0		' Port that Serial Keypad is attached to
	Strobe		Var	PortA.1		' Port that will look for the Strobe input

' ** Declare Constants **

	I		Con	254	  	' Control byte for LCD
	Clr		Con	1	  	' Code to clear the LCD
	Line1		Con	128	  	' Point to Line 1 of the LCD
	Line2		Con	192	  	' Point to Line 2 of the LCD

' ** The Main program starts here **

	Pause 200				' Wait for Pic to initialise
	TrisA.1=1				' Make the Strobe pin an Input.
	Debug I,Clr:Pause 30			' Clear the LCD
	Debug I,Line1,"Key Pressed "		' Print to the first line of the LCD
Main:	
	If Strobe=1 then Gosub Keyin		' Receive the serial data from the keypad
	Debug I,Line1+12,#Key,"  "		' Display the result on the LCD
	Goto Main				' Do it all again!

' This subroutine continuously looks for the sync byte, "@"
' and when found reads in the next 2 bytes,
' which is the value of the key pressed and the debounce flag.

KeyIn:	Serin2 Key_Port,84,[wait ("@"),Key,Debounce]  ' Receive the serial values, only when the sync byte is detected
	Return					' And exit the subroutine
