' Program ASM_KEY.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Scan a 12-button keypad using an assembler scanning subroutine.
' The connections to the keypad are in the experimenting with PBP book.

	Include "Modedefs.Bas"
	Include "ASM_Key.Inc"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortB		' Debug PortB
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 0=True, 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in Us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD

' ** These are the new Defines for the keypad **
	Define	KEYPAD_BUTTONS	16		' Amount of buttons on the keypad 12 or 16
	Define 	KEYPAD_RETURN	0		' 0= Numeric value, 1= ACSII value returned

' ** The main program starts here **
	Pause 200				' Wait for Pic to initialise
	Debug I,Clr:Pause 30			' Clear the LCD
	Debug I,Line1,"Key Pressed"		' Print to the first line of the LCD

Main:	
@	Inkeys Key				' Scan the keypad, using the macro "INKEYS"
'	Gosub Inkeys				' Scan the keypad, using "GOSUB"
	Debug I,Line1+12,#Key,"   "		' Display the Key value
	Goto Main				' Do it all again!


