' Program ASM_KEY.Inc
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Scan a 12 or 16-button keypad.
' The connections to the 12 or 16 button keypads are in the experimenting with PBP book.

Goto Over_Keyscan
' ** Build the macro, INKEYS **
' ** Its use is: -
' ** @	INKEYS Variable 
' Variable, is loaded with the key pressed
' ** The variables must be made  system variables, otherwise an underscore is needed
Asm
Inkeys	Macro Var			;' Define the macro
Endasm
	Gosub Inkeys			' Do the keyboard scanning
Asm
	Ifnb Var			;' Establish if the First variable is being used
	 Movf Key,w			;' Load the key value returned,
	 Movwf Var			;' into the specified variable
	Endif
	Endm
Endasm

' ** Declare the variable used within the subroutine **

	Key		Var	Byte	BANK0	SYSTEM

Inkeys:
Asm

;' Default to a 16 button keypad if the define "KEYPAD_BUTTONS" is not added to the program
	Ifndef KEYPAD_BUTTONS
KEYPAD_BUTTONS = 16
	endif 
;' Default to Numeric value returned, if the define "KEYPAD_RETURN" is not added to the program
	Ifndef KEYPAD_RETURN
KEYPAD_RETURN = 0
	endif 


	Bsf Status,5			;' Set to Bank1
	Bcf PortA,0
	Bcf PortA,1
	Bcf PortA,2
	Bcf PortA,3			;' Make the appropriate pins of PortA Outputs
	Bsf PortB,0
	Bsf PortB,1
	Bsf PortB,2
	Bsf PortB,3			;' Make the appropriate pins of PortB Inputs
	Bcf Option_Reg,7		;' Enable PortB Pullups
	Bcf Status,5			;' Back to Page 0	
	Goto KeyScan


;' Mapping of the keys on the keypad
;' Assemble this section if a 16 button keypad is chosen ***************
	if (KEYPAD_BUTTONS == 16)
;' Assemble this section if Numeric return is chosen
	if (KEYPAD_RETURN == 0)

KeyMap	Andlw	00fh				
	Addwf	pcl
	Retlw	13				
	Retlw	12				
	Retlw	11				
	Retlw	10				
	Retlw	14			
	Retlw	9				
	Retlw	6				
	Retlw	3			
	Retlw	0				
	Retlw	8				
	Retlw	5				
	Retlw	2				
	Retlw	15				
	Retlw	7				
	Retlw	4				
	Retlw	1				
	endif
;' Assemble this section if ASCII return is chosen
	if (KEYPAD_RETURN == 1)
KeyMap	Andlw	00fh				
	Addwf	pcl
	Retlw	68				
	Retlw	67				
	Retlw	66				
	Retlw	65			
	Retlw	69				
	Retlw	57				
	Retlw	54			
	Retlw	51				
	Retlw	48				
	Retlw	56				
	Retlw	53				
	Retlw	50				
	Retlw	70				
	Retlw	55				
	Retlw	52
	Retlw	49
	endif
	endif

;' Assemble this section if a 12 button keypad is chosen ***************
	if (KEYPAD_BUTTONS == 12)
;' Assemble this section if Numeric return is chosen
	if (KEYPAD_RETURN == 0)
KeyMap	Andlw	00fh				
	Addwf	pcl
	Retlw	10				
	Retlw	0				
	Retlw	11				
	Retlw	128				
	Retlw	7			
	Retlw	8				
	Retlw	9				
	Retlw	128			
	Retlw	4				
	Retlw	5				
	Retlw	6				
	Retlw	128				
	Retlw	1				
	Retlw	2				
	Retlw	3				
	Retlw	128				
	endif
;' Assemble this section if ASCII return is chosen
	if (KEYPAD_RETURN == 1)
KeyMap	Andlw	00fh				
	Addwf	pcl
	Retlw	42				
	Retlw	48				
	Retlw	35				
	Retlw	32				
	Retlw	55			
	Retlw	56				
	Retlw	57				
	Retlw	32			
	Retlw	52				
	Retlw	53				
	Retlw	54				
	Retlw	32				
	Retlw	49				
	Retlw	50				
	Retlw	51				
	Retlw	32
	endif
	endif
;' Make sure that the Lookup table is in Page 0
    if ($ >= 800h)
  LIST
        ERROR "Keypad lookup table can't exceed page 0."
  NOLIST
    endif
  LIST

;' Scan a 12 or 16-button keypad
;' The subroutine returns with the value of the keypress in the variable "KEY"
;' If no key pressed, a value of 128 or 32 is returned

;' Scan the columns of the keypad
Keyscan	Clrwdt					;' Walk the dog
	Clrf	KEY
	Movlw	00001110b			;' Pull the First column low 
	Call	scanrow				;' Check the Row 
	Btfsc	STATUS,c			;' No key pressed, so try the next column
	Goto	KS9				;' Key pressed, So go and calculate it 		
	Movlw	00001101b 			;' Pull the Second column low 
	Call	scanrow				;' Check the Row 
	Btfsc	STATUS,c			;' No key pressed, so try the next column
	Goto	KS9				;' Key pressed, So go and calculate it 	
	Movlw	00001011b			;' Pull the Third column low 
	Call	scanrow				;' Check the Row 
	Btfsc	STATUS,c			;' No key pressed, so try the next column
	Goto	KS9				;' Key pressed, So go and calculate it 	
	Movlw	00000111b 			;' Pull the Fourth column low 
	Call 	scanrow				;' Check the Row 
	Btfss 	STATUS,c			;' No key pressed on the last column, 
	Goto 	Exit				;' So goto exit
ks9	Movf	KEY,w				;' Come here when key press is detected
	Call 	KeyMap				;' Lookup the correct digit, for the keypad
	Movwf	KEY				;' Place it into the variable "KEY"
	Return					;' And exit the subroutine

Exit	Bsf PortA,0				;' Turn off all scan lines
	Bsf PortA,1
	Bsf PortA,2
	Bsf PortA,3
	if (KEYPAD_RETURN == 0)
	Movlw	128				;' No key press detected and numeric return is
	endif					;' chosen, so output 128
	if (KEYPAD_RETURN == 1)
	Movlw	32				;' No key press detected and ascii return is
	endif					;' chosen, so output a space (32)

	Movwf	KEY				;' Make the variable "KEY" = 128 or 32 
Endasm

 	Return                  		' Exit the subroutine, using the basic RETURN command
Asm
;' Scan one row of the keypad.
;' The subroutine returns with the carry flag set if a key is pressed
;' and the carry flag clear if no key pressed.
scanrow	Clrwdt					;' Walk the dog
	Bsf STATUS,C				;' Set the carry initially
	Movwf	PortA				;' Bring a column line LOW
	Btfss	PortB,0				;' Test the first row
	Return					;' Exit if a key is pressed
	Incf	KEY				;' Else try the second row
	Btfss	PortB,1				;' Test it
	Return					;' Return if a key is pressed
	Incf	KEY				;' Else try the next row
	Btfss	PortB,2				;' Try the third row
	Return					;' Return if a key is pressed
	Incf	KEY				;' Else try the next row
	Btfss	PortB,3				;' Try the fourth row
	Return					;' Return if a key is pressed
	Incf	KEY				;' 
	Clc					;' Clear the carry flag, to indicate no key pressed
	Return
Endasm
Over_Keyscan:
