' Program INKEYS16.INC
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This is an include file that integrates the INKEYS subroutine at the start
' of the host program.

' ** Declare Subroutine Variables **

 	Key		Var	Byte	BANK0	SYSTEM	' Key pressed value
	Debounce 	Var 	Byte	BANK0	SYSTEM 	' Flag to indicate a keypress.
	Inc_Flag	Var	Bit			' Internal Flag for detecting a key press
	Inc_D_Flag 	Var 	Bit 			' Debounce flag used by Inkeys.

	Inc_D_Flag=0			' Reset the debounce flag, prior to calling the subroutine
Goto Over_Inkeys16					' Jump Over the Subroutine

' ** Build the macro, INKEYS **
' ** Its use is: -
' ** @	INKEYS Variable 1 , Variable 2
' Variable 1, is loaded with the key pressed
' Variable 2, is loaded with the debounce flag, "DEBOUNCE"
' ** The variables must be made  system variables, otherwise an underscore is needed
Asm
Inkeys	Macro Var1,Var2			;' Define the macro with a possible two parameters
Endasm
	Gosub Inkeys			' Do the keyboard scanning
Asm
	Ifnb Var1			;' Establish if the First variable is being used
	 Movf Key,w			;' Load the key value retuned
	 Movwf Var1			;' Into the specified variable
	Endif
	Ifnb  Var2			;' Establish if the second variable is being used
	 Movf Debounce,w		;' If yes then load the value of pressed
	 Movwf Var2			;' Into the specified variable
	Endif
	Endm
Endasm

' This subroutine Scans the 16 button keypad and returns the value pressed in KEY
' If no key is pressed the value returned is 128.
' It also returns a Flag called DEBOUNCE which is 1 if a key is still pressed
' And 0 if not pressed. This acts as a debounce for the Keypad.
Inkeys:
	Debounce=1				' Setup the initial value for Debounce
	Key=0					' Clear the variable KEY, prior to scanning
	TrisA.0=0:TrisA.1=0			' Make the first four bits of PortA Outputs
	TrisA.2=0:TrisA.3=0			
	TrisB.0=1:TrisB.1=1			' Make the first four bits of PortB inputs
	TrisB.2=1:TrisB.3=1
	Option_Reg.7=0				' Enable Internal PortB Pullup Resistors	
	PortA=%0111				' Pull the fourth Row line LOW
	Gosub ScanCol				' Scan the Columns
	If Inc_Flag=1 then goto Map		' If a key is pressed then map it 
	PortA=%1011				' Pull the third Row line LOW
	Gosub ScanCol				' Scan the Columns
	If Inc_Flag=1 then goto Map		' If a key is pressed then map it 
	PortA=%1101				' Pull the second Row line LOW
	Gosub ScanCol				' Scan the Columns
	If Inc_Flag=1 then goto Map		' If a key is pressed then map it 
	PortA=%1110				' Pull the first Row line LOW
	Gosub ScanCol				' Scan the Columns
	If Inc_Flag=1 then goto Map		' If a key is pressed then map it 
	Inc_D_Flag=0				' No key pressed, so Reset debounce flag
	Debounce=0 			        ' No key pressed, so Reset key Debounce flag
	Goto Exit				' Exit from the subroutine
' Do the following code if a key has been pressed
Map:	  If Inc_D_Flag=1 then Exit 		' Already responded to this press, so exit
	  Inc_D_Flag=1				' Set Debounce flag
	  Debounce=0 				' Reset key Debounce flag
Exit:	Lookup Key,[15,7,4,1,0,8,5,2,14,9,6,3,13,12,11,10,128],Key ' Map of the keypad legends
' **To convert the output to an ascii value comment the line above and uncomment the line below
'	Lookup Key,["F","7","4","1","0","8","5","2","E","9","6","3","D","C","B","A"," "],Key
	Return					' Exit from the subroutine

' This subroutine scans the columns
' The bit, FLAG returns a 1 if a key is pressed, and 0 if no key pressed
' Also, if no key is pressed the variable KEY will return with the value of 16
ScanCol:
	Inc_Flag=1				' Set Flag initially to 1
	If PortB.0=0 then S_Exit		' Return if a key on the first column is pressed
	Key=Key+1				' Else increment KEY, and try another row
	If PortB.1=0 then S_Exit		' Return if a key on the second column is pressed
	Key=Key+1				' Else increment KEY, and try another row
	If PortB.2=0 then S_Exit		' Return if a key on the third column is pressed
	Key=Key+1				' Else increment KEY, and try another row
	If PortB.3=0 then S_Exit		' Return if a key on the fourth column is pressed
	Key=Key+1				' Else increment KEY, KEY now equals 16
	Inc_Flag=0				' Set the flag to indicate no key pressed
S_Exit:	Return					' And exit the subroutine
Over_Inkeys16: