' Program Keypad12.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Scan a 12-button keypad using the first four bits of PortA and PortB
' This is the same routine as ASM_KEY, but written in basic.

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Setup the Debug Defines **

	Define	DEBUG_REG	PortB		' Debug PortB
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in us' between characters sent

' ** Define LCD Control Constants **

	I		Con	254			' Control Byte
	Clr		Con	1			' Clear the display
	Line1		Con	128			' Point to beginning of line 1
	Line2		Con	192			' Point to beginning of line 2
	Line3		Con	148			' Point to beginning of line 3
	Line4		Con	212			' Point to beginning of line 4
	Cgram		Con	64			' Point to Cgram within LCD

' ** Declare the Variables **

	Flag		Var	Bit
	Key		Var	Byte
	Debounce 	Var 	Bit 	  	' Flag to indicate a keypress.
	D_Flag 		Var 	Bit 	  	' Debounce flag used by Inkeys.

	Debug I,Clr:Pause 30			' Clear the LCD
	D_Flag=0				' Reset the debounce flag, prior to calling the subroutine
Main:	
	Gosub KeyScan
	Debug I,Line1,#Key,"   "
	Goto Main

' This subroutine Scans the 12 button keypad and returns the key pressed in "KEY"
' If no key is pressed the value returned is 128.
' It also returns a Bit-Flag called "DEBOUNCE" which is 1 if a key is still in use
' And 0 if not. This acts as a debounce for the Keypad.
Keyscan:
	Debounce=1				' Setup the initial value for Debounce
	Key=0					' Clear the variable KEY, prior to scanning
	TrisA.0=0:TrisA.1=0			' Make the first four bits of PortA Outputs
	TrisA.2=0:TrisA.3=0			
	TrisB.0=1:TrisB.1=1			' Make the first three bits of PortB inputs
	TrisB.2=1
	Option_Reg.7=0				' Enable Internal PortB Pullup Resistors	
	PortA=%0111				' Pull the fourth Row line LOW
	Gosub ScanCol				' Scan the Columns
	If Flag=1 then goto Map			' If a key is pressed then map it 
	PortA=%1011				' Pull the third Row line LOW
	Gosub ScanCol				' Scan the Columns
	If Flag=1 then goto Map			' If a key is pressed then map it 
	PortA=%1101				' Pull the second Row line LOW
	Gosub ScanCol				' Scan the Columns
	If Flag=1 then goto Map			' If a key is pressed then map it 
	PortA=%1110				' Pull the first Row line LOW
	Gosub ScanCol				' Scan the Columns
	If Flag=1 then goto Map			' If a key is pressed then map it 
	D_Flag=0				' No key pressed, so Reset debounce flag
	Debounce=0 			        ' No key pressed, so Reset key Debounce flag
	Goto Exit				' Exit from the subroutine
' Do the following code if a key has been pressed
Map:	  If D_Flag=1 then Exit 		' Already responded to this press, so exit
	  D_Flag=1				' Set Debounce flag
	  Debounce=0 				' Reset key Debounce flag
Exit:	Lookup Key,[1,2,3,4,5,6,7,8,9,10,0,11,128],Key ' Map of the keypad legends for numeric output
' **To convert the output to an ascii value comment the line above and uncomment the line below
'	Lookup Key,["1","2","3","4","5","6","7","8","9","*","0","#",32],Key ' Map of the keypad legends for ascii output
	Return					' Exit from the subroutine

' This subroutine scans the Columns
' The bit, "FLAG" returns a 1 if a key is pressed, and 0 if no key pressed
' Also, if no key is pressed the variable "KEY" will return with the value of 12
ScanCol:
	Flag=1					' Set Flag initially to 1
	If PortB.0=0 then S_Exit		' Return if a key on the first column is pressed
	Key=Key+1				' Else increment KEY, and try another row
	If PortB.1=0 then S_Exit		' Return if a key on the second column is pressed
	Key=Key+1				' Else increment KEY, and try another row
	If PortB.2=0 then S_Exit		' Return if a key on the third column is pressed
	Key=Key+1				' Else increment KEY, KEY now equals 12
	Flag=0					' Set the flag to indicate no key pressed
S_Exit:	Return					' And exit the subroutine


