' Program KEYTEST12.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' This program demonstrates the use of include file "Inkeys12.bas"
' It does exactly the same as "KEYPAD12.BAS" but with less clutter in the code
' Also all the variables used within the subroutine are already declared.

	Include "Modedefs.Bas"
	Include "Inkeys12.Inc"			' Load in the keypad scan subroutine

' ** Set Xtal Value in Mhz **

	Define	OSC		4		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortB		' Debug PortB
	Define	DEBUG_BIT	7		' *** Debug pin Bit-7 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode to Inverted
	Define	DEBUG_PACING	200		' Delay 'in us' between characters sent

' ** Declare Variables **

'    THEY ARE ALREADY PRE_DECLARED WITHIN THE INKEYS SUBROUTINE

' ** Declare Constants **

	I		Con	254		' Control byte for LCD
	Clr		Con	1		' Code to clear the LCD
	Line1		Con	128		' Point to Line 1 of the LCD
	Line2		Con	192		' Point to Line 2 of the LCD


' ** The Main program starts here **

	Pause 200				' Wait for Pic to initialise
	Debug I,Clr:Pause 30			' Clear the LCD
	Debug I,Line1,"Key Pressed "		' Print to the first line of the LCD

Main:	'Gosub Inkeys				' Scan the keypad, Using a gosub
@	Inkeys Key,Debounce			' Scan the keypad, Using the macro "INKEYS"
	If Debounce=1 then goto Main		' Loop back if the button is still pressed
	Debug I,Line1+12,#Key,"   "		' Display the Key value
	Goto Main				' Do it all again!

