' Program SPI_TST.BAS
' *************************************************************
' * For use with EXPERIMENTING WITH THE PICBASIC PRO COMPILER *
' *							      *
' *  This source code may be freely used within your own      *
' *  programs. However, if it is used for profitable reasons, *
' *        please give credit where credit is due.	      *
' *  And make a reference to myself or Rosetta Technologies   *
' *							      *
' *			Les. Johnson			      *
' *************************************************************
'
' Write to the first 11 locations of a MICROCHIP 25LC640 SPI serial eeprom
' Then Read the 11 locations back and display them on a serial LCD
' Using the include file 25XXXX.INC.

' To WRITE to the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' The byte to write is loaded into the variable "E_BYTEOUT"
' And a call is made to the subroutine "EWRITE"

' To READ from the eeprom:-
' The 16-bit address is loaded into the variable "ADDR"
' And a call is made to the subroutine "EREAD"
' The byte at the specified address is returned in the variable "E_BYTEIN"

' NOTE: The main program must assign the Interface lines to the relevent PIC pins,
' Before the Include file is loaded. 
' i.e. 	
'	CS		Var	PortB.0		' Assign the CS line to PortB.0
'	SCK    		Var     PortB.1         ' Assign the SCK line to PortB.1
'	SI    		Var     PortB.2         ' Assign the SI line to PortB.2
'
'	Include "25XXXX.INC"

' ** The SO line is automatically assigned to the same pin as the SI line. **

	Include "Modedefs.Bas"

' ** Setup the Crystal Frequency, in Mhz **

	Define 	OSC		4		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PORT ?
	Define	DEBUG_BIT	0		' *** Debug pin Bit ? ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	300		' Delay 'in uS' between characters sent

' ** Define LCD Constants **

	I		Con	254		' Control Byte
	Clr		Con	1		' Clear the display
	Line1		Con	128		' Point to beginning of line 1
	Line2		Con	192		' Point to beginning of line 2
	Line3		Con	148		' Point to beginning of line 3
	Line4		Con	212		' Point to beginning of line 4

' ** Define the Pin assignments **
	CS      	Var     PortB.0         ' Assign the Chip select pin
	SCK     	Var     PortB.1         ' Assign the Clock pin
	SI      	Var     PortB.2         ' Assign the Data-in pin

	Include "25XXXX.INC"			' Load the eeprom subroutines

' ** THE MAIN PROGRAM STARTS HERE **

' Write the string, "HELLO WORLD" into the first 11 address's of the Eeprom

        For Addr=0 To 10                	' Create a loop of 11
	Lookup Addr,["H","E","L","L","O"," ","W","O","R","L","D"],E_ByteOut' Build up the string
	Gosub EWrite				' Write the byte to the Eeprom
        Next					' Close the Loop

' Read the first 11 address's within the Eeprom and display them on the LCD

Again:  Debug I,Clr:Pause 30			' Clear the LCD
	Pause 500				' Pause for drama
	For Addr=0 To 10        		' Create a loop of 11
	Gosub ERead				' Read the byte from the Eeprom
        Debug E_ByteIn  			' Display the characters read in from the eeprom
	Pause 300				' Pause between characters being displayed
        Next					' Close the loop
        Goto Again				' Do it forever

